/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.forge.transfer;

import fr.frinn.custommachinery.common.component.ItemMachineComponent;
import fr.frinn.custommachinery.common.component.handler.ItemComponentHandler;
import fr.frinn.custommachinery.forge.transfer.ItemSlot;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidedItemHandler
implements IItemHandler {
    @Nullable
    private final Direction direction;
    private final ItemComponentHandler handler;
    private final List<ItemSlot> slots;

    public SidedItemHandler(@Nullable Direction direction, ItemComponentHandler handler) {
        this.direction = direction;
        this.handler = handler;
        this.slots = handler.getComponents().stream().map(component -> new ItemSlot((ItemMachineComponent)component, direction)).toList();
    }

    public List<ItemSlot> getSlotList() {
        return this.slots;
    }

    public int getSlots() {
        return this.handler.getComponents().size();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return ((ItemMachineComponent)this.handler.getComponents().get(slot)).getItemStack();
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        ItemMachineComponent component = (ItemMachineComponent)this.handler.getComponents().get(slot);
        if (this.direction != null && !component.getConfig().getSideMode(this.direction).isInput()) {
            return stack;
        }
        int maxInsert = component.insert(stack.m_41720_(), stack.m_41613_(), stack.m_41783_(), true);
        if (!simulate) {
            component.insert(stack.m_41720_(), maxInsert, stack.m_41783_(), false);
            this.handler.getManager().markDirty();
        }
        ItemStack stackRemaining = stack.m_41777_();
        stackRemaining.m_41774_(maxInsert);
        return stackRemaining;
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemMachineComponent component = (ItemMachineComponent)this.handler.getComponents().get(slot);
        if (this.direction != null && !component.getConfig().getSideMode(this.direction).isOutput() || component.getItemStack().m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = component.getItemStack().m_41777_();
        stack.m_41764_(Math.min(component.getItemStack().m_41613_(), amount));
        if (!simulate) {
            component.extract(stack.m_41613_(), false);
            this.handler.getManager().markDirty();
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return ((ItemMachineComponent)this.handler.getComponents().get(slot)).getCapacity();
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return ((ItemMachineComponent)this.handler.getComponents().get(slot)).isItemValid(stack);
    }
}

