/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.architectury.registry.registries.Registrar;
import fr.frinn.custommachinery.api.ICustomMachineryAPI;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.ProcessorType;
import fr.frinn.custommachinery.api.guielement.GuiElementType;
import fr.frinn.custommachinery.api.machine.MachineAppearanceProperty;
import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class RegistrarCodec<V>
implements NamedCodec<V> {
    public static final NamedCodec<Item> ITEM = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.registrar(Registry.f_122904_), false);
    public static final NamedCodec<Block> BLOCK = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.registrar(Registry.f_122901_), false);
    public static final NamedCodec<Fluid> FLUID = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.registrar(Registry.f_122899_), false);
    public static final NamedCodec<EntityType<?>> ENTITY = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.registrar(Registry.f_122903_), false);
    public static final NamedCodec<Enchantment> ENCHANTMENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.registrar(Registry.f_122902_), false);
    public static final NamedCodec<MobEffect> EFFECT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.registrar(Registry.f_122900_), false);
    public static final NamedCodec<MachineComponentType<?>> MACHINE_COMPONENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.componentRegistrar(), true);
    public static final NamedCodec<RequirementType<?>> REQUIREMENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.requirementRegistrar(), true);
    public static final NamedCodec<GuiElementType<?>> GUI_ELEMENT = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.guiElementRegistrar(), true);
    public static final NamedCodec<MachineAppearanceProperty<?>> APPEARANCE_PROPERTY = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.appearancePropertyRegistrar(), true);
    public static final NamedCodec<DataType<?, ?>> DATA = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.dataRegistrar(), true);
    public static final NamedCodec<ProcessorType<?>> CRAFTING_PROCESSOR = RegistrarCodec.of(ICustomMachineryAPI.INSTANCE.processorRegistrar(), true);
    public static final NamedCodec<ResourceLocation> CM_LOC_CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            if (s.contains(":")) {
                return DataResult.success((Object)new ResourceLocation(s));
            }
            return DataResult.success((Object)new ResourceLocation(ICustomMachineryAPI.INSTANCE.modid(), s));
        }
        catch (Exception e) {
            return DataResult.error((String)e.getMessage());
        }
    }, ResourceLocation::toString, "CM Resource location");
    private final Registrar<V> registrar;
    private final boolean isCM;

    public static <V> RegistrarCodec<V> of(Registrar<V> registrar, boolean isCM) {
        return new RegistrarCodec<V>(registrar, isCM);
    }

    private RegistrarCodec(Registrar<V> registrar, boolean isCM) {
        this.registrar = registrar;
        this.isCM = isCM;
    }

    @Override
    public <T> DataResult<Pair<V, T>> decode(DynamicOps<T> ops, T input) {
        return (this.isCM ? CM_LOC_CODEC : DefaultCodecs.RESOURCE_LOCATION).decode(ops, input).flatMap(keyValuePair -> !this.registrar.contains((ResourceLocation)keyValuePair.getFirst()) ? DataResult.error((String)("Unknown registry key in " + this.registrar.key() + ": " + keyValuePair.getFirst())) : DataResult.success((Object)keyValuePair.mapFirst(arg_0 -> this.registrar.get(arg_0))));
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, V input, T prefix) {
        return DefaultCodecs.RESOURCE_LOCATION.encode(ops, this.registrar.getId(input), prefix);
    }

    @Override
    public String name() {
        return this.registrar.key().m_135782_().toString();
    }
}

