/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.codec;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.datafixers.util.Unit;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.RecordBuilder;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import java.util.Map;

public class UnboundedMapCodec<K, V>
implements NamedCodec<Map<K, V>> {
    private final NamedCodec<K> keyCodec;
    private final NamedCodec<V> valueCodec;
    private final String name;

    public static <K, V> UnboundedMapCodec<K, V> of(NamedCodec<K> keyCodec, NamedCodec<V> valueCodec, String name) {
        return new UnboundedMapCodec<K, V>(keyCodec, valueCodec, name);
    }

    private UnboundedMapCodec(NamedCodec<K> keyCodec, NamedCodec<V> valueCodec, String name) {
        this.keyCodec = keyCodec;
        this.valueCodec = valueCodec;
        this.name = name;
    }

    @Override
    public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        return ops.getMap(input).flatMap(map -> {
            ImmutableMap.Builder read = ImmutableMap.builder();
            ImmutableList.Builder failed = ImmutableList.builder();
            DataResult result = map.entries().reduce(DataResult.success((Object)Unit.INSTANCE, (Lifecycle)Lifecycle.stable()), (r, pair) -> {
                DataResult<K> k = this.keyCodec.read(ops, pair.getFirst());
                DataResult<V> v = this.valueCodec.read(ops, pair.getSecond());
                DataResult entry = k.apply2stable(Pair::of, v);
                entry.error().ifPresent(e -> failed.add(pair));
                return r.apply2stable((u, p) -> {
                    read.put(p.getFirst(), p.getSecond());
                    return u;
                }, entry);
            }, (r1, r2) -> r1.apply2stable((u1, u2) -> u1, r2));
            ImmutableMap elements = read.build();
            Object errors = ops.createMap(failed.build().stream());
            return result.map(arg_0 -> UnboundedMapCodec.lambda$decode$5((Map)elements, arg_0)).setPartial((Object)elements).mapError(e -> e + " missed input: " + errors);
        }).map(r -> Pair.of((Object)r, (Object)input));
    }

    @Override
    public <T> DataResult<T> encode(DynamicOps<T> ops, Map<K, V> input, T prefix) {
        RecordBuilder builder = ops.mapBuilder();
        for (Map.Entry<K, V> entry : input.entrySet()) {
            builder.add(this.keyCodec.encodeStart(ops, entry.getKey()), this.valueCodec.encodeStart(ops, entry.getValue()));
        }
        return builder.build(prefix);
    }

    @Override
    public String name() {
        return this.name;
    }

    private static /* synthetic */ Map lambda$decode$5(Map elements, Unit unit) {
        return elements;
    }
}

