/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.component.config;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.impl.codec.EnumMapCodec;
import fr.frinn.custommachinery.impl.component.config.RelativeSide;
import fr.frinn.custommachinery.impl.component.config.SideMode;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.logging.log4j.util.TriConsumer;

public class SideConfig {
    private final Map<RelativeSide, SideMode> sides = new HashMap<RelativeSide, SideMode>();
    private final ISideConfigComponent component;
    private boolean autoInput;
    private boolean autoOutput;
    private final boolean enabled;
    private TriConsumer<RelativeSide, SideMode, SideMode> callback;

    public SideConfig(ISideConfigComponent component, Map<RelativeSide, SideMode> defaultConfig, boolean autoInput, boolean autoOutput, boolean enabled) {
        this.component = component;
        this.sides.putAll(defaultConfig);
        this.autoInput = autoInput;
        this.autoOutput = autoOutput;
        this.enabled = enabled;
    }

    private Direction facing() {
        return (Direction)this.component.getManager().getTile().m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    public ISideConfigComponent getComponent() {
        return this.component;
    }

    public SideMode getSideMode(RelativeSide side) {
        return this.sides.get((Object)side);
    }

    public SideMode getSideMode(Direction direction) {
        return this.getSideMode(RelativeSide.fromDirections(this.facing(), direction));
    }

    public void setSideMode(RelativeSide side, SideMode mode) {
        SideMode oldMode = this.sides.put(side, mode);
        if (this.callback != null && !this.getComponent().getManager().getLevel().m_5776_()) {
            this.callback.accept((Object)side, (Object)oldMode, (Object)mode);
        }
    }

    public boolean isAutoInput() {
        return this.autoInput;
    }

    public boolean isAutoOutput() {
        return this.autoOutput;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setAutoInput(boolean autoInput) {
        this.autoInput = autoInput;
    }

    public void setAutoOutput(boolean autoOutput) {
        this.autoOutput = autoOutput;
    }

    public void set(SideConfig config) {
        for (RelativeSide side : RelativeSide.values()) {
            this.setSideMode(side, config.getSideMode(side));
        }
        this.setAutoInput(config.isAutoInput());
        this.setAutoOutput(config.isAutoOutput());
    }

    public void setCallback(TriConsumer<RelativeSide, SideMode, SideMode> callback) {
        this.callback = callback;
    }

    public SideConfig copy() {
        return new SideConfig(this.component, this.sides, this.autoInput, this.autoOutput, this.enabled);
    }

    public Tag serialize() {
        CompoundTag nbt = new CompoundTag();
        this.sides.forEach((side, mode) -> nbt.m_128365_(side.name(), (Tag)ByteTag.m_128266_((byte)((byte)mode.ordinal()))));
        nbt.m_128379_("input", this.autoInput);
        nbt.m_128379_("output", this.autoOutput);
        return nbt;
    }

    public void deserialize(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag nbt = (CompoundTag)tag;
            for (RelativeSide side : RelativeSide.values()) {
                Tag tag2 = nbt.m_128423_(side.name());
                if (!(tag2 instanceof ByteTag)) continue;
                ByteTag byteTag = (ByteTag)tag2;
                this.sides.put(side, SideMode.values()[byteTag.m_7047_()]);
            }
            this.autoInput = nbt.m_128471_("input");
            this.autoOutput = nbt.m_128471_("output");
        }
    }

    public static class Template {
        public static final NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group(EnumMapCodec.of(RelativeSide.class, SideMode.CODEC, SideMode.BOTH).forGetter(template -> template.sides), NamedCodec.BOOL.optionalFieldOf("input", false).forGetter(template -> template.autoInput), NamedCodec.BOOL.optionalFieldOf("output", false).forGetter(template -> template.autoOutput), NamedCodec.BOOL.optionalFieldOf("enabled", true).forGetter(template -> template.enabled)).apply((Applicative)templateInstance, Template::new), "Side Config Template");
        public static final Template DEFAULT_ALL_BOTH = Template.makeDefault(SideMode.BOTH, true);
        public static final Template DEFAULT_ALL_INPUT = Template.makeDefault(SideMode.INPUT, true);
        public static final Template DEFAULT_ALL_OUTPUT = Template.makeDefault(SideMode.OUTPUT, true);
        public static final Template DEFAULT_ALL_NONE = Template.makeDefault(SideMode.NONE, true);
        public static final Template DEFAULT_ALL_NONE_DISABLED = Template.makeDefault(SideMode.NONE, false);
        private final Map<RelativeSide, SideMode> sides;
        private final boolean autoInput;
        private final boolean autoOutput;
        private final boolean enabled;

        private static Template makeDefault(SideMode defaultMode, boolean enabled) {
            EnumMap map = Maps.newEnumMap(RelativeSide.class);
            for (RelativeSide side : RelativeSide.values()) {
                map.put(side, defaultMode);
            }
            return new Template(map, false, false, enabled);
        }

        private Template(Map<RelativeSide, SideMode> sides, boolean autoInput, boolean autoOutput, boolean enabled) {
            this.sides = sides;
            this.autoInput = autoInput;
            this.autoOutput = autoOutput;
            this.enabled = enabled;
        }

        public <T extends ISideConfigComponent> SideConfig build(T component) {
            return new SideConfig(component, this.sides, this.autoInput, this.autoOutput, this.enabled);
        }
    }
}

