/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.integration.jei;

import net.minecraft.util.Mth;

public class Experience {
    private int xp;
    private final int capacity;
    private final double chance;
    private final boolean isPerTick;
    private final Form type;
    private int experienceLevel = 0;

    public Experience(int xp, int capacity, double chance, boolean isPerTick, Form type) {
        this.xp = xp;
        this.capacity = capacity;
        this.chance = chance;
        this.isPerTick = isPerTick;
        this.type = type;
    }

    public Experience(int xp, int capacity, Form type) {
        this(xp, capacity, 1.0, false, type);
    }

    public Experience(int xp, Form type) {
        this(xp, xp, 1.0, false, type);
    }

    public Experience(int xp, double chance, boolean isPerTick, Form type) {
        this(xp, xp, chance, isPerTick, type);
    }

    public Experience(int xp, int capacity, double chance, Form type) {
        this(xp, capacity, chance, false, type);
    }

    public Experience(int xp, double chance, Form type) {
        this(xp, xp, chance, false, type);
    }

    public Experience(int xp, int capacity, boolean isPerTick, Form type) {
        this(xp, capacity, 1.0, isPerTick, type);
    }

    public Experience(int xp, boolean isPerTick, Form type) {
        this(xp, xp, 1.0, isPerTick, type);
    }

    public int getXp() {
        return this.xp;
    }

    public int getLevels() {
        return this.experienceLevel;
    }

    public void setXp(int xp) {
        this.xp = xp;
        this.experienceLevel = this.getFromExperiencePoints(this.xp);
    }

    public void addXp(int xp) {
        this.xp += xp;
        this.experienceLevel = this.getFromExperiencePoints(this.xp);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public double getChance() {
        return this.chance;
    }

    public boolean isPerTick() {
        return this.isPerTick;
    }

    public boolean isLevels() {
        return this.type == Form.LEVEL;
    }

    public boolean isPoints() {
        return this.type == Form.POINT;
    }

    public Form getForm() {
        return this.type;
    }

    private int getXpNeededForNextLevel(int experienceLevel) {
        if (experienceLevel >= 30) {
            return 112 + (experienceLevel - 30) * 9;
        }
        return experienceLevel >= 15 ? 37 + (experienceLevel - 15) * 5 : 7 + experienceLevel * 2;
    }

    private int getFromExperiencePoints(int xp) {
        int experienceLevel = 0;
        xp = Mth.m_14045_((int)xp, (int)0, (int)Integer.MAX_VALUE);
        float experienceProgress = (float)xp / (float)this.getXpNeededForNextLevel(experienceLevel);
        while (experienceProgress < 0.0f) {
            float f = experienceProgress * (float)this.getXpNeededForNextLevel(experienceLevel);
            if (experienceLevel > 0) {
                experienceProgress = 1.0f + f / (float)this.getXpNeededForNextLevel(--experienceLevel);
                continue;
            }
            --experienceLevel;
            experienceProgress = 0.0f;
        }
        while (experienceProgress >= 1.0f) {
            experienceProgress = (experienceProgress - 1.0f) * (float)this.getXpNeededForNextLevel(experienceLevel);
            experienceProgress /= (float)this.getXpNeededForNextLevel(++experienceLevel);
        }
        return experienceLevel;
    }

    public static enum Form {
        LEVEL,
        POINT;


        public boolean isLevel() {
            return this == LEVEL;
        }

        public boolean isPoint() {
            return this == POINT;
        }
    }
}

