/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import com.mojang.serialization.DataResult;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.util.Range;
import fr.frinn.custommachinery.impl.util.Restriction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class IntRange
extends Range<Integer> {
    public static final NamedCodec<IntRange> CODEC = NamedCodec.STRING.comapFlatMap(s -> {
        try {
            return DataResult.success((Object)IntRange.createFromString(s));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error((String)e.getMessage());
        }
    }, Range::toString, "Integer range");
    private static final Map<String, IntRange> CACHE_SPEC = Collections.synchronizedMap(new WeakHashMap());
    private static final Restriction<Integer> EVERYTHING = new Restriction<Object>(null, false, null, false);
    public static final IntRange ALL = new IntRange(Collections.singletonList(EVERYTHING));

    private IntRange(List<Restriction<Integer>> restrictions) {
        super(restrictions);
    }

    public static IntRange createFromString(String spec) throws IllegalArgumentException {
        if (spec == null) {
            throw new IllegalArgumentException("Can't parse an integer range fromm a null String");
        }
        if (spec.isEmpty() || spec.equals("*")) {
            return ALL;
        }
        IntRange cached = CACHE_SPEC.get(spec);
        if (cached != null) {
            return cached;
        }
        ArrayList<Restriction<Integer>> restrictions = new ArrayList<Restriction<Integer>>();
        String process = spec;
        Integer upperBound = null;
        Integer lowerBound = null;
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if ((index2 < 0 || index1 < index2) && index1 >= 0) {
                index = index1;
            }
            if (index < 0) {
                throw new IllegalArgumentException("Unbounded range: \"" + spec + "\"");
            }
            Restriction<Integer> restriction = IntRange.parseRestriction(process.substring(0, index + 1));
            if (lowerBound == null) {
                lowerBound = restriction.lowerBound();
            }
            if (upperBound != null && (restriction.lowerBound() == null || restriction.lowerBound().compareTo(upperBound) < 0)) {
                throw new IllegalArgumentException("Ranges overlap: \"" + spec + "\"");
            }
            restrictions.add(restriction);
            upperBound = restriction.upperBound();
            if (!(process = process.substring(index + 1).trim()).startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (process.length() > 0) {
            if (restrictions.size() > 0) {
                throw new IllegalArgumentException("Only fully-qualified sets allowed in multiple set scenario: \"" + spec + "\"");
            }
            try {
                int bound = (int)Double.parseDouble(process);
                restrictions.add(new Restriction<Integer>(bound, true, bound, true));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid integer range, \"" + process + "\" is not a number");
            }
        }
        cached = new IntRange((List<Restriction<Integer>>)restrictions);
        CACHE_SPEC.put(spec, cached);
        return cached;
    }

    public static IntRange of(Object o) throws IllegalArgumentException {
        if (o == null) {
            throw new IllegalArgumentException("Cannot build IntRange from null");
        }
        if (o instanceof CharSequence) {
            CharSequence string = (CharSequence)o;
            return IntRange.createFromString(string.toString());
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return new IntRange(Collections.singletonList(new Restriction<Integer>(number.intValue(), true, number.intValue(), true)));
        }
        throw new IllegalArgumentException("Cannot build IntRange from " + o);
    }

    private static Restriction<Integer> parseRestriction(String spec) throws IllegalArgumentException {
        Restriction<Integer> restriction;
        boolean lowerBoundInclusive = spec.startsWith("[");
        boolean upperBoundInclusive = spec.endsWith("]");
        String process = spec.substring(1, spec.length() - 1).trim();
        int index = process.indexOf(44);
        if (index < 0) {
            if (!lowerBoundInclusive || !upperBoundInclusive) {
                throw new IllegalArgumentException("Single version must be surrounded by []: " + spec);
            }
            Integer version = Integer.parseInt(process);
            restriction = new Restriction<Integer>(version, lowerBoundInclusive, version, upperBoundInclusive);
        } else {
            String upperBound;
            String lowerBound = process.substring(0, index).trim();
            if (lowerBound.equals(upperBound = process.substring(index + 1).trim())) {
                throw new IllegalArgumentException("Range cannot have identical boundaries: " + spec);
            }
            Integer lowerVersion = null;
            if (lowerBound.length() > 0) {
                lowerVersion = Integer.parseInt(lowerBound);
            }
            Integer upperVersion = null;
            if (upperBound.length() > 0) {
                upperVersion = Integer.parseInt(upperBound);
            }
            if (upperVersion != null && lowerVersion != null && upperVersion.compareTo(lowerVersion) < 0) {
                throw new IllegalArgumentException("Range defies version ordering: " + spec);
            }
            restriction = new Restriction<Integer>(lowerVersion, lowerBoundInclusive, upperVersion, upperBoundInclusive);
        }
        return restriction;
    }
}

