/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinery.impl.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.codec.NamedMapCodec;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;

public class TextComponentUtils {
    public static final NamedCodec<TextColor> COLOR_CODEC = NamedCodec.STRING.comapFlatMap(encoded -> {
        TextColor color = TextColor.m_131268_((String)encoded);
        if (color != null) {
            return DataResult.success((Object)color);
        }
        return DataResult.error((String)("Invalid color: " + encoded));
    }, TextColor::m_131274_, "Text color");
    public static final NamedMapCodec<Style> STYLE_CODEC = NamedCodec.record(styleInstance -> styleInstance.group(NamedCodec.BOOL.optionalFieldOf("bold", false).forGetter(Style::m_131154_), NamedCodec.BOOL.optionalFieldOf("italic", false).forGetter(Style::m_131161_), NamedCodec.BOOL.optionalFieldOf("underlined", false).forGetter(Style::m_131171_), NamedCodec.BOOL.optionalFieldOf("strikethrough", false).forGetter(Style::m_131168_), NamedCodec.BOOL.optionalFieldOf("obfuscated", false).forGetter(Style::m_131176_), COLOR_CODEC.optionalFieldOf("color").forGetter(style -> Optional.ofNullable(style.m_131135_())), DefaultCodecs.RESOURCE_LOCATION.optionalFieldOf("font", new ResourceLocation("default")).forGetter(Style::m_131192_)).apply((Applicative)styleInstance, (bold, italic, underlined, strikethrough, obfuscated, color, font) -> Style.f_131099_.m_131136_(bold).m_131155_(italic).m_131162_(underlined).m_178522_(strikethrough).m_178524_(obfuscated).m_131148_((TextColor)color.orElse(null)).m_131150_(font)), "Style");
    public static final NamedCodec<Component> TEXT_COMPONENT_CODEC = NamedCodec.record(iTextComponentInstance -> iTextComponentInstance.group(NamedCodec.STRING.fieldOf("text").forGetter(TextComponentUtils::getString), STYLE_CODEC.forGetter(Component::m_7383_), NamedCodec.lazy(TextComponentUtils::getCodec, "Text component").listOf().optionalFieldOf("childrens", Collections.emptyList()).forGetter(Component::m_7360_)).apply((Applicative)iTextComponentInstance, (text, style, childrens) -> {
        MutableComponent component = Component.m_237115_((String)text);
        component.m_6270_(style);
        childrens.forEach(arg_0 -> ((MutableComponent)component).m_7220_(arg_0));
        return component;
    }), "Text component");
    public static final NamedCodec<Component> CODEC = NamedCodec.either(TEXT_COMPONENT_CODEC, NamedCodec.STRING).xmap(either -> (Component)either.map(Function.identity(), Component::m_237115_), Either::left, "Text component");

    public static String toJsonString(Component component) {
        DataResult result = TEXT_COMPONENT_CODEC.encodeStart(JsonOps.INSTANCE, component);
        return result.result().map(JsonElement::toString).orElse("");
    }

    public static Component fromJsonString(String jsonString) {
        JsonElement json = JsonParser.parseString((String)jsonString);
        return TEXT_COMPONENT_CODEC.decode(JsonOps.INSTANCE, json).result().map(Pair::getFirst).orElse((Component)Component.m_237119_());
    }

    private static NamedCodec<Component> getCodec() {
        return TEXT_COMPONENT_CODEC;
    }

    private static String getString(Component component) {
        ComponentContents contents = component.m_214077_();
        if (contents instanceof LiteralContents) {
            LiteralContents literal = (LiteralContents)contents;
            return literal.f_237368_();
        }
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)contents;
            return translatable.m_237508_();
        }
        return component.getString();
    }
}

