/*
 * Decompiled with CFR 0.152.
 */
package de.sarenor.arsinstrumentum.client;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.client.gui.GuiManaHUD;
import com.hollingsworth.arsnouveau.client.gui.book.GuiSpellBook;
import com.hollingsworth.arsnouveau.common.capability.CapabilityRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import de.sarenor.arsinstrumentum.items.curios.NumericCharm;
import de.sarenor.arsinstrumentum.setup.ArsInstrumentumConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="ars_instrumentum", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NumericManaHUD
extends GuiComponent {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final ResourceLocation hudLoc = new ResourceLocation("ars_nouveau", "mana_hud");

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderSpellHUD(RenderGuiOverlayEvent.Post event) {
        LocalPlayer player = NumericManaHUD.minecraft.f_91074_;
        if (player == null || !event.getOverlay().id().equals((Object)hudLoc)) {
            return;
        }
        if (NumericCharm.hasCharm((Player)player)) {
            if (((Boolean)ArsInstrumentumConfig.Client.SHOW_MANA_ON_TOP.get()).booleanValue()) {
                NumericManaHUD.drawTopHUD(event.getPoseStack(), (Player)player);
            } else {
                ArsNouveauAPI.ENABLE_DEBUG_NUMBERS = true;
            }
        }
    }

    private static void drawTopHUD(PoseStack ms, Player player) {
        IManaCap mana = (IManaCap)CapabilityRegistry.getMana((LivingEntity)player).orElse(null);
        if (!GuiManaHUD.shouldDisplayBar() || mana == null) {
            return;
        }
        ArsNouveauAPI.getInstance();
        ArsNouveauAPI.ENABLE_DEBUG_NUMBERS = false;
        boolean renderOnTop = true;
        int offsetLeft = 10;
        int height = minecraft.m_91268_().m_85446_() - 15;
        int max = mana.getMaxMana();
        int current = (int)mana.getCurrentMana();
        String delimiter = "/";
        String textMax = max + delimiter + max;
        String text = current + delimiter + max;
        int maxWidth = NumericManaHUD.minecraft.f_91062_.m_92895_(textMax);
        NumericManaHUD.m_93236_((PoseStack)ms, (Font)NumericManaHUD.minecraft.f_91062_, (String)text, (int)(offsetLeft += maxWidth - NumericManaHUD.minecraft.f_91062_.m_92895_(text)), (int)(height -= 25), (int)0xFFFFFF);
    }

    @SubscribeEvent
    public static void drawTopGui(ScreenEvent event) {
        if (event.getScreen() instanceof GuiSpellBook && ((Boolean)ArsInstrumentumConfig.Client.SHOW_MANA_ON_TOP.get()).booleanValue() && NumericManaHUD.minecraft.f_91074_ != null && NumericCharm.hasCharm((Player)NumericManaHUD.minecraft.f_91074_)) {
            ArsNouveauAPI.ENABLE_DEBUG_NUMBERS = true;
        }
    }
}

