/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.world.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import mekanism.additions.common.config.AdditionsConfig;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.baby.BabyType;
import mekanism.additions.common.registries.AdditionsStructureModifierSerializers;
import mekanism.common.Mekanism;
import mekanism.common.util.RegistryUtils;
import net.minecraft.core.Holder;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.world.ModifiableStructureInfo;
import net.minecraftforge.common.world.StructureModifier;
import net.minecraftforge.common.world.StructureSettingsBuilder;

public record BabyEntitySpawnStructureModifier(BabyType babyType, AdditionsConfig.SpawnConfig spawnConfig) implements StructureModifier
{
    public BabyEntitySpawnStructureModifier(BabyType babyType) {
        this(babyType, MekanismAdditionsConfig.additions.getConfig(babyType));
    }

    public void modify(Holder<Structure> structure, StructureModifier.Phase phase, ModifiableStructureInfo.StructureInfo.Builder builder) {
        if (phase == StructureModifier.Phase.REMOVE && this.spawnConfig.shouldSpawn.get()) {
            StructureSettingsBuilder structureSettings = builder.getStructureSettings();
            StructureSettingsBuilder.StructureSpawnOverrideBuilder spawnOverrides = structureSettings.getSpawnOverrides(MobCategory.MONSTER);
            ResourceLocation structureName = BuiltinRegistries.f_235988_.m_7981_((Object)((Structure)structure.get()));
            if (spawnOverrides != null && !((List)this.spawnConfig.structureBlackList.get()).contains(structureName)) {
                for (MobSpawnSettings.SpawnerData spawner : this.spawnConfig.getSpawnersToAdd(spawnOverrides.getSpawns())) {
                    spawnOverrides.addSpawn(spawner);
                    Mekanism.logger.debug("Adding spawn rate for '{}' in structure '{}', with weight: {}, minSize: {}, maxSize: {}", new Object[]{RegistryUtils.getName((EntityType)spawner.f_48404_), structureName, spawner.m_142631_(), spawner.f_48405_, spawner.f_48406_});
                }
            }
        }
    }

    public Codec<? extends StructureModifier> codec() {
        return (Codec)AdditionsStructureModifierSerializers.SPAWN_BABIES.get();
    }

    public static Codec<BabyEntitySpawnStructureModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)BabyType.CODEC.fieldOf("babyType").forGetter(BabyEntitySpawnStructureModifier::babyType)).apply((Applicative)builder, BabyEntitySpawnStructureModifier::new));
    }
}

