/*
 * Decompiled with CFR 0.152.
 */
package appbot.botania;

import appbot.AppliedBotanics;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.IStorageMonitorableAccessor;
import appeng.api.storage.MEStorage;
import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.common.impl.corporea.AbstractCorporeaNode;

public class MECorporeaNode
extends AbstractCorporeaNode {
    private final IStorageMonitorableAccessor accessor;

    public MECorporeaNode(Level level, BlockPos pos, CorporeaSpark spark, IStorageMonitorableAccessor accessor) {
        super(level, pos, spark);
        this.accessor = accessor;
    }

    @Nullable
    public static CorporeaNode getNode(Level level, CorporeaSpark spark) {
        MEStorage storage;
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        IStorageMonitorableAccessor accessor = AppliedBotanics.getInstance().meStorage(serverLevel, spark.getAttachPos()).find(Direction.UP);
        if (accessor != null && (storage = accessor.getInventory(IActionSource.empty())) != null) {
            return new MECorporeaNode(level, spark.getAttachPos(), spark, accessor);
        }
        return null;
    }

    public List<ItemStack> countItems(CorporeaRequest request) {
        return this.work(request, false);
    }

    public List<ItemStack> extractItems(CorporeaRequest request) {
        return this.work(request, true);
    }

    protected List<ItemStack> work(CorporeaRequest request, boolean execute) {
        MEStorage storage;
        IActionSource source;
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        LivingEntity livingEntity = request.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            source = IActionSource.ofPlayer((Player)player);
            storage = this.accessor.getInventory(source);
        } else {
            source = IActionSource.empty();
            storage = this.accessor.getInventory(source);
        }
        if (storage == null) {
            return list;
        }
        for (Object2LongMap.Entry entry : storage.getAvailableStacks()) {
            int amount = Ints.saturatedCast((long)entry.getLongValue());
            Object object = entry.getKey();
            if (!(object instanceof AEItemKey)) continue;
            AEItemKey itemKey = (AEItemKey)object;
            ItemStack stack = itemKey.toStack();
            if (!request.getMatcher().test(stack)) continue;
            request.trackFound(amount);
            int remainder = Math.min(amount, request.getStillNeeded() == -1 ? amount : request.getStillNeeded());
            if (remainder <= 0) continue;
            request.trackSatisfied(remainder);
            if (execute) {
                if (!this.getSpark().isCreative()) {
                    remainder = (int)storage.extract((AEKey)entry.getKey(), (long)remainder, Actionable.MODULATE, source);
                }
                this.getSpark().onItemExtracted(stack);
                request.trackExtracted(remainder);
            }
            while (remainder > 0) {
                int taken = Math.min(remainder, stack.m_41741_());
                remainder -= taken;
                list.add(itemKey.toStack(taken));
            }
        }
        return list;
    }
}

