/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import net.acetheeldritchking.art_of_forging.capabilities.carnage.PlayerCarnageProvider;
import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class CarnageEffect {
    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(EffectGuiStats.carnageEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "art_of_forging.effect.carnage.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterInteger("art_of_forging.effect.carnage.tooltip", (IStatGetter)effectStatGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    @SubscribeEvent
    public void onLivingAttackEvent(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack heldStack;
        Item item;
        Entity attackingEntity = event.getSource().m_7639_();
        if (attackingEntity instanceof LivingEntity && (item = (heldStack = (attacker = (LivingEntity)attackingEntity).m_21205_()).m_41720_()) instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            int level = item2.getEffectLevel(heldStack, EffectGuiStats.carnageEffect);
            float eff = item2.getEffectEfficiency(heldStack, EffectGuiStats.carnageEffect);
            float baseAmount = event.getAmount();
            float bonusDamage = baseAmount * (eff / 100.0f);
            if (level > 0 && attacker instanceof Player) {
                Player player = (Player)attacker;
                player.getCapability(PlayerCarnageProvider.PLAYER_CARNAGE).ifPresent(carnage -> {
                    carnage.addCarnage(1);
                    switch (carnage.getCarnage()) {
                        case 1: {
                            event.setAmount(baseAmount);
                            break;
                        }
                        case 2: {
                            event.setAmount(baseAmount + bonusDamage);
                            break;
                        }
                        case 3: {
                            event.setAmount(baseAmount + bonusDamage + this.addedPercent(baseAmount, 0.1f));
                            break;
                        }
                        case 4: {
                            event.setAmount(baseAmount + bonusDamage + this.addedPercent(baseAmount, 0.2f));
                            break;
                        }
                        case 5: {
                            event.setAmount(baseAmount + bonusDamage + this.addedPercent(baseAmount, 0.3f));
                            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12363_, SoundSource.PLAYERS, 1.0f, 0.5f);
                        }
                    }
                });
            }
        }
    }

    private float addedPercent(float base, float added) {
        float total = base * added;
        return total;
    }
}

