/*
 * Decompiled with CFR 0.152.
 */
package net.acetheeldritchking.art_of_forging.effects;

import java.util.List;
import net.acetheeldritchking.art_of_forging.capabilities.soulCharge.PlayerSoulChargeProvider;
import net.acetheeldritchking.art_of_forging.effects.gui.EffectGuiStats;
import net.acetheeldritchking.art_of_forging.networking.AoFPackets;
import net.acetheeldritchking.art_of_forging.networking.packet.SoulChargedParticlesS2CPacket;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.workbench.gui.WorkbenchStatsGui;
import se.mickelus.tetra.effect.AbilityUseResult;
import se.mickelus.tetra.effect.ChargedAbilityEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatBar;
import se.mickelus.tetra.gui.stats.bar.GuiStatBase;
import se.mickelus.tetra.gui.stats.getter.IStatGetter;
import se.mickelus.tetra.gui.stats.getter.ITooltipGetter;
import se.mickelus.tetra.gui.stats.getter.LabelGetterBasic;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterInteger;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloStatsGui;

public class SoulChargedEffect
extends ChargedAbilityEffect {
    public static final SoulChargedEffect instance = new SoulChargedEffect();

    public SoulChargedEffect() {
        super(20, 0.15, 50, 8.0, EffectGuiStats.soulChargedEffect, ChargedAbilityEffect.TargetRequirement.either, UseAnim.BOW, "raised");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void init() {
        StatGetterEffectLevel effectStatGetter = new StatGetterEffectLevel(EffectGuiStats.soulChargedEffect, 1.0);
        GuiStatBar effectBar = new GuiStatBar(0, 0, 59, "art_of_forging.effect.soul_charged.name", 0.0, 30.0, false, (IStatGetter)effectStatGetter, LabelGetterBasic.integerLabel, (ITooltipGetter)new TooltipGetterInteger("art_of_forging.effect.soul_charged.tooltip", (IStatGetter)effectStatGetter));
        WorkbenchStatsGui.addBar((GuiStatBase)effectBar);
        HoloStatsGui.addBar((GuiStatBase)effectBar);
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        ModularItem item;
        int level;
        LivingEntity attacker;
        ItemStack heldStack;
        Item item2;
        Entity attackingEntity = event.getSource().m_7639_();
        if (attackingEntity instanceof LivingEntity && (item2 = (heldStack = (attacker = (LivingEntity)attackingEntity).m_21205_()).m_41720_()) instanceof ModularItem && (level = (item = (ModularItem)item2).getEffectLevel(heldStack, EffectGuiStats.soulChargedEffect)) >= 2 && attacker instanceof Player) {
            Player player = (Player)attacker;
            player.getCapability(PlayerSoulChargeProvider.PLAYER_SOUL_CHARGE).ifPresent(soul_charge -> {
                soul_charge.addSoulCharge(1);
                if (soul_charge.getSoulCharge() >= 5) {
                    player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11704_, SoundSource.PLAYERS, 1.0f, 0.8f);
                }
            });
        }
    }

    public void perform(Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec, int chargedTicks) {
        if (!target.f_19853_.m_5776_()) {
            attacker.getCapability(PlayerSoulChargeProvider.PLAYER_SOUL_CHARGE).ifPresent(soul_charge -> {
                double radius = 5.0;
                double height = 2.0;
                double attackerX = attacker.m_20185_();
                double attackerY = attacker.m_20227_(0.5);
                double attackerZ = attacker.m_20189_();
                int level = item.getEffectLevel(itemStack, EffectGuiStats.soulChargedEffect);
                float eff = item.getEffectEfficiency(itemStack, EffectGuiStats.soulChargedEffect);
                if (soul_charge.getSoulCharge() >= 5) {
                    soul_charge.resetSoulCharge();
                    AbilityUseResult result = this.doAoeAttack(radius, height, radius, level * 2, eff, attacker, hand, item, itemStack, target, hitVec);
                    this.playSoundsAndParticles(attackerX, attackerY, attackerZ, (ServerPlayer)attacker);
                }
            });
        }
        attacker.m_21011_(hand, false);
        attacker.m_36335_().m_41524_((Item)item, this.getCooldown(item, itemStack));
        item.tickProgression((LivingEntity)attacker, itemStack, 2);
        item.applyDamage(2, itemStack, (LivingEntity)attacker);
    }

    private AbilityUseResult doAoeAttack(double x, double y, double z, int seconds, float damage, Player attacker, InteractionHand hand, ItemModularHandheld item, ItemStack itemStack, LivingEntity target, Vec3 hitVec) {
        AbilityUseResult result = item.hitEntity(itemStack, attacker, target, 1.0, 1.0, 1.0f, 1.0f);
        if (result != AbilityUseResult.fail) {
            AABB aoeAttack = new AABB(hitVec, hitVec).m_82377_(x * 2.0, y, z * 2.0);
            List targets = attacker.f_19853_.m_45933_((Entity)attacker, aoeAttack);
            for (LivingEntity livingTargets : targets) {
                livingTargets.m_20254_(seconds);
                livingTargets.m_6469_(DamageSource.f_19319_, damage);
            }
        }
        return result;
    }

    @SubscribeEvent
    public void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        ItemStack heldStack = event.player.m_21205_();
        Item item = heldStack.m_41720_();
        if (item instanceof ModularItem) {
            ModularItem item2 = (ModularItem)item;
            int level = item2.getEffectLevel(heldStack, EffectGuiStats.soulChargedEffect);
            double posX = event.player.m_20185_();
            double posY = event.player.m_20227_(0.5);
            double posZ = event.player.m_20189_();
            if (level >= 2) {
                event.player.getCapability(PlayerSoulChargeProvider.PLAYER_SOUL_CHARGE).ifPresent(soul_charge -> {
                    if (soul_charge.getSoulCharge() >= 5) {
                        ServerLevel world = (ServerLevel)event.player.f_19853_;
                        world.m_8767_((ParticleOptions)ParticleTypes.f_123745_, posX, posY, posZ, 1, 0.5, 0.5, 0.5, 0.0);
                    }
                });
            }
        }
    }

    private void playSoundsAndParticles(double x, double y, double z, ServerPlayer player) {
        AoFPackets.sendToPlayer(new SoulChargedParticlesS2CPacket(x, y, z), player);
        player.f_19853_.m_6263_(null, x, y, z, SoundEvents.f_11705_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }
}

