/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot;

import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.creeperhost.blockshot.Auth;
import net.creeperhost.blockshot.BlockShotClient;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.Keybindings;
import net.creeperhost.blockshot.gui.GuiEvents;
import net.creeperhost.blockshot.lib.MTSessionProvider;
import net.creeperhost.blockshot.mixin.MixinMinecraft;
import net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.JWebToken;
import net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.MineTogetherSession;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.MessageSignature;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class BlockShot {
    public static final String MOD_ID = "blockshot";
    public static final Logger LOGGER = LogManager.getLogger();
    public static Path configLocation = Platform.getGameFolder().resolve("blockshot.json");
    private static boolean active = false;
    private static CompletableFuture<@Nullable JWebToken> tokenFuture;
    public static final MessageSignature CHAT_UPLOAD_ID;
    public static final MessageSignature CHAT_ENCODING_ID;

    public static void init() {
        if (Platform.getEnvironment().equals((Object)Env.CLIENT)) {
            LOGGER.info("Init");
            Config.init(configLocation.toFile());
            MineTogetherSession.getDefault().setProvider(new MTSessionProvider());
            tokenFuture = MineTogetherSession.getDefault().getTokenAsync();
            ClientLifecycleEvent.CLIENT_SETUP.register(instance -> BlockShot.clientStart());
        }
    }

    private static void clientStart() {
        try {
            JWebToken token = tokenFuture.get();
            if (token != null) {
                Auth.init(token);
                BlockShotClient.init();
                active = true;
            }
        }
        catch (InterruptedException | ExecutionException exception) {
            // empty catch block
        }
        if (!active) {
            LOGGER.error("BlockShot will not run in offline mode.");
        }
        if (active |= Platform.isDevelopmentEnvironment()) {
            GuiEvents.init();
            Keybindings.init();
        }
    }

    public static boolean isActive() {
        return active;
    }

    public static int getFPS() {
        return ((MixinMinecraft)Minecraft.m_91087_()).getfps();
    }

    static {
        CHAT_UPLOAD_ID = new MessageSignature(new byte[]{36, 3, 60});
        CHAT_ENCODING_ID = new MessageSignature(new byte[]{42, 4, 20});
    }
}

