/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.capture;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.List;
import javax.imageio.ImageIO;
import net.creeperhost.blockshot.BlockShot;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;

public interface Encoder {
    public void startOrStopRecording();

    public void updateCapture();

    public void cancelRecording();

    public boolean isWorking();

    public boolean showRecordIcon();

    public List<Component> getHudText();

    default public Component getStopText() {
        String screenshotKey = Minecraft.m_91087_().f_91066_.f_92102_.m_90863_().getString();
        return Component.m_237110_((String)"overlay.blockshot.finish", (Object[])new Object[]{screenshotKey}).m_130940_(ChatFormatting.GRAY);
    }

    default public Component getCancelText() {
        String screenshotKey = Minecraft.m_91087_().f_91066_.f_92102_.m_90863_().getString();
        return Component.m_237110_((String)"overlay.blockshot.cancel", (Object[])new Object[]{screenshotKey}).m_130940_(ChatFormatting.GRAY);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public BufferedImage toBufferedImage(NativeImage image, int targetWidth, int targetHeight) {
        try (NativeImage nativeImage = image;){
            BufferedImage bufferedImage;
            int width = image.m_84982_();
            int height = image.m_85084_();
            image.m_85122_();
            if (width > height) {
                ratio = (double)height / (double)width;
                targetHeight = (int)Math.round((double)targetWidth * ratio);
                if ((targetHeight & 1) != 0) {
                    ++targetHeight;
                }
            } else {
                ratio = (double)width / (double)height;
                targetWidth = (int)Math.round((double)targetHeight * ratio);
                if ((targetHeight & 1) != 0) {
                    ++targetHeight;
                }
            }
            try (NativeImage nativeImage2 = new NativeImage(targetWidth, targetHeight, false);){
                image.m_85034_(0, 0, width, height, nativeImage2);
                ByteArrayInputStream is = new ByteArrayInputStream(nativeImage2.m_85121_());
                BufferedImage finalFrame = new BufferedImage(targetWidth, targetHeight, 1);
                finalFrame.getGraphics().drawImage(ImageIO.read(is), 0, 0, null);
                bufferedImage = finalFrame;
            }
            return bufferedImage;
        }
        catch (Throwable t) {
            BlockShot.LOGGER.error("An error occurred while capturing frame", t);
            return null;
        }
    }
}

