/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.capture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.List;
import net.creeperhost.blockshot.Auth;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.capture.Encoder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class RecordingHandler {
    private static Encoder encoder;

    public static Encoder getEncoder() {
        if (Config.INSTANCE.getEncoderType().requiresPremium() && !Auth.hasPremium()) {
            Config.INSTANCE.setEncoderType(Config.EncoderType.GIF);
        }
        if (encoder == null) {
            RecordingHandler.setEncoder(Config.INSTANCE.getEncoderType().createEncoder());
        }
        return encoder;
    }

    public static boolean setEncoder(Encoder newEncoder) {
        if (encoder != null && encoder.isWorking()) {
            return false;
        }
        encoder = newEncoder;
        return true;
    }

    public static void handleScreenCapture() {
        if (!BlockShot.isActive() || !RecordingHandler.getEncoder().isWorking()) {
            return;
        }
        RecordingHandler.getEncoder().updateCapture();
        RecordingHandler.drawRecordingIndicator(5, 5);
    }

    private static void drawRecordingIndicator(int x, int y) {
        List<Component> hudLines = RecordingHandler.getEncoder().getHudText();
        if (hudLines == null || hudLines.isEmpty()) {
            return;
        }
        RenderSystem.m_69478_();
        PoseStack poseStack = new PoseStack();
        Font font = Minecraft.m_91087_().f_91062_;
        int recordOffset = RecordingHandler.getEncoder().showRecordIcon() ? 10 : 0;
        int maxWidth = 0;
        for (Component line : hudLines) {
            maxWidth = Math.max(maxWidth, font.m_92852_((FormattedText)line));
        }
        int height = hudLines.size() * 9 + 5;
        RecordingHandler.drawRect(poseStack, x, y, maxWidth + 6 + recordOffset, height, -1341124592);
        int i = 0;
        for (Component line : hudLines) {
            font.m_92889_(poseStack, line, (float)(x + 3 + recordOffset), (float)(y + 3 + i), 0xFFFFFF);
            i += 9;
        }
        if (System.currentTimeMillis() % 2000L > 1000L && RecordingHandler.getEncoder().showRecordIcon()) {
            RecordingHandler.drawRect(poseStack, x + 3, y + 4, 7, 5, -65536);
            RecordingHandler.drawRect(poseStack, x + 4, y + 3, 5, 7, -65536);
        }
        RenderSystem.m_69461_();
    }

    private static void drawRect(PoseStack poseStack, int x, int y, int width, int height, int colour) {
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_85982_(matrix4f, (float)x, (float)(y + height), 0.0f).m_193479_(colour).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)(x + width), (float)(y + height), 0.0f).m_193479_(colour).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)(x + width), (float)y, 0.0f).m_193479_(colour).m_5752_();
        bufferBuilder.m_85982_(matrix4f, (float)x, (float)y, 0.0f).m_193479_(colour).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

