/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.capture;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import dev.architectury.platform.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.function.Consumer;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.ClientUtil;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.WebUtils;
import net.creeperhost.blockshot.gui.BlockShotClickEvent;
import net.creeperhost.blockshot.lib.HistoryManager;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ScreenshotHandler {
    public static final Logger LOGGER = LogManager.getLogger();
    public static byte[] latest;

    public static boolean handleScreenshot(byte[] imageBytes) {
        latest = imageBytes;
        if (Config.INSTANCE.uploadMode == Config.Mode.PROMPT) {
            if (latest.length == 0) {
                return false;
            }
            MutableComponent confirmMessage = Component.m_237115_((String)"chat.blockshot.prompt.blockshot").m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"chat.blockshot.prompt.click_here").m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.UNDERLINE})).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"chat.blockshot.prompt.upload_screenshot")).m_130938_(style -> style.m_131142_((ClickEvent)new BlockShotClickEvent(ClickEvent.Action.RUN_COMMAND, "/blockshot upload")));
            ClientUtil.sendMessage((Component)confirmMessage, BlockShot.CHAT_UPLOAD_ID);
            return false;
        }
        ScreenshotHandler.uploadLast(true);
        return true;
    }

    public static void uploadLast(boolean writeOnFail) {
        if (!ClientUtil.validState()) {
            return;
        }
        if (latest == null || latest.length == 0) {
            return;
        }
        byte[] bytes = Arrays.copyOf(latest, latest.length);
        latest = null;
        Util.m_183992_().execute(() -> ScreenshotHandler.uploadAndAddToChat(bytes, writeOnFail, "png", null, WebUtils.MediaType.PNG));
    }

    public static void uploadAndAddToChat(byte[] imageBytes, boolean writeOnFail, String fallbackExt, @Nullable AtomicDouble progress, WebUtils.MediaType type) {
        MutableComponent finished = Component.m_237115_((String)"chat.blockshot.upload.uploading");
        ClientUtil.sendMessage((Component)finished, BlockShot.CHAT_UPLOAD_ID);
        String result = ScreenshotHandler.uploadImage(imageBytes, progress, type);
        if (result == null) {
            finished = Component.m_237115_((String)"chat.blockshot.upload.error");
            ClientUtil.sendMessage((Component)finished, BlockShot.CHAT_UPLOAD_ID);
            if (writeOnFail) {
                ScreenshotHandler.saveLocal(imageBytes, Platform.getGameFolder().toFile(), null, fallbackExt, ClientUtil::sendMessage, "chat.blockshot.fallback.success", "chat.blockshot.fallback.failure");
            }
        } else if (result.startsWith("http")) {
            MutableComponent link = Component.m_237113_((String)result).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, result)));
            finished = Component.m_237115_((String)"chat.blockshot.upload.uploaded").m_130946_(" ").m_7220_((Component)link);
            ClientUtil.deleteMessage(BlockShot.CHAT_UPLOAD_ID);
            ClientUtil.sendMessage((Component)finished);
        }
    }

    public static String uploadImage(byte[] imageBytes, @Nullable AtomicDouble progress, WebUtils.MediaType type) {
        try {
            String rsp = WebUtils.post("https://blockshot.ch/upload", Base64.getEncoder().encodeToString(imageBytes), type, progress);
            return ScreenshotHandler.readJsonResponse(rsp);
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while uploading image", t);
            return null;
        }
    }

    public static String readJsonResponse(String rsp) {
        try {
            if (rsp.equals("error")) {
                return null;
            }
            JsonElement jsonElement = JsonParser.parseString((String)rsp);
            String status = jsonElement.getAsJsonObject().get("status").getAsString();
            if (!status.equals("error")) {
                HistoryManager.instance.markDirty();
                return jsonElement.getAsJsonObject().get("url").getAsString();
            }
            LOGGER.error("Server Response: {}", (Object)jsonElement.getAsJsonObject().get("message").getAsString());
        }
        catch (Throwable t) {
            LOGGER.error("An error occurred while uploading image", t);
        }
        return null;
    }

    public static void saveLocal(byte[] bytes, File gameDir, @Nullable String fileName, String extension, Consumer<Component> consumer, String msgSuccess, String msgFail) {
        File file2 = new File(gameDir, "screenshots");
        file2.mkdir();
        File outputFile = fileName == null ? ScreenshotHandler.getFile(file2, extension) : new File(file2, fileName);
        Util.m_183992_().execute(() -> {
            try (FileOutputStream os = new FileOutputStream(outputFile);){
                ((OutputStream)os).write(bytes);
                MutableComponent component = Component.m_237113_((String)outputFile.getName()).m_130940_(ChatFormatting.UNDERLINE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputFile.getAbsolutePath())));
                consumer.accept((Component)Component.m_237110_((String)msgSuccess, (Object[])new Object[]{component}));
            }
            catch (Exception e) {
                LOGGER.warn("Couldn't save screenshot", (Throwable)e);
                consumer.accept((Component)Component.m_237110_((String)msgFail, (Object[])new Object[]{e.getMessage()}));
            }
        });
    }

    public static File getFile(File directory, String extension) {
        String dateTimeString = Util.m_241986_();
        int i = 1;
        File result;
        while ((result = new File(directory, dateTimeString + (String)(i == 1 ? "" : "_" + i) + "." + extension)).exists()) {
            ++i;
        }
        return result;
    }
}

