/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.capture;

import com.google.common.util.concurrent.AtomicDouble;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.platform.Platform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.blockshot.ClientUtil;
import net.creeperhost.blockshot.WebUtils;
import net.creeperhost.blockshot.capture.Encoder;
import net.creeperhost.blockshot.capture.ScreenshotHandler;
import net.creeperhost.blockshot.repack.org.jcodec.api.SequenceEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.Format;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class VideoEncoder
implements Encoder {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int TARGET_WIDTH = 1280;
    private static final int TARGET_HEIGHT = 720;
    private static final int FPS = 15;
    private static final int MAX_DURATION = 30;
    private static final WebUtils.MediaType MEDIA_TYPE = WebUtils.MediaType.WEBM;
    private final ExecutorService RECORDING_EXECUTOR = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("blockshot-recorder-%d").setDaemon(true).build());
    private final ExecutorService ENCODING_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("blockshot-encoder-%d").setDaemon(true).build());
    private final File tempFile = new File(Platform.getGameFolder().toFile(), "screenshots/blockshot.temp.mov");
    private final List<CompletableFuture<?>> activeFutures = new ArrayList();
    private AtomicDouble uploadProgress = new AtomicDouble(0.0);
    private SequenceEncoder activeEncoder = null;
    private boolean isRecording = false;
    private boolean stopping = false;
    private boolean canceled = false;
    private long recordStartTime = 0L;
    private long lastFrameTime = 0L;

    @Override
    public void startOrStopRecording() {
        if (this.stopping) {
            return;
        }
        try {
            if (this.isWorking()) {
                this.stopping = true;
            } else {
                this.isRecording = true;
                this.tempFile.getParentFile().mkdirs();
                this.activeEncoder = new SequenceEncoder(NIOUtils.writableChannel(this.tempFile), Rational.R(15, 1), Format.MKV, Codec.VP8, null);
                this.recordStartTime = this.lastFrameTime = System.currentTimeMillis();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void updateCapture() {
        if (this.activeEncoder == null) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time - this.lastFrameTime < 66L) {
            return;
        }
        if ((time - this.recordStartTime) / 1000L > 30L) {
            this.stopping = true;
        }
        this.activeFutures.removeIf(CompletableFuture::isDone);
        if (this.stopping) {
            if (this.canceled) {
                this.activeFutures.forEach(e -> e.cancel(true));
            }
            if (this.activeFutures.isEmpty()) {
                try {
                    this.activeEncoder.finish();
                }
                catch (IOException e2) {
                    LOGGER.error("Something went wrong while encoding video", (Throwable)e2);
                }
                this.uploadAndCleanup();
            }
            return;
        }
        RenderTarget renderTarget = Minecraft.m_91087_().m_91385_();
        NativeImage nativeImage = new NativeImage(renderTarget.f_83915_, renderTarget.f_83916_, false);
        RenderSystem.m_69396_((int)renderTarget.m_83975_());
        nativeImage.m_85045_(0, true);
        CompletableFuture<BufferedImage> converter = CompletableFuture.supplyAsync(() -> this.toBufferedImage(nativeImage, 1280, 720), this.RECORDING_EXECUTOR);
        this.activeFutures.add(converter);
        while (time - this.lastFrameTime > 66L) {
            this.addFrame(converter);
            this.lastFrameTime += 66L;
        }
    }

    private void addFrame(CompletableFuture<BufferedImage> converter) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
            block5: {
                try {
                    BufferedImage image = (BufferedImage)converter.get();
                    ExecutorService executorService = this.ENCODING_EXECUTOR;
                    synchronized (executorService) {
                        this.activeEncoder.encodeNativeFrame(VideoEncoder.fromBufferedImageRGB(image));
                    }
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    if (this.canceled) break block5;
                    LOGGER.error("Something went wrong while encoding video frame", (Throwable)e);
                    this.canceled = true;
                    this.stopping = true;
                }
            }
        }, this.ENCODING_EXECUTOR);
        this.activeFutures.add(future);
    }

    @Override
    public void cancelRecording() {
        if (this.activeEncoder != null) {
            this.canceled = true;
            this.stopping = true;
        }
    }

    @Override
    public boolean isWorking() {
        return this.isRecording;
    }

    private void uploadAndCleanup() {
        this.activeEncoder = null;
        if (this.canceled) {
            this.tempFile.delete();
            this.canceled = false;
            this.stopping = false;
            this.isRecording = false;
            return;
        }
        this.uploadProgress.set(0.0);
        CompletableFuture.runAsync(() -> {
            this.uploadAndAddToChat(true, "mov", this.uploadProgress);
            this.stopping = false;
            this.isRecording = false;
            this.tempFile.delete();
        });
    }

    public void uploadAndAddToChat(boolean writeOnFail, String fallbackExt, @Nullable AtomicDouble progress) {
        MutableComponent finished = Component.m_237115_((String)"chat.blockshot.upload.uploading");
        ClientUtil.sendMessage((Component)finished, BlockShot.CHAT_UPLOAD_ID);
        String result = this.uploadImage(this.tempFile, progress);
        if (result == null) {
            finished = Component.m_237115_((String)"chat.blockshot.upload.error");
            ClientUtil.sendMessage((Component)finished, BlockShot.CHAT_UPLOAD_ID);
            if (writeOnFail) {
                try (FileInputStream is = new FileInputStream(this.tempFile);){
                    ScreenshotHandler.saveLocal(is.readAllBytes(), Platform.getGameFolder().toFile(), null, fallbackExt, ClientUtil::sendMessage, "chat.blockshot.fallback.success", "chat.blockshot.fallback.failure");
                }
                catch (IOException e) {
                    LOGGER.error("An error occurred while uploading image", (Throwable)e);
                }
            }
        } else if (result.startsWith("http")) {
            MutableComponent link = Component.m_237113_((String)result).m_130940_(ChatFormatting.UNDERLINE).m_130940_(ChatFormatting.LIGHT_PURPLE).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, result)));
            finished = Component.m_237115_((String)"chat.blockshot.upload.uploaded").m_130946_(" ").m_7220_((Component)link);
            ClientUtil.deleteMessage(BlockShot.CHAT_UPLOAD_ID);
            ClientUtil.sendMessage((Component)finished);
        }
    }

    public String uploadImage(File file, @Nullable AtomicDouble progress) {
        String string;
        FileInputStream is = new FileInputStream(file);
        try {
            String rsp = WebUtils.post("https://blockshot.ch/upload", Base64.getEncoder().encodeToString(((InputStream)is).readAllBytes()), MEDIA_TYPE, progress);
            string = ScreenshotHandler.readJsonResponse(rsp);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                LOGGER.error("An error occurred while uploading video", t);
                return null;
            }
        }
        ((InputStream)is).close();
        return string;
    }

    @Override
    public boolean showRecordIcon() {
        return this.isWorking() && !this.stopping;
    }

    @Override
    public List<Component> getHudText() {
        ArrayList<Component> list = new ArrayList<Component>();
        String screenshotKey = Minecraft.m_91087_().f_91066_.f_92102_.m_90863_().getString();
        if (!this.stopping) {
            list.add((Component)Component.m_237115_((String)"overlay.blockshot.recording").m_130940_(ChatFormatting.RED));
            list.add((Component)Component.m_237110_((String)"overlay.blockshot.finish", (Object[])new Object[]{screenshotKey}).m_130940_(ChatFormatting.GRAY));
        }
        if (this.stopping && !this.activeFutures.isEmpty()) {
            list.add((Component)Component.m_237110_((String)"overlay.blockshot.encoding", (Object[])new Object[]{this.activeFutures.size()}).m_130940_(ChatFormatting.RED));
        } else if (this.stopping && this.activeEncoder == null) {
            list.add((Component)Component.m_237115_((String)"overlay.blockshot.uploading").m_130946_(": " + Math.round(this.uploadProgress.get() * 100.0) + "%").m_130940_(ChatFormatting.RED));
        }
        if (!this.canceled && this.activeEncoder != null) {
            list.add((Component)Component.m_237110_((String)"overlay.blockshot.cancel", (Object[])new Object[]{screenshotKey}).m_130940_(ChatFormatting.GRAY));
        }
        return list;
    }

    private static Picture fromBufferedImageRGB(BufferedImage src) {
        Picture dst = Picture.create(src.getWidth(), src.getHeight(), ColorSpace.RGB);
        VideoEncoder.fromBufferedImage(src, dst);
        return dst;
    }

    private static void fromBufferedImage(BufferedImage src, Picture dst) {
        byte[] dstData = dst.getPlaneData(0);
        int off = 0;
        for (int i = 0; i < src.getHeight(); ++i) {
            for (int j = 0; j < src.getWidth(); ++j) {
                int rgb1 = src.getRGB(j, i);
                dstData[off++] = (byte)((rgb1 >> 16 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 >> 8 & 0xFF) - 128);
                dstData[off++] = (byte)((rgb1 & 0xFF) - 128);
            }
        }
    }
}

