/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.gui;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import net.creeperhost.blockshot.Config;
import net.creeperhost.blockshot.capture.RecordingHandler;
import net.creeperhost.blockshot.capture.ScreenshotHandler;
import net.creeperhost.blockshot.gui.BlockShotClickEvent;
import net.creeperhost.blockshot.gui.BlockShotGui;
import net.creeperhost.blockshot.gui.IconButton;
import net.creeperhost.polylib.client.modulargui.ModularGuiScreen;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.PauseScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class GuiEvents {
    private static long keybindLast = 0L;

    public static void init() {
        ClientRawInputEvent.KEY_PRESSED.register(GuiEvents::onRawInput);
        ClientGuiEvent.INIT_POST.register(GuiEvents::onGuiInit);
    }

    private static void onGuiInit(Screen screen, ScreenAccess access) {
        if (screen instanceof PauseScreen) {
            Config.ButtonPos pos = Config.INSTANCE.buttonPos;
            access.addRenderableWidget((AbstractWidget)new IconButton(pos.getX(screen.f_96543_, 100), pos.getY(screen.f_96544_, 20), 100, 20, (Component)Component.m_237115_((String)"gui.blockshot.blockshot_button"), e -> Minecraft.m_91087_().m_91152_((Screen)new ModularGuiScreen((GuiProvider)new BlockShotGui()))).setIcon(new ResourceLocation("blockshot", "textures/gui/blockshot_icon.png"), 16, 16));
        }
    }

    private static EventResult onRawInput(Minecraft minecraft, int keyCode, int scanCode, int action, int modifiers) {
        if (!Minecraft.m_91087_().f_91066_.f_92102_.m_90832_(keyCode, scanCode) || action != 0) {
            return EventResult.pass();
        }
        long elapsed = System.currentTimeMillis() - keybindLast;
        if (elapsed < 5000L && !RecordingHandler.getEncoder().isWorking()) {
            return EventResult.pass();
        }
        keybindLast = System.currentTimeMillis();
        if (Screen.m_96637_()) {
            RecordingHandler.getEncoder().startOrStopRecording();
            return EventResult.interrupt((Boolean)true);
        }
        if (Screen.m_96638_()) {
            RecordingHandler.getEncoder().cancelRecording();
        }
        return EventResult.pass();
    }

    public static boolean handleComponentClick(Style style) {
        if (Screen.m_96638_() || style == null) {
            return false;
        }
        ClickEvent clickEvent = style.m_131182_();
        if (!(clickEvent instanceof BlockShotClickEvent)) {
            return false;
        }
        ScreenshotHandler.uploadLast(false);
        return true;
    }
}

