/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.gui;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.math.Vector3f;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.creeperhost.blockshot.BlockShot;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.lib.geometry.Position;
import net.creeperhost.polylib.helpers.MathUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class GuiLoadingSpinner
extends GuiElement<GuiLoadingSpinner>
implements BackgroundRender {
    private final List<Pxl> pixels = new ArrayList<Pxl>();
    private double animation = 0.0;
    private int fadeOut = 0;
    private double animSpeed = 0.03;
    private int texWidth;
    private int texHeight;
    private Supplier<Boolean> doSpin = () -> true;

    public GuiLoadingSpinner(@NotNull GuiParent<?> parent, ResourceLocation texture) {
        super(parent);
        try {
            Resource resource = this.mc().m_91098_().m_215593_(texture);
            try (InputStream inputStream = resource.m_215507_();){
                NativeImage image = NativeImage.m_85058_((InputStream)inputStream);
                this.texWidth = image.m_84982_();
                this.texHeight = image.m_85084_();
                for (int x = 0; x < this.texWidth; ++x) {
                    for (int y = 0; y < this.texHeight; ++y) {
                        int abgr = image.m_84985_(x, y);
                        int a = GuiLoadingSpinner.alphaAGBR(abgr);
                        if (a == 0) continue;
                        int r = GuiLoadingSpinner.redAGBR(abgr);
                        int g = GuiLoadingSpinner.greenAGBR(abgr);
                        int b = GuiLoadingSpinner.blueAGBR(abgr);
                        this.pixels.add(new Pxl(x, y, FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b)));
                    }
                }
            }
        }
        catch (IOException ignored) {
            BlockShot.LOGGER.error((Object)ignored);
        }
    }

    public static int alphaAGBR(int i) {
        return i >>> 24;
    }

    public static int redAGBR(int i) {
        return i & 0xFF;
    }

    public static int greenAGBR(int i) {
        return i >> 8 & 0xFF;
    }

    public static int blueAGBR(int i) {
        return i >> 16 & 0xFF;
    }

    public GuiLoadingSpinner setDoSpin(Supplier<Boolean> doSpin) {
        this.doSpin = doSpin;
        return this;
    }

    public void tick(double mouseX, double mouseY) {
        super.tick(mouseX, mouseY);
        this.fadeOut = this.doSpin.get() != false ? Math.min(255, this.fadeOut + 10) : Math.max(0, this.fadeOut - 10);
        this.animation = this.fadeOut == 0 ? 0.0 : (this.animation += this.animSpeed);
    }

    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        if (this.fadeOut == 0) {
            return;
        }
        double time = Mth.m_14139_((double)partialTicks, (double)this.animation, (double)(this.animation + this.animSpeed));
        render.pose().m_85836_();
        render.pose().m_85837_(this.xCenter(), this.yCenter(), 0.0);
        render.pose().m_85845_(Vector3f.f_122227_.m_122240_((float)(time * 90.0) + 40.0f));
        render.pose().m_85837_(-this.xCenter(), -this.yCenter(), 0.0);
        render.batchDraw(() -> this.pixels.forEach(pxl -> pxl.draw(render, (int)this.xCenter() - this.texWidth / 2, (int)this.yCenter() - this.texHeight / 2, partialTicks)));
        render.pose().m_85849_();
    }

    public static int lerpInt(float f, int i, int j) {
        return i + Mth.m_14143_((float)(f * (float)(j - i)));
    }

    private class Pxl {
        public final Position.Mutable origin;
        public final Position.Mutable pos;
        public final int colour;
        public final double random;

        public Pxl(int x, int y, int colour) {
            this.colour = colour;
            this.origin = new Position.Mutable((double)x, (double)y);
            this.pos = new Position.Mutable((double)x, (double)y);
            this.random = Math.random();
        }

        public void draw(GuiRender render, int x, int y, float partialTicks) {
            double time = Mth.m_14139_((double)partialTicks, (double)GuiLoadingSpinner.this.animation, (double)(GuiLoadingSpinner.this.animation + GuiLoadingSpinner.this.animSpeed));
            double anim = 1.0 + Math.sin(time * Math.PI);
            anim = Math.max(0.0, (anim - 0.1) * 1.1);
            double xAnim = anim * Math.sin(time + this.random * this.pos.x()) * 20.0 * this.random;
            double yAnim = anim * Math.cos(time + this.random * this.pos.y()) * 20.0 * this.random;
            int r = GuiLoadingSpinner.lerpInt((float)MathUtil.clamp((double)(anim - 0.5), (double)0.0, (double)1.0), FastColor.ARGB32.m_13665_((int)this.colour), 255);
            int g = GuiLoadingSpinner.lerpInt((float)MathUtil.clamp((double)(anim - 0.5), (double)0.0, (double)1.0), FastColor.ARGB32.m_13667_((int)this.colour), 255);
            int b = GuiLoadingSpinner.lerpInt((float)MathUtil.clamp((double)(anim - 0.5), (double)0.0, (double)1.0), FastColor.ARGB32.m_13669_((int)this.colour), 255);
            render.rect((double)x + this.pos.x() + xAnim, (double)y + this.pos.y() + yAnim, 1.0, 1.0, FastColor.ARGB32.m_13660_((int)GuiLoadingSpinner.this.fadeOut, (int)r, (int)g, (int)b));
        }
    }
}

