/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.lib;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.creeperhost.blockshot.WebUtils;
import net.creeperhost.blockshot.lib.Capture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class HistoryManager {
    private static final Logger LOGGER = LogManager.getLogger();
    public static HistoryManager instance = new HistoryManager();
    private int historyState = 0;
    private boolean dirty = true;
    private boolean downloading = false;
    private boolean downloadError = false;
    private final List<String> deleting = new ArrayList<String>();
    private final List<Capture> captureHistory = new ArrayList<Capture>();
    private final List<CompletableFuture<HistoryTask>> activeTasks = new ArrayList<CompletableFuture<HistoryTask>>();

    public void markDirty() {
        this.dirty = true;
    }

    public boolean isDownloading() {
        return this.downloading;
    }

    public boolean isDownloadError() {
        return this.downloadError;
    }

    public boolean isDeleting(@Nullable Capture capture) {
        return capture == null ? !this.deleting.isEmpty() : this.deleting.contains(capture.id());
    }

    public boolean hasNoHistory() {
        return this.captureHistory.isEmpty() && !this.isDownloading();
    }

    public List<Capture> getCaptureHistory() {
        return Collections.unmodifiableList(this.captureHistory);
    }

    public int getState() {
        return this.historyState;
    }

    public void updateHistory() {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        this.downloading = true;
        this.downloadError = false;
        this.activeTasks.add(CompletableFuture.supplyAsync(() -> new DownloadTask().runTask()));
    }

    public void deleteCapture(Capture capture) {
        this.deleting.add(capture.id());
        this.captureHistory.remove(capture);
        this.activeTasks.add(CompletableFuture.supplyAsync(() -> new DeleteTask(capture).runTask()));
        ++this.historyState;
    }

    public void tick() {
        if (this.activeTasks.isEmpty()) {
            return;
        }
        List<CompletableFuture> completed = this.activeTasks.stream().filter(CompletableFuture::isDone).toList();
        for (CompletableFuture task : completed) {
            if (task.isCompletedExceptionally()) continue;
            try {
                ((HistoryTask)task.get()).finishTask();
            }
            catch (InterruptedException | ExecutionException e) {
                this.markDirty();
                LOGGER.error("An error occurred while finishing task", (Throwable)e);
            }
        }
        this.activeTasks.removeAll(completed);
    }

    private static abstract class HistoryTask {
        private HistoryTask() {
        }

        public abstract HistoryTask runTask();

        public abstract void finishTask();
    }

    private class DeleteTask
    extends HistoryTask {
        private final Capture capInfo;

        public DeleteTask(Capture capInfo) {
            this.capInfo = capInfo;
        }

        @Override
        public DeleteTask runTask() {
            WebUtils.get("https://blockshot.ch/delete/" + this.capInfo.id(), null);
            return this;
        }

        @Override
        public void finishTask() {
            HistoryManager.this.captureHistory.remove(this.capInfo);
            HistoryManager.this.deleting.remove(this.capInfo.id());
            ++HistoryManager.this.historyState;
        }
    }

    private class DownloadTask
    extends HistoryTask {
        private final List<Capture> captures = new ArrayList<Capture>();
        private boolean errored = false;

        private DownloadTask() {
        }

        @Override
        public DownloadTask runTask() {
            String rsp = WebUtils.get("https://blockshot.ch/list", null);
            if (!rsp.equals("error")) {
                JsonElement jsonElement = JsonParser.parseString((String)rsp);
                JsonArray images = jsonElement.getAsJsonArray();
                for (JsonElement obj : images) {
                    this.captures.add(Capture.fromJson(obj.getAsJsonObject()));
                }
            } else {
                this.errored = true;
            }
            return this;
        }

        @Override
        public void finishTask() {
            HistoryManager.this.downloadError = this.errored;
            HistoryManager.this.downloading = false;
            HistoryManager.this.captureHistory.clear();
            HistoryManager.this.captureHistory.addAll(this.captures);
            HistoryManager.this.captureHistory.sort(Comparator.comparingLong(Capture::created).reversed());
            ++HistoryManager.this.historyState;
        }
    }
}

