/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.crypto.PEMUtils;

public class ECUtils {
    public static PrivateKey loadPrivateKeyPem(Path path) throws IOException {
        return ECUtils.loadPrivateKey(PEMUtils.loadPem(path));
    }

    public static PrivateKey loadPrivateKeyPem(InputStream is) throws IOException {
        return ECUtils.loadPrivateKey(PEMUtils.loadPem(is));
    }

    public static PrivateKey loadPrivateKeyPem(byte[] bytes) throws IOException {
        return ECUtils.loadPrivateKey(PEMUtils.loadPem(bytes));
    }

    public static PrivateKey loadPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePrivate(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load private key.", ex);
        }
    }

    public static PublicKey loadPublicKeyPem(Path path) throws IOException {
        return ECUtils.loadPublicKey(PEMUtils.loadPem(path));
    }

    public static PublicKey loadPublicKeyPem(InputStream is) throws IOException {
        return ECUtils.loadPublicKey(PEMUtils.loadPem(is));
    }

    public static PublicKey loadPublicKeyPem(byte[] bytes) throws IOException {
        return ECUtils.loadPublicKey(PEMUtils.loadPem(bytes));
    }

    public static PublicKey loadPublicKey(byte[] key) {
        try {
            X509EncodedKeySpec spec = new X509EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            return keyFactory.generatePublic(spec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            throw new RuntimeException("Failed to load public key.", ex);
        }
    }
}

