/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.crypto;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.WillClose;
import net.creeperhost.blockshot.repack.net.creeperhost.minetogether.session.crypto.Crypto;

public class PEMUtils {
    public static List<String> writePem(byte[] keyData, String type) {
        LinkedList<String> lines = new LinkedList<String>();
        lines.add("-----BEGIN " + type + " KEY-----");
        String str = Crypto.base64Encode(keyData);
        for (int i = 0; i < str.length(); i += 64) {
            lines.add(str.substring(i, Math.min(i + 64, str.length())));
        }
        lines.add("-----END " + type + " KEY-----");
        return lines;
    }

    public static byte[] loadPem(Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            byte[] byArray = PEMUtils.loadPem(is);
            return byArray;
        }
    }

    public static byte[] loadPem(byte[] bytes) throws IOException {
        return PEMUtils.loadPem(new ByteArrayInputStream(bytes));
    }

    public static byte[] loadPem(@WillClose InputStream is) throws IOException {
        return PEMUtils.loadPem(new InputStreamReader(is, StandardCharsets.UTF_8));
    }

    public static byte[] loadPem(String str) throws IOException {
        return PEMUtils.loadPem(new StringReader(str));
    }

    public static byte[] loadPem(Reader reader) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (BufferedReader r = new BufferedReader(reader);){
            String line;
            while ((line = r.readLine()) != null) {
                if (line.startsWith("--")) continue;
                builder.append(line);
            }
        }
        return Crypto.base64Decode(builder.toString());
    }

    public static byte[] loadPem(List<String> lines) {
        StringBuilder builder = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("--")) continue;
            builder.append(line);
        }
        return Crypto.base64Decode(builder.toString());
    }
}

