/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax;

import java.util.Arrays;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACDecoderConfig;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.ChannelConfiguration;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.error.RVLC;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.gain.GainControl;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.huffman.Huffman;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.ICSInfo;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.IQTable;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.ScaleFactorTable;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.tools.TNS;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.BitReader;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;

public class ICStream {
    private static final int SF_DELTA = 60;
    private static final int SF_OFFSET = 200;
    private static int randomState = 523124044;
    private final int frameLength;
    private final ICSInfo info;
    private final int[] sfbCB;
    private final int[] sectEnd;
    private final float[] data;
    private final float[] scaleFactors;
    private int globalGain;
    private boolean pulseDataPresent;
    private boolean tnsDataPresent;
    private boolean gainControlPresent;
    private TNS tns;
    private GainControl gainControl;
    private int[] pulseOffset;
    private int[] pulseAmp;
    private int pulseCount;
    private int pulseStartSWB;
    private boolean noiseUsed;
    private int reorderedSpectralDataLen;
    private int longestCodewordLen;
    private RVLC rvlc;

    public ICStream(int frameLength) {
        this.frameLength = frameLength;
        this.info = new ICSInfo(frameLength);
        this.sfbCB = new int[120];
        this.sectEnd = new int[120];
        this.data = new float[frameLength];
        this.scaleFactors = new float[120];
    }

    public void decode(BitReader _in, boolean commonWindow, AACDecoderConfig conf) throws AACException {
        if (conf.isScalefactorResilienceUsed() && this.rvlc == null) {
            this.rvlc = new RVLC();
        }
        boolean er = conf.getProfile().isErrorResilientProfile();
        this.globalGain = _in.readNBit(8);
        if (!commonWindow) {
            this.info.decode(_in, conf, commonWindow);
        }
        this.decodeSectionData(_in, conf.isSectionDataResilienceUsed());
        this.decodeScaleFactors(_in);
        this.pulseDataPresent = _in.readBool();
        if (this.pulseDataPresent) {
            if (this.info.isEightShortFrame()) {
                throw new AACException("pulse data not allowed for short frames");
            }
            Logger.debug("PULSE");
            this.decodePulseData(_in);
        }
        this.tnsDataPresent = _in.readBool();
        if (this.tnsDataPresent && !er) {
            if (this.tns == null) {
                this.tns = new TNS();
            }
            this.tns.decode(_in, this.info);
        }
        this.gainControlPresent = _in.readBool();
        if (this.gainControlPresent) {
            if (this.gainControl == null) {
                this.gainControl = new GainControl(this.frameLength);
            }
            Logger.debug("GAIN");
            this.gainControl.decode(_in, this.info.getWindowSequence());
        }
        if (conf.isSpectralDataResilienceUsed()) {
            int max = conf.getChannelConfiguration() == ChannelConfiguration.CHANNEL_CONFIG_STEREO ? 6144 : 12288;
            this.reorderedSpectralDataLen = Math.max(_in.readNBit(14), max);
            this.longestCodewordLen = Math.max(_in.readNBit(6), 49);
        } else {
            this.decodeSpectralData(_in);
        }
    }

    public void decodeSectionData(BitReader _in, boolean sectionDataResilienceUsed) throws AACException {
        Arrays.fill(this.sfbCB, 0);
        Arrays.fill(this.sectEnd, 0);
        int bits = this.info.isEightShortFrame() ? 3 : 5;
        int escVal = (1 << bits) - 1;
        int windowGroupCount = this.info.getWindowGroupCount();
        int maxSFB = this.info.getMaxSFB();
        int idx = 0;
        for (int g = 0; g < windowGroupCount; ++g) {
            int k = 0;
            while (k < maxSFB) {
                int incr;
                int end = k;
                int cb = _in.readNBit(4);
                if (cb == 12) {
                    throw new AACException("invalid huffman codebook: 12");
                }
                while ((incr = _in.readNBit(bits)) == escVal) {
                    end += incr;
                }
                if ((end += incr) > maxSFB) {
                    throw new AACException("too many bands: " + end + ", allowed: " + maxSFB);
                }
                while (k < end) {
                    this.sfbCB[idx] = cb;
                    this.sectEnd[idx++] = end;
                    ++k;
                }
            }
        }
    }

    private void decodePulseData(BitReader _in) throws AACException {
        this.pulseCount = _in.readNBit(2) + 1;
        this.pulseStartSWB = _in.readNBit(6);
        if (this.pulseStartSWB >= this.info.getSWBCount()) {
            throw new AACException("pulse SWB out of range: " + this.pulseStartSWB + " > " + this.info.getSWBCount());
        }
        if (this.pulseOffset == null || this.pulseCount != this.pulseOffset.length) {
            this.pulseOffset = new int[this.pulseCount];
            this.pulseAmp = new int[this.pulseCount];
        }
        this.pulseOffset[0] = this.info.getSWBOffsets()[this.pulseStartSWB];
        this.pulseOffset[0] = this.pulseOffset[0] + _in.readNBit(5);
        this.pulseAmp[0] = _in.readNBit(4);
        for (int i = 1; i < this.pulseCount; ++i) {
            this.pulseOffset[i] = _in.readNBit(5) + this.pulseOffset[i - 1];
            if (this.pulseOffset[i] > 1023) {
                throw new AACException("pulse offset out of range: " + this.pulseOffset[0]);
            }
            this.pulseAmp[i] = _in.readNBit(4);
        }
    }

    public void decodeScaleFactors(BitReader _in) throws AACException {
        int windowGroups = this.info.getWindowGroupCount();
        int maxSFB = this.info.getMaxSFB();
        int[] offset = new int[]{this.globalGain, this.globalGain - 90, 0};
        boolean noiseFlag = true;
        int idx = 0;
        for (int g = 0; g < windowGroups; ++g) {
            int sfb = 0;
            block6: while (sfb < maxSFB) {
                int end = this.sectEnd[idx];
                switch (this.sfbCB[idx]) {
                    case 0: {
                        while (sfb < end) {
                            this.scaleFactors[idx] = 0.0f;
                            ++sfb;
                            ++idx;
                        }
                        continue block6;
                    }
                    case 14: 
                    case 15: {
                        int tmp;
                        while (sfb < end) {
                            offset[2] = offset[2] + (Huffman.decodeScaleFactor(_in) - 60);
                            tmp = Math.min(Math.max(offset[2], -155), 100);
                            this.scaleFactors[idx] = ScaleFactorTable.SCALEFACTOR_TABLE[-tmp + 200];
                            ++sfb;
                            ++idx;
                        }
                        continue block6;
                    }
                    case 13: {
                        int tmp;
                        while (sfb < end) {
                            if (noiseFlag) {
                                offset[1] = offset[1] + (_in.readNBit(9) - 256);
                                noiseFlag = false;
                            } else {
                                offset[1] = offset[1] + (Huffman.decodeScaleFactor(_in) - 60);
                            }
                            tmp = Math.min(Math.max(offset[1], -100), 155);
                            this.scaleFactors[idx] = -ScaleFactorTable.SCALEFACTOR_TABLE[tmp + 200];
                            ++sfb;
                            ++idx;
                        }
                        continue block6;
                    }
                }
                while (sfb < end) {
                    offset[0] = offset[0] + (Huffman.decodeScaleFactor(_in) - 60);
                    if (offset[0] > 255) {
                        throw new AACException("scalefactor out of range: " + offset[0]);
                    }
                    this.scaleFactors[idx] = ScaleFactorTable.SCALEFACTOR_TABLE[offset[0] - 100 + 200];
                    ++sfb;
                    ++idx;
                }
            }
        }
    }

    private void decodeSpectralData(BitReader _in) throws AACException {
        Arrays.fill(this.data, 0.0f);
        int maxSFB = this.info.getMaxSFB();
        int windowGroups = this.info.getWindowGroupCount();
        int[] offsets = this.info.getSWBOffsets();
        int[] buf = new int[4];
        int groupOff = 0;
        int idx = 0;
        for (int g = 0; g < windowGroups; ++g) {
            int groupLen = this.info.getWindowGroupLength(g);
            int sfb = 0;
            while (sfb < maxSFB) {
                int k;
                int w;
                int hcb = this.sfbCB[idx];
                int off = groupOff + offsets[sfb];
                int width = offsets[sfb + 1] - offsets[sfb];
                if (hcb == 0 || hcb == 15 || hcb == 14) {
                    w = 0;
                    while (w < groupLen) {
                        Arrays.fill(this.data, off, off + width, 0.0f);
                        ++w;
                        off += 128;
                    }
                } else if (hcb == 13) {
                    w = 0;
                    while (w < groupLen) {
                        float energy = 0.0f;
                        for (k = 0; k < width; ++k) {
                            this.data[off + k] = randomState *= 1015568748;
                            energy += this.data[off + k] * this.data[off + k];
                        }
                        float scale = (float)((double)this.scaleFactors[idx] / Math.sqrt(energy));
                        for (k = 0; k < width; ++k) {
                            int n = off + k;
                            this.data[n] = this.data[n] * scale;
                        }
                        ++w;
                        off += 128;
                    }
                } else {
                    w = 0;
                    while (w < groupLen) {
                        int num = hcb >= 5 ? 2 : 4;
                        for (k = 0; k < width; k += num) {
                            Huffman.decodeSpectralData(_in, hcb, buf, 0);
                            for (int j = 0; j < num; ++j) {
                                this.data[off + k + j] = buf[j] > 0 ? IQTable.IQ_TABLE[buf[j]] : -IQTable.IQ_TABLE[-buf[j]];
                                int n = off + k + j;
                                this.data[n] = this.data[n] * this.scaleFactors[idx];
                            }
                        }
                        ++w;
                        off += 128;
                    }
                }
                ++sfb;
                ++idx;
            }
            groupOff += groupLen << 7;
        }
    }

    public float[] getInvQuantData() throws AACException {
        return this.data;
    }

    public ICSInfo getInfo() {
        return this.info;
    }

    public int[] getSectEnd() {
        return this.sectEnd;
    }

    public int[] getSfbCB() {
        return this.sfbCB;
    }

    public float[] getScaleFactors() {
        return this.scaleFactors;
    }

    public boolean isTNSDataPresent() {
        return this.tnsDataPresent;
    }

    public TNS getTNS() {
        return this.tns;
    }

    public int getGlobalGain() {
        return this.globalGain;
    }

    public boolean isNoiseUsed() {
        return this.noiseUsed;
    }

    public int getLongestCodewordLength() {
        return this.longestCodewordLen;
    }

    public int getReorderedSpectralDataLength() {
        return this.reorderedSpectralDataLen;
    }

    public boolean isGainControlPresent() {
        return this.gainControlPresent;
    }

    public GainControl getGainControl() {
        return this.gainControl;
    }
}

