/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax;

import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.AACException;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.Profile;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.SampleFrequency;
import net.creeperhost.blockshot.repack.net.sourceforge.jaad.aac.syntax.Element;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.BitReader;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;

public class PCE
extends Element {
    private static final int MAX_FRONT_CHANNEL_ELEMENTS = 16;
    private static final int MAX_SIDE_CHANNEL_ELEMENTS = 16;
    private static final int MAX_BACK_CHANNEL_ELEMENTS = 16;
    private static final int MAX_LFE_CHANNEL_ELEMENTS = 4;
    private static final int MAX_ASSOC_DATA_ELEMENTS = 8;
    private static final int MAX_VALID_CC_ELEMENTS = 16;
    private Profile profile;
    private SampleFrequency sampleFrequency;
    private int frontChannelElementsCount;
    private int sideChannelElementsCount;
    private int backChannelElementsCount;
    private int lfeChannelElementsCount;
    private int assocDataElementsCount;
    private int validCCElementsCount;
    private boolean monoMixdown;
    private boolean stereoMixdown;
    private boolean matrixMixdownIDXPresent;
    private int monoMixdownElementNumber;
    private int stereoMixdownElementNumber;
    private int matrixMixdownIDX;
    private boolean pseudoSurround;
    private final TaggedElement[] frontElements = new TaggedElement[16];
    private final TaggedElement[] sideElements = new TaggedElement[16];
    private final TaggedElement[] backElements = new TaggedElement[16];
    private final int[] lfeElementTags = new int[4];
    private final int[] assocDataElementTags = new int[8];
    private final CCE[] ccElements = new CCE[16];
    private byte[] commentFieldData;

    public PCE() {
        this.sampleFrequency = SampleFrequency.SAMPLE_FREQUENCY_NONE;
    }

    public void decode(BitReader _in) throws AACException {
        int i;
        this.readElementInstanceTag(_in);
        this.profile = Profile.forInt(_in.readNBit(2));
        this.sampleFrequency = SampleFrequency.forInt(_in.readNBit(4));
        this.frontChannelElementsCount = _in.readNBit(4);
        this.sideChannelElementsCount = _in.readNBit(4);
        this.backChannelElementsCount = _in.readNBit(4);
        this.lfeChannelElementsCount = _in.readNBit(2);
        this.assocDataElementsCount = _in.readNBit(3);
        this.validCCElementsCount = _in.readNBit(4);
        this.monoMixdown = _in.readBool();
        if (this.monoMixdown) {
            Logger.warn("mono mixdown present, but not yet supported");
            this.monoMixdownElementNumber = _in.readNBit(4);
        }
        this.stereoMixdown = _in.readBool();
        if (this.stereoMixdown) {
            Logger.warn("stereo mixdown present, but not yet supported");
            this.stereoMixdownElementNumber = _in.readNBit(4);
        }
        this.matrixMixdownIDXPresent = _in.readBool();
        if (this.matrixMixdownIDXPresent) {
            Logger.warn("matrix mixdown present, but not yet supported");
            this.matrixMixdownIDX = _in.readNBit(2);
            this.pseudoSurround = _in.readBool();
        }
        this.readTaggedElementArray(this.frontElements, _in, this.frontChannelElementsCount);
        this.readTaggedElementArray(this.sideElements, _in, this.sideChannelElementsCount);
        this.readTaggedElementArray(this.backElements, _in, this.backChannelElementsCount);
        for (i = 0; i < this.lfeChannelElementsCount; ++i) {
            this.lfeElementTags[i] = _in.readNBit(4);
        }
        for (i = 0; i < this.assocDataElementsCount; ++i) {
            this.assocDataElementTags[i] = _in.readNBit(4);
        }
        for (i = 0; i < this.validCCElementsCount; ++i) {
            this.ccElements[i] = new CCE(_in.readBool(), _in.readNBit(4));
        }
        _in.align();
        int commentFieldBytes = _in.readNBit(8);
        this.commentFieldData = new byte[commentFieldBytes];
        for (i = 0; i < commentFieldBytes; ++i) {
            this.commentFieldData[i] = (byte)_in.readNBit(8);
        }
    }

    private void readTaggedElementArray(TaggedElement[] te, BitReader _in, int len) throws AACException {
        for (int i = 0; i < len; ++i) {
            te[i] = new TaggedElement(_in.readBool(), _in.readNBit(4));
        }
    }

    public Profile getProfile() {
        return this.profile;
    }

    public SampleFrequency getSampleFrequency() {
        return this.sampleFrequency;
    }

    public int getChannelCount() {
        return this.frontChannelElementsCount + this.sideChannelElementsCount + this.backChannelElementsCount + this.lfeChannelElementsCount + this.assocDataElementsCount;
    }

    public static class CCE {
        private final boolean isIndSW;
        private final int tag;

        public CCE(boolean isIndSW, int tag) {
            this.isIndSW = isIndSW;
            this.tag = tag;
        }

        public boolean isIsIndSW() {
            return this.isIndSW;
        }

        public int getTag() {
            return this.tag;
        }
    }

    public static class TaggedElement {
        private final boolean isCPE;
        private final int tag;

        public TaggedElement(boolean isCPE, int tag) {
            this.isCPE = isCPE;
            this.tag = tag;
        }

        public boolean isIsCPE() {
            return this.isCPE;
        }

        public int getTag() {
            return this.tag;
        }
    }
}

