/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.api;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.PixelStore;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.PixelStoreImpl;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.Sink;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.SinkImpl;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.VideoFrameWithPacket;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.Format;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;
import net.creeperhost.blockshot.repack.org.jcodec.scale.ColorUtil;
import net.creeperhost.blockshot.repack.org.jcodec.scale.Transform;

public class SequenceEncoder {
    private Transform transform;
    private int frameNo;
    private int timestamp;
    private Rational fps;
    private Sink sink;
    private PixelStore pixelStore;

    public static SequenceEncoder createSequenceEncoder(File out, int fps) throws IOException {
        return new SequenceEncoder(NIOUtils.writableChannel(out), Rational.R(fps, 1), Format.MOV, Codec.H264, null);
    }

    public static SequenceEncoder create25Fps(File out) throws IOException {
        return new SequenceEncoder(NIOUtils.writableChannel(out), Rational.R(25, 1), Format.MOV, Codec.H264, null);
    }

    public static SequenceEncoder create30Fps(File out) throws IOException {
        return new SequenceEncoder(NIOUtils.writableChannel(out), Rational.R(30, 1), Format.MOV, Codec.H264, null);
    }

    public static SequenceEncoder create2997Fps(File out) throws IOException {
        return new SequenceEncoder(NIOUtils.writableChannel(out), Rational.R(30000, 1001), Format.MOV, Codec.H264, null);
    }

    public static SequenceEncoder create24Fps(File out) throws IOException {
        return new SequenceEncoder(NIOUtils.writableChannel(out), Rational.R(24, 1), Format.MOV, Codec.H264, null);
    }

    public static SequenceEncoder createWithFps(SeekableByteChannel out, Rational fps) throws IOException {
        return new SequenceEncoder(out, fps, Format.MOV, Codec.H264, null);
    }

    public SequenceEncoder(SeekableByteChannel out, Rational fps, Format outputFormat, Codec outputVideoCodec, Codec outputAudioCodec) throws IOException {
        this.fps = fps;
        this.sink = SinkImpl.createWithStream(out, outputFormat, outputVideoCodec, outputAudioCodec);
        this.pixelStore = new PixelStoreImpl();
    }

    public void configureCodec(Map<String, String> opts) {
        if (this.sink.isInitialised()) {
            throw new RuntimeException("Sink was already used to encode frames, we cannot allow any codec configuration changes");
        }
        this.sink.setCodecOpts(opts);
    }

    public void encodeNativeFrame(Picture pic) throws IOException {
        PixelStore.LoanerPicture toEncode;
        if (!this.sink.isInitialised()) {
            this.sink.init(false, false);
            if (this.sink.getInputColor() != null) {
                this.transform = ColorUtil.getTransform(ColorSpace.RGB, this.sink.getInputColor());
            }
        }
        ColorSpace sinkColor = this.sink.getInputColor();
        ColorSpace picColor = pic.getColor();
        if (picColor != ColorSpace.RGB && picColor != sinkColor) {
            throw new IllegalArgumentException("The input images is expected in RGB color.");
        }
        if (sinkColor != null && picColor != sinkColor) {
            toEncode = this.pixelStore.getPicture(pic.getWidth(), pic.getHeight(), sinkColor);
            this.transform.transform(pic, toEncode.getPicture());
        } else {
            toEncode = new PixelStore.LoanerPicture(pic, 0);
        }
        Packet pkt = Packet.createPacket(null, this.timestamp, this.fps.getNum(), this.fps.getDen(), this.frameNo, Packet.FrameType.KEY, null);
        this.sink.outputVideoFrame(new VideoFrameWithPacket(pkt, toEncode));
        if (sinkColor != null) {
            this.pixelStore.putBack(toEncode);
        }
        this.timestamp += this.fps.getDen();
        ++this.frameNo;
    }

    public void finish() throws IOException {
        this.sink.finish();
    }
}

