/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.api.transcode;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.AudioFrameWithPacket;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.Options;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.PacketSink;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.Sink;
import net.creeperhost.blockshot.repack.org.jcodec.api.transcode.VideoFrameWithPacket;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Encoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.encode.CQPRateControl;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.png.PNGEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.prores.ProresEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.raw.RAWVideoEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.IVFMuxer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VP8Encoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.wav.WavMuxer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.y4m.Y4MMuxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioFormat;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.Format;
import net.creeperhost.blockshot.repack.org.jcodec.common.Muxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.MuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.IOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.logging.Logger;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.AudioBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.ColorSpace;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Size;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Unit;
import net.creeperhost.blockshot.repack.org.jcodec.containers.imgseq.ImageSequenceMuxer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.muxer.MKVMuxer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.muxer.CodecMP4MuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.muxer.MP4Muxer;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.muxer.MP4MuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.raw.RawMuxer;

public class SinkImpl
implements Sink,
PacketSink {
    private String destName;
    private SeekableByteChannel destStream;
    private Muxer muxer;
    private MuxerTrack videoOutputTrack;
    private MuxerTrack audioOutputTrack;
    private boolean framesOutput;
    private Codec outputVideoCodec;
    private Codec outputAudioCodec;
    private Format outputFormat;
    private final ThreadLocal<ByteBuffer> bufferStore;
    private AudioEncoder audioEncoder;
    private VideoEncoder videoEncoder;
    private String profile;
    private boolean interlaced;
    private ByteBuffer videoCodecPrivate;
    private ByteBuffer audioCodecPrivate;
    private Map<String, String> codecOpts;

    @Override
    public void outputVideoPacket(Packet packet, VideoCodecMeta codecMeta) throws IOException {
        if (!this.outputFormat.isVideo()) {
            return;
        }
        if (this.videoOutputTrack == null) {
            this.videoOutputTrack = this.muxer.addVideoTrack(this.outputVideoCodec, codecMeta);
            if (this.videoOutputTrack instanceof MP4MuxerTrack) {
                ((MP4MuxerTrack)this.videoOutputTrack).setTgtChunkDuration(Rational.R(3, 1), Unit.SEC);
            }
            if (this.videoOutputTrack instanceof CodecMP4MuxerTrack) {
                ((CodecMP4MuxerTrack)this.videoOutputTrack).setCodecPrivateOpaque(this.videoCodecPrivate);
            }
        }
        this.videoOutputTrack.addFrame(packet);
        this.framesOutput = true;
    }

    @Override
    public void outputAudioPacket(Packet audioPkt, AudioCodecMeta audioCodecMeta) throws IOException {
        if (!this.outputFormat.isAudio()) {
            return;
        }
        if (this.audioOutputTrack == null) {
            this.audioOutputTrack = this.muxer.addAudioTrack(this.outputAudioCodec, audioCodecMeta);
            if (this.audioOutputTrack instanceof MP4MuxerTrack) {
                ((MP4MuxerTrack)this.audioOutputTrack).setTgtChunkDuration(Rational.R(3, 1), Unit.SEC);
            }
            if (this.audioOutputTrack instanceof CodecMP4MuxerTrack) {
                ((CodecMP4MuxerTrack)this.audioOutputTrack).setCodecPrivateOpaque(this.audioCodecPrivate);
            }
        }
        this.audioOutputTrack.addFrame(audioPkt);
        this.framesOutput = true;
    }

    public void initMuxer() throws IOException {
        if (this.destStream == null && this.outputFormat != Format.IMG) {
            this.destStream = NIOUtils.writableFileChannel(this.destName);
        }
        if (Format.MKV == this.outputFormat) {
            this.muxer = new MKVMuxer(this.destStream);
        } else if (Format.MOV == this.outputFormat) {
            this.muxer = MP4Muxer.createMP4MuxerToChannel(this.destStream);
        } else if (Format.IVF == this.outputFormat) {
            this.muxer = new IVFMuxer(this.destStream);
        } else if (Format.IMG == this.outputFormat) {
            this.muxer = new ImageSequenceMuxer(this.destName);
        } else if (Format.WAV == this.outputFormat) {
            this.muxer = new WavMuxer(this.destStream);
        } else if (Format.Y4M == this.outputFormat) {
            this.muxer = new Y4MMuxer(this.destStream);
        } else if (Format.RAW == this.outputFormat) {
            this.muxer = new RawMuxer(this.destStream);
        } else if (Format.H264 == this.outputFormat) {
            this.muxer = new RawMuxer(this.destStream);
        } else {
            throw new RuntimeException("The output format " + this.outputFormat + " is not supported.");
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.videoEncoder != null) {
            this.videoEncoder.finish();
        }
        if (this.framesOutput) {
            this.muxer.finish();
        } else {
            Logger.warn("No frames output.");
        }
        if (this.destStream != null) {
            IOUtils.closeQuietly(this.destStream);
        }
    }

    public SinkImpl(String destName, Format outputFormat, Codec outputVideoCodec, Codec outputAudioCodec) {
        if (destName == null && outputFormat == Format.IMG) {
            throw new IllegalArgumentException("A destination file should be specified for the image muxer.");
        }
        this.destName = destName;
        this.outputFormat = outputFormat;
        this.outputVideoCodec = outputVideoCodec;
        this.outputAudioCodec = outputAudioCodec;
        this.outputFormat = outputFormat;
        this.bufferStore = new ThreadLocal();
    }

    @Override
    public void setVideoCodecPrivate(ByteBuffer videoCodecPrivate) {
        this.videoCodecPrivate = videoCodecPrivate;
        if (this.videoOutputTrack instanceof CodecMP4MuxerTrack) {
            ((CodecMP4MuxerTrack)this.videoOutputTrack).setCodecPrivateOpaque(videoCodecPrivate);
        }
    }

    @Override
    public void setAudioCodecPrivate(ByteBuffer audioCodecPrivate) {
        this.audioCodecPrivate = audioCodecPrivate;
        if (this.audioOutputTrack instanceof CodecMP4MuxerTrack) {
            ((CodecMP4MuxerTrack)this.audioOutputTrack).setCodecPrivateOpaque(audioCodecPrivate);
        }
    }

    public static SinkImpl createWithStream(SeekableByteChannel destStream, Format outputFormat, Codec outputVideoCodec, Codec outputAudioCodec) {
        SinkImpl result = new SinkImpl(null, outputFormat, outputVideoCodec, outputAudioCodec);
        result.destStream = destStream;
        return result;
    }

    @Override
    public void init(boolean videoCopy, boolean audioCopy) throws IOException {
        this.initMuxer();
        if (this.outputFormat.isVideo() && this.outputVideoCodec != null && !videoCopy) {
            if (Codec.PRORES == this.outputVideoCodec) {
                this.videoEncoder = ProresEncoder.createProresEncoder(this.profile, this.interlaced);
            } else if (Codec.H264 == this.outputVideoCodec) {
                this.videoEncoder = this.createH264Encoder();
            } else if (Codec.VP8 == this.outputVideoCodec) {
                this.videoEncoder = VP8Encoder.createVP8Encoder((short)10);
            } else if (Codec.PNG == this.outputVideoCodec) {
                this.videoEncoder = new PNGEncoder();
            } else if (Codec.RAW == this.outputVideoCodec) {
                this.videoEncoder = new RAWVideoEncoder();
            } else {
                throw new RuntimeException("Could not find encoder for the codec: " + this.outputVideoCodec);
            }
        }
        this.initVideoEncoder();
    }

    private H264Encoder createH264Encoder() {
        Map<String, String> opts = this.getCodecOpts();
        if ("cqp".equals(opts.get("rc"))) {
            int qp = 20;
            if (opts.containsKey("qp")) {
                qp = Integer.parseInt(opts.get("qp"));
            }
            return new H264Encoder(new CQPRateControl(qp));
        }
        return H264Encoder.createH264Encoder();
    }

    private void initVideoEncoder() {
        for (Map.Entry<String, String> entry : this.getCodecOpts().entrySet()) {
            this.setEncoderOption(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, String> getCodecOpts() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.outputVideoCodec == null) {
            return map;
        }
        if (this.codecOpts == null) {
            return map;
        }
        String opts = this.codecOpts.get(this.outputVideoCodec.name().toLowerCase());
        if (opts == null) {
            return map;
        }
        for (String entry : opts.split(",")) {
            String[] split = entry.split(":");
            map.put(split[0], split[1]);
        }
        return map;
    }

    private String setter(String key) {
        if (key.length() == 0 || key == null) {
            return "";
        }
        char[] chars = key.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return "set" + new String(chars);
    }

    private void setEncoderOption(String key, String value) {
        Method[] methods;
        for (Method method : methods = this.videoEncoder.getClass().getMethods()) {
            Object val;
            Parameter[] parameters;
            if (!this.setter(key).equals(method.getName()) || (parameters = method.getParameters()).length != 1 || (val = this.parseVal(parameters[0].getType(), value)) == null) continue;
            try {
                method.invoke((Object)this.videoEncoder, val);
            }
            catch (Exception e) {
                Logger.error("Couldn't set codec option " + key + ", " + e.getClass().getName() + "[" + e.getMessage() + "]");
            }
        }
    }

    private Object parseVal(Class<?> type, String value) {
        if (type == String.class) {
            return value;
        }
        if (type == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        if (type == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (type == Double.TYPE) {
            return Double.parseDouble(value);
        }
        Logger.error("Unsupported codec argument type: " + type.getName());
        return null;
    }

    protected VideoEncoder.EncodedFrame encodeVideo(Picture frame, ByteBuffer _out) {
        if (!this.outputFormat.isVideo()) {
            return null;
        }
        return this.videoEncoder.encodeFrame(frame, _out);
    }

    private AudioEncoder createAudioEncoder(Codec codec, AudioFormat format) {
        if (codec != Codec.PCM) {
            throw new RuntimeException("Only PCM audio encoding (RAW audio) is supported.");
        }
        return new RawAudioEncoder();
    }

    protected ByteBuffer encodeAudio(AudioBuffer audioBuffer) {
        if (this.audioEncoder == null) {
            AudioFormat format = audioBuffer.getFormat();
            this.audioEncoder = this.createAudioEncoder(this.outputAudioCodec, format);
        }
        return this.audioEncoder.encode(audioBuffer.getData(), null);
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setInterlaced(Boolean interlaced) {
        this.interlaced = interlaced;
    }

    @Override
    public void outputVideoFrame(VideoFrameWithPacket videoFrame) throws IOException {
        if (!this.outputFormat.isVideo() || this.outputVideoCodec == null) {
            return;
        }
        ByteBuffer buffer = this.bufferStore.get();
        int bufferSize = this.videoEncoder.estimateBufferSize(videoFrame.getFrame().getPicture());
        if (buffer == null || bufferSize < buffer.capacity()) {
            buffer = ByteBuffer.allocate(bufferSize);
            this.bufferStore.set(buffer);
        }
        buffer.clear();
        Picture frame = videoFrame.getFrame().getPicture();
        VideoEncoder.EncodedFrame enc = this.encodeVideo(frame, buffer);
        Packet outputVideoPacket = Packet.createPacketWithData(videoFrame.getPacket(), NIOUtils.clone(enc.getData()));
        outputVideoPacket.setFrameType(enc.isKeyFrame() ? Packet.FrameType.KEY : Packet.FrameType.INTER);
        this.outputVideoPacket(outputVideoPacket, VideoCodecMeta.createSimpleVideoCodecMeta(new Size(frame.getWidth(), frame.getHeight()), frame.getColor()));
    }

    @Override
    public void outputAudioFrame(AudioFrameWithPacket audioFrame) throws IOException {
        if (!this.outputFormat.isAudio() || this.outputAudioCodec == null) {
            return;
        }
        this.outputAudioPacket(Packet.createPacketWithData(audioFrame.getPacket(), this.encodeAudio(audioFrame.getAudio())), AudioCodecMeta.fromAudioFormat(audioFrame.getAudio().getFormat()));
    }

    @Override
    public ColorSpace getInputColor() {
        if (this.videoEncoder == null) {
            throw new IllegalStateException("Video encoder has not been initialized, init() must be called before using this class.");
        }
        ColorSpace[] colorSpaces = this.videoEncoder.getSupportedColorSpaces();
        return colorSpaces == null ? null : colorSpaces[0];
    }

    @Override
    public void setOption(Options option, Object value) {
        if (option == Options.PROFILE) {
            this.profile = (String)value;
        } else if (option == Options.INTERLACED) {
            this.interlaced = (Boolean)value;
        }
    }

    @Override
    public boolean isVideo() {
        return this.outputFormat.isVideo();
    }

    @Override
    public boolean isAudio() {
        return this.outputFormat.isAudio();
    }

    @Override
    public boolean isInitialised() {
        return this.muxer != null;
    }

    @Override
    public void setCodecOpts(Map<String, String> codecOpts) {
        this.codecOpts = codecOpts;
    }

    private static class RawAudioEncoder
    implements AudioEncoder {
        private RawAudioEncoder() {
        }

        @Override
        public ByteBuffer encode(ByteBuffer audioPkt, ByteBuffer buf) {
            return audioPkt;
        }
    }
}

