/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.encode;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.encode.EncodedMB;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.CAVLC;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.io.model.MBType;

public class EncodingContext {
    public CAVLC[] cavlc;
    public byte[][] leftRow;
    public byte[][] topLine;
    public byte[] topLeft;
    public int[] mvTopX;
    public int[] mvTopY;
    public int[] mvTopR;
    public int[] mvLeftX;
    public int[] mvLeftY;
    public int[] mvLeftR;
    public int mvTopLeftX;
    public int mvTopLeftY;
    public int mvTopLeftR;
    public int mbHeight;
    public int mbWidth;
    public int prevQp;
    public int[] i4x4PredTop;
    public int[] i4x4PredLeft;
    public MBType leftMBType;
    public MBType[] topMBType;

    public EncodingContext(int mbWidth, int mbHeight) {
        this.mbWidth = mbWidth;
        this.mbHeight = mbHeight;
        this.leftRow = new byte[][]{new byte[16], new byte[8], new byte[8]};
        this.topLine = new byte[][]{new byte[mbWidth << 4], new byte[mbWidth << 3], new byte[mbWidth << 3]};
        this.topLeft = new byte[4];
        this.mvTopX = new int[mbWidth << 2];
        this.mvTopY = new int[mbWidth << 2];
        this.mvTopR = new int[mbWidth << 2];
        this.mvLeftX = new int[4];
        this.mvLeftY = new int[4];
        this.mvLeftR = new int[4];
        this.i4x4PredTop = new int[mbWidth << 2];
        this.i4x4PredLeft = new int[4];
        this.topMBType = new MBType[mbWidth];
    }

    public void update(EncodedMB mb) {
        if (mb.getType() != MBType.I_NxN) {
            this.topLeft[0] = this.topLine[0][(mb.mbX << 4) + 15];
            System.arraycopy(mb.pixels.getPlaneData(0), 240, this.topLine[0], mb.mbX << 4, 16);
            this.copyCol(mb.pixels.getPlaneData(0), 15, 16, this.leftRow[0]);
        }
        this.topLeft[1] = this.topLine[1][(mb.mbX << 3) + 7];
        this.topLeft[2] = this.topLine[2][(mb.mbX << 3) + 7];
        System.arraycopy(mb.pixels.getPlaneData(1), 56, this.topLine[1], mb.mbX << 3, 8);
        System.arraycopy(mb.pixels.getPlaneData(2), 56, this.topLine[2], mb.mbX << 3, 8);
        this.copyCol(mb.pixels.getPlaneData(1), 7, 8, this.leftRow[1]);
        this.copyCol(mb.pixels.getPlaneData(2), 7, 8, this.leftRow[2]);
        this.mvTopLeftX = this.mvTopX[mb.mbX << 2];
        this.mvTopLeftY = this.mvTopY[mb.mbX << 2];
        this.mvTopLeftR = this.mvTopR[mb.mbX << 2];
        for (int i = 0; i < 4; ++i) {
            this.mvTopX[(mb.mbX << 2) + i] = mb.mx[12 + i];
            this.mvTopY[(mb.mbX << 2) + i] = mb.my[12 + i];
            this.mvTopR[(mb.mbX << 2) + i] = mb.mr[12 + i];
            this.mvLeftX[i] = mb.mx[i << 2];
            this.mvLeftY[i] = mb.my[i << 2];
            this.mvLeftR[i] = mb.mr[i << 2];
        }
        this.topMBType[mb.mbX] = this.leftMBType = mb.getType();
    }

    private void copyCol(byte[] planeData, int off, int stride, byte[] out) {
        for (int i = 0; i < out.length; ++i) {
            out[i] = planeData[off];
            off += stride;
        }
    }

    public EncodingContext fork() {
        int i;
        EncodingContext ret = new EncodingContext(this.mbWidth, this.mbHeight);
        ret.cavlc = new CAVLC[3];
        for (i = 0; i < 3; ++i) {
            System.arraycopy(this.leftRow[i], 0, ret.leftRow[i], 0, this.leftRow[i].length);
            System.arraycopy(this.topLine[i], 0, ret.topLine[i], 0, this.topLine[i].length);
            ret.topLeft[i] = this.topLeft[i];
            ret.cavlc[i] = this.cavlc[i].fork();
        }
        System.arraycopy(this.mvTopX, 0, ret.mvTopX, 0, ret.mvTopX.length);
        System.arraycopy(this.mvTopY, 0, ret.mvTopY, 0, ret.mvTopY.length);
        System.arraycopy(this.mvTopR, 0, ret.mvTopR, 0, ret.mvTopR.length);
        System.arraycopy(this.mvLeftX, 0, ret.mvLeftX, 0, ret.mvLeftX.length);
        System.arraycopy(this.mvLeftY, 0, ret.mvLeftY, 0, ret.mvLeftY.length);
        System.arraycopy(this.mvLeftR, 0, ret.mvLeftR, 0, ret.mvLeftR.length);
        ret.mvTopLeftX = this.mvTopLeftX;
        ret.mvTopLeftY = this.mvTopLeftY;
        ret.mvTopLeftR = this.mvTopLeftR;
        ret.prevQp = this.prevQp;
        for (i = 0; i < this.mbWidth; ++i) {
            ret.topMBType[i] = this.topMBType[i];
        }
        ret.leftMBType = this.leftMBType;
        System.arraycopy(this.i4x4PredTop, 0, ret.i4x4PredTop, 0, this.mbWidth << 2);
        System.arraycopy(this.i4x4PredLeft, 0, ret.i4x4PredLeft, 0, 4);
        return ret;
    }
}

