/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.mpeg12;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.mpeg12.MPEGDecoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.mpeg12.SegmentReader;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.mpeg12.bitstream.PictureHeader;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mps.MPEGPacket;

public class MPEGES
extends SegmentReader {
    private int frameNo;
    public long lastKnownDuration;

    public MPEGES(ReadableByteChannel channel, int fetchSize) throws IOException {
        super(channel, fetchSize);
    }

    public MPEGPacket frame(ByteBuffer buffer) throws IOException {
        MPEGPacket mPEGPacket;
        ByteBuffer dup = buffer.duplicate();
        while (this.curMarker != 256 && this.curMarker != 435 && this.skipToMarker()) {
        }
        while (this.curMarker != 256 && this.readToNextMarker(dup)) {
        }
        this.readToNextMarker(dup);
        while (this.curMarker != 256 && this.curMarker != 435 && this.readToNextMarker(dup)) {
        }
        dup.flip();
        PictureHeader ph = MPEGDecoder.getPictureHeader(dup.duplicate());
        if (dup.hasRemaining()) {
            long l = this.frameNo++;
            mPEGPacket = new MPEGPacket(dup, 0L, 90000, 0L, l, ph.picture_coding_type <= 1 ? Packet.FrameType.KEY : Packet.FrameType.INTER, null);
        } else {
            mPEGPacket = null;
        }
        return mPEGPacket;
    }

    public MPEGPacket getFrame() throws IOException {
        MPEGPacket mPEGPacket;
        while (this.curMarker != 256 && this.curMarker != 435 && this.skipToMarker()) {
        }
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        while (this.curMarker != 256 && !this.done) {
            this.readToNextMarkerBuffers(buffers);
        }
        this.readToNextMarkerBuffers(buffers);
        while (this.curMarker != 256 && this.curMarker != 435 && !this.done) {
            this.readToNextMarkerBuffers(buffers);
        }
        ByteBuffer dup = NIOUtils.combineBuffers(buffers);
        PictureHeader ph = MPEGDecoder.getPictureHeader(dup.duplicate());
        if (dup.hasRemaining()) {
            long l = this.frameNo++;
            mPEGPacket = new MPEGPacket(dup, 0L, 90000, 0L, l, ph.picture_coding_type <= 1 ? Packet.FrameType.KEY : Packet.FrameType.INTER, null);
        } else {
            mPEGPacket = null;
        }
        return mPEGPacket;
    }
}

