/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import java.util.ArrayList;
import java.util.EnumSet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.OnyxIf;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.VP8Exception;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecAlgPRiv;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecEncCfg;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecPkt;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.AlgoFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.CompressMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameTypeFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.GeneralFrameFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.InitFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.PacketKind;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Picture;

public class CXInterface {
    public static int VPX_DL_REALTIME = 1;
    public static int VPX_DL_GOOD_QUALITY = 1000000;
    public static int VPX_DL_BEST_QUALITY = 0;

    static void validate_img(CodecAlgPRiv ctx, Picture img) {
        if (img.getWidth() != ctx.cfg.getG_w() || img.getHeight() != ctx.cfg.getG_h()) {
            VP8Exception.ERROR("Image size must match encoder init configuration size");
        }
    }

    static void pick_quickcompress_mode(CodecAlgPRiv ctx, long duration, long deadline) {
        CompressMode new_qc = CompressMode.BESTQUALITY;
        if (deadline != 0L) {
            long duration_us = duration * ctx.timestamp_ratio.getNum() / (ctx.timestamp_ratio.getDen() * 10L);
            CompressMode compressMode = new_qc = deadline > duration_us ? CompressMode.GOODQUALITY : CompressMode.REALTIME;
        }
        if (deadline == (long)VPX_DL_REALTIME) {
            new_qc = CompressMode.REALTIME;
        }
        if (ctx.oxcf.Mode != new_qc) {
            ctx.oxcf.Mode = new_qc;
            ctx.cpi.vp8_change_config(ctx.oxcf);
        }
    }

    static void set_reference_and_update(CodecAlgPRiv ctx, EnumSet<AlgoFlags> flags) {
        if (flags.contains((Object)AlgoFlags.NO_UPD_GF) && flags.contains((Object)AlgoFlags.FORCE_GF) || flags.contains((Object)AlgoFlags.NO_UPD_ARF) && flags.contains((Object)AlgoFlags.FORCE_ARF)) {
            VP8Exception.ERROR("Conflicting flags.");
        }
        boolean update = false;
        EnumSet<MVReferenceFrame> referenceFrames = EnumSet.allOf(MVReferenceFrame.class);
        if (flags.contains((Object)AlgoFlags.NO_REF_LAST)) {
            update = true;
            referenceFrames.remove((Object)MVReferenceFrame.LAST_FRAME);
        }
        if (flags.contains((Object)AlgoFlags.NO_REF_GF)) {
            update = true;
            referenceFrames.remove((Object)MVReferenceFrame.GOLDEN_FRAME);
        }
        if (flags.contains((Object)AlgoFlags.NO_REF_ARF)) {
            update = true;
            referenceFrames.remove((Object)MVReferenceFrame.ALTREF_FRAME);
        }
        if (update) {
            OnyxIf.vp8_use_as_reference(ctx.cpi, referenceFrames);
        }
        update = false;
        referenceFrames = EnumSet.allOf(MVReferenceFrame.class);
        if (flags.contains((Object)AlgoFlags.NO_UPD_LAST)) {
            update = true;
            referenceFrames.remove((Object)MVReferenceFrame.LAST_FRAME);
        }
        if (flags.contains((Object)AlgoFlags.NO_UPD_GF)) {
            update = true;
            referenceFrames.remove((Object)MVReferenceFrame.GOLDEN_FRAME);
        }
        if (flags.contains((Object)AlgoFlags.NO_UPD_ARF)) {
            update = true;
            referenceFrames.remove((Object)MVReferenceFrame.ALTREF_FRAME);
        }
        if (update) {
            OnyxIf.vp8_update_reference(ctx.cpi, referenceFrames);
        }
        if (flags.contains((Object)AlgoFlags.NO_UPD_ENTROPY)) {
            OnyxIf.vp8_update_entropy(ctx.cpi, false);
        }
    }

    public static void vp8e_encode(CodecAlgPRiv ctx, Picture img, long pts_val, long duration, EnumSet<AlgoFlags> flags, long deadline) {
        if (ctx.cfg.getRc_target_bitrate() == 0) {
            return;
        }
        if (img != null) {
            CXInterface.validate_img(ctx, img);
        }
        if (!ctx.pts_offset_initialized) {
            ctx.pts_offset = (int)pts_val;
            ctx.pts_offset_initialized = true;
        }
        pts_val -= (long)ctx.pts_offset;
        CXInterface.pick_quickcompress_mode(ctx, duration, deadline);
        ctx.pkt_list = new ArrayList<CodecPkt>();
        if (flags.isEmpty()) {
            flags = EnumSet.copyOf(ctx.control_frame_flags);
        }
        ctx.control_frame_flags.clear();
        CXInterface.set_reference_and_update(ctx, flags);
        if (ctx.cfg.getKf_mode() == CodecEncCfg.vpx_kf_mode.VPX_KF_AUTO && ctx.cfg.getKf_min_dist() == ctx.cfg.getKf_max_dist() && ++ctx.fixed_kf_cntr > ctx.cfg.getKf_min_dist()) {
            flags.add(AlgoFlags.FORCE_KF);
            ctx.fixed_kf_cntr = 1;
        }
        if (ctx.cpi != null) {
            OnyxIf.TimeStampRange dst_ts = new OnyxIf.TimeStampRange();
            int size = 0;
            ctx.cpi.b_calculate_psnr = ctx.base.init_flags.contains((Object)InitFlags.USE_PSNR);
            ctx.cpi.output_partition = ctx.base.init_flags.contains((Object)InitFlags.USE_OUTPUT_PARTITION);
            EnumSet<FrameTypeFlags> lib_flags = flags.contains((Object)AlgoFlags.FORCE_KF) ? EnumSet.of(FrameTypeFlags.Key) : EnumSet.noneOf(FrameTypeFlags.class);
            double tsratio = ctx.timestamp_ratio.scalar();
            dst_ts.time_stamp = (long)((double)pts_val * tsratio);
            dst_ts.time_end = (long)((double)(pts_val + duration) * tsratio);
            if (img != null) {
                YV12buffer sd = new YV12buffer(img);
                EnumSet<FrameTypeFlags> passedFlags = EnumSet.copyOf(ctx.next_frame_flag);
                passedFlags.addAll(lib_flags);
                OnyxIf.vp8_receive_raw_frame(ctx.cpi, passedFlags, sd, dst_ts.time_stamp, dst_ts.time_end);
                ctx.next_frame_flag.clear();
            }
            FullAccessIntArrPointer cx_data = ctx.cx_data.shallowCopy();
            int cx_data_sz = ctx.cx_data.size() - 1;
            FullAccessIntArrPointer cx_data_end = ctx.cx_data.shallowCopyWithPosInc(cx_data_sz);
            lib_flags.clear();
            while (cx_data_sz >= ctx.cx_data.size() / 2 && (size = OnyxIf.vp8_get_compressed_data(ctx.cpi, lib_flags, cx_data, cx_data_end, dst_ts, img == null)) != -1) {
                if (size == 0) continue;
                CodecPkt pkt = new CodecPkt();
                Compressor cpi = ctx.cpi;
                long round = ctx.timestamp_ratio.getNum() / 2L;
                if (round > 0L) {
                    --round;
                }
                long delta = dst_ts.time_end - dst_ts.time_stamp;
                pkt.kind = PacketKind.FRAME_PKT;
                CodecPkt.FramePacket fp = new CodecPkt.FramePacket();
                pkt.packet = fp;
                fp.pts = (dst_ts.time_stamp * ctx.timestamp_ratio.getDen() + round) / ctx.timestamp_ratio.getNum() + (long)ctx.pts_offset;
                fp.duration = (delta * ctx.timestamp_ratio.getDen() + round) / ctx.timestamp_ratio.getNum();
                fp.vp8flags = EnumSet.copyOf(lib_flags);
                fp.flags = EnumSet.noneOf(GeneralFrameFlags.class);
                fp.width = cpi.common.Width;
                fp.height = cpi.common.Height;
                if (lib_flags.contains((Object)FrameTypeFlags.Key)) {
                    fp.flags.add(GeneralFrameFlags.FRAME_IS_KEY);
                }
                if (!cpi.common.show_frame) {
                    fp.flags.add(GeneralFrameFlags.FRAME_IS_INVISIBLE);
                    fp.pts = (cpi.last_time_stamp_seen * ctx.timestamp_ratio.getDen() + round) / ctx.timestamp_ratio.getNum() + (long)ctx.pts_offset + 1L;
                    fp.duration = 0L;
                }
                if (cpi.droppable) {
                    fp.flags.add(GeneralFrameFlags.FRAME_IS_DROPPABLE);
                }
                if (cpi.output_partition) {
                    int num_partitions = (1 << cpi.common.multi_token_partition.ordinal()) + 1;
                    fp.flags.add(GeneralFrameFlags.FRAME_IS_FRAGMENT);
                    for (int i = 0; i < num_partitions; ++i) {
                        fp.buf = cx_data.shallowCopy();
                        cx_data.incBy(cpi.partition_sz[i]);
                        cx_data_sz -= cpi.partition_sz[i];
                        fp.sz = cpi.partition_sz[i];
                        fp.partition_id = i;
                        if (i == num_partitions - 1) {
                            fp.flags.remove((Object)GeneralFrameFlags.FRAME_IS_FRAGMENT);
                        }
                        ctx.pkt_list.add(pkt);
                    }
                    continue;
                }
                fp.buf = cx_data.shallowCopy();
                fp.sz = size;
                fp.partition_id = -1;
                ctx.pkt_list.add(pkt);
                cx_data.incBy(size);
                cx_data_sz -= size;
            }
            if (ctx.cpi.oxcf.hinter != null) {
                ctx.cpi.oxcf.hinter.setFrameIsRepeat(false);
            }
        }
    }
}

