/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VP8Util;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.VPXConst;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.InvTrans;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Quantize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.ReconInter;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Subtract;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Block;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.DCTValueConstants;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyContextPlanes;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Macroblock;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.TokenState;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.PlaneType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenAlphabet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class EncodeMB {
    static void vp8_subtract_b(Block be, BlockD bd, int pitch) {
        Subtract.vpx_subtract_block(4, 4, be.src_diff, pitch, be.getSrcPtr(), be.src_stride, bd.predictor, pitch);
    }

    static void vp8_subtract_mby(FullAccessIntArrPointer diff, ReadOnlyIntArrPointer src, int src_stride, ReadOnlyIntArrPointer pred, int pred_stride) {
        Subtract.vpx_subtract_block(16, 16, diff, 16, src, src_stride, pred, pred_stride);
    }

    static void build_dcblock(Macroblock x) {
        int i = 0;
        int j = 384;
        while (i < 16) {
            x.src_diff.setAbs(j, x.coeff.getRel(i << 4));
            ++i;
            ++j;
        }
    }

    static void vp8_transform_intra_mby(Macroblock x) {
        for (int i = 0; i < 16; i += 2) {
            x.short_fdct8x4.call(x.block.getRel((int)i).src_diff, x.block.getRel((int)i).coeff, 32);
        }
        EncodeMB.build_dcblock(x);
        x.short_walsh4x4.call(x.block.getRel((int)24).src_diff, x.block.getRel((int)24).coeff, 8);
    }

    static int RDCOST(int RM, int DM, int R, int D) {
        return (128 + R * RM >> 8) + DM * D;
    }

    static int RDTRUNC(int RM, int DM, int R, int D) {
        return 128 + R * RM & 0xFF;
    }

    static void optimize_b(Macroblock mb, int ib, PlaneType type, FullAccessIntArrPointer a, FullAccessIntArrPointer l) {
        TokenAlphabet t1;
        int best;
        int rd_cost1;
        int rd_cost0;
        int band;
        TokenAlphabet t0;
        int rate1;
        int rate0;
        int error1;
        int error0;
        int x;
        int rc;
        TokenState[][] tokens = new TokenState[17][2];
        int[] best_mask = new int[2];
        int sz = 0;
        int err_mult = type.rd_mult;
        Block b = mb.block.getRel(ib);
        BlockD d = mb.e_mbd.block.getRel(ib);
        ReadOnlyIntArrPointer dequant_ptr = d.dequant.readOnly();
        FullAccessIntArrPointer coeff_ptr = b.coeff;
        FullAccessIntArrPointer qcoeff_ptr = d.qcoeff.shallowCopy();
        FullAccessIntArrPointer dqcoeff_ptr = d.dqcoeff.shallowCopy();
        int i0 = type.start_coeff;
        int eob = d.eob.get();
        int rdmult = mb.rdmult * err_mult;
        if (mb.e_mbd.mode_info_context.get().mbmi.ref_frame == MVReferenceFrame.INTRA_FRAME) {
            rdmult = rdmult * 9 >> 4;
        }
        int rddiv = mb.rddiv;
        best_mask[1] = 0;
        best_mask[0] = 0;
        tokens[eob][0] = new TokenState(0, 0, 16, TokenAlphabet.DCT_EOB_TOKEN, 0);
        tokens[eob][1] = new TokenState(tokens[eob][0]);
        int next = eob;
        int i = eob;
        while (i-- > i0) {
            rc = VPXConst.zigzag[i];
            x = qcoeff_ptr.getRel(rc);
            if (x != 0) {
                boolean shortcut = false;
                error0 = tokens[next][0].error;
                error1 = tokens[next][1].error;
                rate0 = tokens[next][0].rate;
                rate1 = tokens[next][1].rate;
                t0 = DCTValueConstants.getTokenValue((int)x).token;
                if (next < 16) {
                    band = VP8Util.SubblockConstants.vp8CoefBands[i + 1];
                    rate0 += mb.token_costs[type.ordinal()][band][t0.previousTokenClass][tokens[next][0].token.ordinal()];
                    rate1 += mb.token_costs[type.ordinal()][band][t0.previousTokenClass][tokens[next][1].token.ordinal()];
                }
                if ((rd_cost0 = EncodeMB.RDCOST(rdmult, rddiv, rate0, error0)) == (rd_cost1 = EncodeMB.RDCOST(rdmult, rddiv, rate1, error1))) {
                    rd_cost0 = EncodeMB.RDTRUNC(rdmult, rddiv, rate0, error0);
                    rd_cost1 = EncodeMB.RDTRUNC(rdmult, rddiv, rate1, error1);
                }
                best = rd_cost1 < rd_cost0 ? 1 : 0;
                int base_bits = DCTValueConstants.getValueCost(x);
                int dx = dqcoeff_ptr.getRel(rc) - coeff_ptr.getRel(rc);
                int d2 = dx * dx;
                tokens[i][0] = new TokenState(base_bits + (best > 0 ? rate1 : rate0), d2 + (best > 0 ? error1 : error0), next, t0, x);
                best_mask[0] = best_mask[0] | best << i;
                rate0 = tokens[next][0].rate;
                rate1 = tokens[next][1].rate;
                if (Math.abs(x) * dequant_ptr.getRel(rc) > Math.abs(coeff_ptr.getRel(rc)) && Math.abs(x) * dequant_ptr.getRel(rc) < Math.abs(coeff_ptr.getRel(rc)) + dequant_ptr.getRel(rc)) {
                    shortcut = true;
                }
                if (shortcut) {
                    sz = x < 0 ? -1 : 0;
                    x -= 2 * sz + 1;
                }
                if (x == 0) {
                    t0 = tokens[next][0].token == TokenAlphabet.DCT_EOB_TOKEN ? TokenAlphabet.DCT_EOB_TOKEN : TokenAlphabet.ZERO_TOKEN;
                    t1 = tokens[next][1].token == TokenAlphabet.DCT_EOB_TOKEN ? TokenAlphabet.DCT_EOB_TOKEN : TokenAlphabet.ZERO_TOKEN;
                } else {
                    t0 = t1 = DCTValueConstants.getTokenValue((int)x).token;
                }
                if (next < 16) {
                    band = VP8Util.SubblockConstants.vp8CoefBands[i + 1];
                    if (t0 != TokenAlphabet.DCT_EOB_TOKEN) {
                        rate0 += mb.token_costs[type.ordinal()][band][t0.previousTokenClass][tokens[next][0].token.ordinal()];
                    }
                    if (t1 != TokenAlphabet.DCT_EOB_TOKEN) {
                        rate1 += mb.token_costs[type.ordinal()][band][t1.previousTokenClass][tokens[next][1].token.ordinal()];
                    }
                }
                if ((rd_cost0 = EncodeMB.RDCOST(rdmult, rddiv, rate0, error0)) == (rd_cost1 = EncodeMB.RDCOST(rdmult, rddiv, rate1, error1))) {
                    rd_cost0 = EncodeMB.RDTRUNC(rdmult, rddiv, rate0, error0);
                    rd_cost1 = EncodeMB.RDTRUNC(rdmult, rddiv, rate1, error1);
                }
                best = rd_cost1 < rd_cost0 ? 1 : 0;
                base_bits = DCTValueConstants.getValueCost(x);
                if (shortcut) {
                    d2 = (dx -= dequant_ptr.getRel(rc) + sz ^ sz) * dx;
                }
                tokens[i][1] = new TokenState(base_bits + (best > 0 ? rate1 : rate0), d2 + (best > 0 ? error1 : error0), next, best > 0 ? t1 : t0, x);
                best_mask[1] = best_mask[1] | best << i;
                next = i;
                continue;
            }
            band = VP8Util.SubblockConstants.vp8CoefBands[i + 1];
            t0 = tokens[next][0].token;
            t1 = tokens[next][1].token;
            if (t0 != TokenAlphabet.DCT_EOB_TOKEN) {
                tokens[next][0].rate += mb.token_costs[type.ordinal()][band][0][t0.ordinal()];
                tokens[next][0].token = TokenAlphabet.ZERO_TOKEN;
            }
            if (t1 == TokenAlphabet.DCT_EOB_TOKEN) continue;
            tokens[next][1].rate += mb.token_costs[type.ordinal()][band][0][t1.ordinal()];
            tokens[next][1].token = TokenAlphabet.ZERO_TOKEN;
        }
        band = VP8Util.SubblockConstants.vp8CoefBands[i + 1];
        int pt = a.get() + l.get();
        rate0 = tokens[next][0].rate;
        rate1 = tokens[next][1].rate;
        error0 = tokens[next][0].error;
        error1 = tokens[next][1].error;
        t0 = tokens[next][0].token;
        t1 = tokens[next][1].token;
        rd_cost0 = EncodeMB.RDCOST(rdmult, rddiv, rate0 += mb.token_costs[type.ordinal()][band][pt][t0.ordinal()], error0);
        if (rd_cost0 == (rd_cost1 = EncodeMB.RDCOST(rdmult, rddiv, rate1 += mb.token_costs[type.ordinal()][band][pt][t1.ordinal()], error1))) {
            rd_cost0 = EncodeMB.RDTRUNC(rdmult, rddiv, rate0, error0);
            rd_cost1 = EncodeMB.RDTRUNC(rdmult, rddiv, rate1, error1);
        }
        best = rd_cost1 < rd_cost0 ? 1 : 0;
        int final_eob = i0 - 1;
        i = next;
        while (i < eob) {
            x = tokens[i][best].qc;
            if (x != 0) {
                final_eob = i;
            }
            rc = VPXConst.zigzag[i];
            qcoeff_ptr.setRel(rc, (short)x);
            dqcoeff_ptr.setRel(rc, (short)(x * dequant_ptr.getRel(rc)));
            next = tokens[i][best].next;
            best = best_mask[best] >> i & 1;
            i = next;
        }
        a.set(l.set((short)(++final_eob != type.start_coeff ? 1 : 0)));
        d.eob.set((short)final_eob);
    }

    public static void check_reset_2nd_coeffs(MacroblockD x, PlaneType type, FullAccessIntArrPointer a, FullAccessIntArrPointer l) {
        int i;
        int sum = 0;
        BlockD bd = x.block.getRel(24);
        if (bd.dequant.get() >= 35 && bd.dequant.get() >= 35) {
            return;
        }
        for (i = 0; i < bd.eob.get(); ++i) {
            short coef = bd.dqcoeff.getRel(VPXConst.zigzag[i]);
            if ((sum += coef >= 0 ? coef : -coef) < 35) continue;
            return;
        }
        if (sum < 35) {
            for (i = 0; i < bd.eob.get(); ++i) {
                int rc = VPXConst.zigzag[i];
                bd.qcoeff.setRel(rc, (short)0);
                bd.dqcoeff.setRel(rc, (short)0);
            }
            bd.eob.set((short)0);
            a.set(l.set((short)(bd.eob.get() != type.start_coeff ? 1 : 0)));
        }
    }

    static void vp8_optimize_mby(Macroblock x) {
        int b;
        if (x.e_mbd.above_context == null || x.e_mbd.left_context == null) {
            return;
        }
        EntropyContextPlanes t_above = new EntropyContextPlanes(x.e_mbd.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(x.e_mbd.left_context);
        FullAccessIntArrPointer ta = t_above.panes;
        FullAccessIntArrPointer tl = t_left.panes;
        boolean has_2nd_order = x.e_mbd.hasSecondOrder();
        PlaneType type = has_2nd_order ? PlaneType.Y_NO_DC : PlaneType.Y_WITH_DC;
        for (b = 0; b < 16; ++b) {
            ta.setPos(BlockD.vp8_block2above[b]);
            tl.setPos(BlockD.vp8_block2left[b]);
            EncodeMB.optimize_b(x, b, type, ta, tl);
        }
        if (has_2nd_order) {
            b = 24;
            ta.setPos(BlockD.vp8_block2above[b]);
            tl.setPos(BlockD.vp8_block2left[b]);
            EncodeMB.optimize_b(x, b, PlaneType.Y2, ta, tl);
            EncodeMB.check_reset_2nd_coeffs(x.e_mbd, PlaneType.Y2, ta, tl);
        }
    }

    static void vp8_subtract_mbuv(FullAccessIntArrPointer diff, ReadOnlyIntArrPointer usrc, ReadOnlyIntArrPointer vsrc, int src_stride, ReadOnlyIntArrPointer upred, ReadOnlyIntArrPointer vpred, int pred_stride) {
        FullAccessIntArrPointer udiff = diff.shallowCopyWithPosInc(256);
        FullAccessIntArrPointer vdiff = diff.shallowCopyWithPosInc(320);
        Subtract.vpx_subtract_block(8, 8, udiff, 8, usrc, src_stride, upred, pred_stride);
        Subtract.vpx_subtract_block(8, 8, vdiff, 8, vsrc, src_stride, vpred, pred_stride);
    }

    static void vp8_transform_mbuv(Macroblock x) {
        for (int i = 16; i < 24; i += 2) {
            x.short_fdct8x4.call(x.block.getRel((int)i).src_diff, x.block.getRel((int)i).coeff, 16);
        }
    }

    static void vp8_optimize_mbuv(Macroblock x) {
        if (x.e_mbd.above_context.get() == null || x.e_mbd.left_context == null) {
            return;
        }
        EntropyContextPlanes t_above = new EntropyContextPlanes(x.e_mbd.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(x.e_mbd.left_context);
        FullAccessIntArrPointer ta = t_above.panes;
        FullAccessIntArrPointer tl = t_left.panes;
        for (int b = 16; b < 24; ++b) {
            ta.setPos(BlockD.vp8_block2above[b]);
            tl.setPos(BlockD.vp8_block2left[b]);
            EncodeMB.optimize_b(x, b, PlaneType.UV, ta, tl);
        }
    }

    static void vp8_subtract_mb(Macroblock x) {
        Block b = x.block.get();
        EncodeMB.vp8_subtract_mby(x.src_diff, b.base_src, b.src_stride, x.e_mbd.dst.y_buffer, x.e_mbd.dst.y_stride);
        EncodeMB.vp8_subtract_mbuv(x.src_diff, x.src.u_buffer, x.src.v_buffer, x.src.uv_stride, x.e_mbd.dst.u_buffer, x.e_mbd.dst.v_buffer, x.e_mbd.dst.uv_stride);
    }

    static void transform_mb(Macroblock x) {
        EncodeMB.transform_mby(x);
        for (int i = 16; i < 24; i += 2) {
            x.short_fdct8x4.call(x.block.getRel((int)i).src_diff, x.block.getRel((int)i).coeff, 16);
        }
    }

    static void transform_mby(Macroblock x) {
        for (int i = 0; i < 16; i += 2) {
            Block b = x.block.getRel(i);
            x.short_fdct8x4.call(b.src_diff, b.coeff, 32);
        }
        if (x.e_mbd.mode_info_context.get().mbmi.mode != MBPredictionMode.SPLITMV) {
            EncodeMB.build_dcblock(x);
            Block b = x.block.getRel(24);
            x.short_walsh4x4.call(b.src_diff, b.coeff, 8);
        }
    }

    static void optimize_mb(Macroblock x) {
        int b;
        EntropyContextPlanes t_above = new EntropyContextPlanes(x.e_mbd.above_context.get());
        EntropyContextPlanes t_left = new EntropyContextPlanes(x.e_mbd.left_context);
        FullAccessIntArrPointer ta = t_above.panes;
        FullAccessIntArrPointer tl = t_left.panes;
        boolean has_2nd_order = x.e_mbd.hasSecondOrder();
        PlaneType type = has_2nd_order ? PlaneType.Y_NO_DC : PlaneType.Y_WITH_DC;
        for (b = 0; b < 16; ++b) {
            ta.setPos(BlockD.vp8_block2above[b]);
            tl.setPos(BlockD.vp8_block2left[b]);
            EncodeMB.optimize_b(x, b, type, ta, tl);
        }
        for (b = 16; b < 24; ++b) {
            ta.setPos(BlockD.vp8_block2above[b]);
            tl.setPos(BlockD.vp8_block2left[b]);
            EncodeMB.optimize_b(x, b, PlaneType.UV, ta, tl);
        }
        if (has_2nd_order) {
            b = 24;
            ta.setPos(BlockD.vp8_block2above[b]);
            tl.setPos(BlockD.vp8_block2left[b]);
            EncodeMB.optimize_b(x, b, PlaneType.Y2, ta, tl);
            EncodeMB.check_reset_2nd_coeffs(x.e_mbd, PlaneType.Y2, ta, tl);
        }
    }

    static void vp8_encode_inter16x16(Macroblock x) {
        ReconInter.vp8_build_inter_predictors_mb(x.e_mbd);
        EncodeMB.vp8_subtract_mb(x);
        EncodeMB.transform_mb(x);
        Quantize.vp8_quantize_mb(x);
        if (x.optimize) {
            EncodeMB.optimize_mb(x);
        }
    }

    static void vp8_encode_inter16x16y(Macroblock x) {
        Block b = x.block.get();
        ReconInter.vp8_build_inter16x16_predictors_mby(x.e_mbd, x.e_mbd.dst.y_buffer, x.e_mbd.dst.y_stride);
        EncodeMB.vp8_subtract_mby(x.src_diff, b.base_src, b.src_stride, x.e_mbd.dst.y_buffer, x.e_mbd.dst.y_stride);
        EncodeMB.transform_mby(x);
        Quantize.vp8_quantize_mby(x);
        InvTrans.vp8_inverse_transform_mby(x.e_mbd);
    }
}

