/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import java.util.EnumMap;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MacroblockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeContexts;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;

public class FindNearMV {
    public static final short LEFT_TOP_MARGIN = 128;
    public static final short RIGHT_BOTTOM_MARGIN = 128;
    public static int[][] vp8_mbsplit_offset = new int[][]{{0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 2, 8, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}};

    static void mv_bias(boolean refmb_ref_frame_sign_bias, MVReferenceFrame refframe, MV mvp, EnumMap<MVReferenceFrame, Boolean> ref_frame_sign_bias) {
        if (refmb_ref_frame_sign_bias != ref_frame_sign_bias.get((Object)refframe)) {
            mvp.row = (short)(mvp.row * -1);
            mvp.col = (short)(mvp.col * -1);
        }
    }

    static void vp8_find_near_mvs(MacroblockD xd, FullAccessGenArrPointer<ModeInfo> m, MV nearest, MV nearby, MV best_mv, int[] near_mv_ref_cnts, MVReferenceFrame refframe, EnumMap<MVReferenceFrame, Boolean> ref_frame_sign_bias) {
        ModeInfo above = m.getRel(-xd.mode_info_stride);
        ModeInfo left = m.getRel(-1);
        ModeInfo aboveleft = m.getRel(-xd.mode_info_stride - 1);
        MV[] near_mvs = new MV[4];
        MV this_mv = new MV();
        for (int i = 0; i < near_mvs.length; ++i) {
            near_mv_ref_cnts[i] = 0;
        }
        int nearMVidx = 0;
        int rcntIdx = 0;
        if (above.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
            if (!above.mbmi.mv.isZero()) {
                near_mvs[++nearMVidx] = new MV(above.mbmi.mv);
                FindNearMV.mv_bias(ref_frame_sign_bias.get((Object)above.mbmi.ref_frame), refframe, near_mvs[nearMVidx], ref_frame_sign_bias);
            }
            int n = ++rcntIdx;
            near_mv_ref_cnts[n] = near_mv_ref_cnts[n] + 2;
        }
        if (left.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
            if (!left.mbmi.mv.isZero()) {
                this_mv.set(left.mbmi.mv);
                FindNearMV.mv_bias(ref_frame_sign_bias.get((Object)left.mbmi.ref_frame), refframe, this_mv, ref_frame_sign_bias);
                if (!this_mv.equals(near_mvs[nearMVidx])) {
                    near_mvs[++nearMVidx] = new MV(this_mv);
                }
                int n = ++rcntIdx;
                near_mv_ref_cnts[n] = near_mv_ref_cnts[n] + 2;
            } else {
                int n = Cntmodes.CNT_INTRA.ordinal();
                near_mv_ref_cnts[n] = near_mv_ref_cnts[n] + 2;
            }
        }
        if (aboveleft.mbmi.ref_frame != MVReferenceFrame.INTRA_FRAME) {
            if (!aboveleft.mbmi.mv.isZero()) {
                this_mv.set(aboveleft.mbmi.mv);
                FindNearMV.mv_bias(ref_frame_sign_bias.get((Object)aboveleft.mbmi.ref_frame), refframe, this_mv, ref_frame_sign_bias);
                if (!this_mv.equals(near_mvs[nearMVidx])) {
                    near_mvs[++nearMVidx] = new MV(this_mv);
                }
                int n = ++rcntIdx;
                near_mv_ref_cnts[n] = near_mv_ref_cnts[n] + 1;
            } else {
                int n = Cntmodes.CNT_INTRA.ordinal();
                near_mv_ref_cnts[n] = near_mv_ref_cnts[n] + 1;
            }
        }
        if (near_mv_ref_cnts[Cntmodes.CNT_SPLITMV.ordinal()] != 0 && near_mvs[nearMVidx].equals(near_mvs[Cntmodes.CNT_NEAREST.ordinal()])) {
            int n = Cntmodes.CNT_NEAREST.ordinal();
            near_mv_ref_cnts[n] = near_mv_ref_cnts[n] + 1;
        }
        near_mv_ref_cnts[Cntmodes.CNT_SPLITMV.ordinal()] = ((above.mbmi.mode == MBPredictionMode.SPLITMV ? 1 : 0) + (left.mbmi.mode == MBPredictionMode.SPLITMV ? 1 : 0)) * 2 + (aboveleft.mbmi.mode == MBPredictionMode.SPLITMV ? 1 : 0);
        if (near_mv_ref_cnts[Cntmodes.CNT_NEAR.ordinal()] > near_mv_ref_cnts[Cntmodes.CNT_NEAREST.ordinal()]) {
            int tmp = near_mv_ref_cnts[Cntmodes.CNT_NEAREST.ordinal()];
            near_mv_ref_cnts[Cntmodes.CNT_NEAREST.ordinal()] = near_mv_ref_cnts[Cntmodes.CNT_NEAR.ordinal()];
            near_mv_ref_cnts[Cntmodes.CNT_NEAR.ordinal()] = tmp;
            this_mv.set(near_mvs[Cntmodes.CNT_NEAREST.ordinal()]);
            near_mvs[Cntmodes.CNT_NEAREST.ordinal()].set(near_mvs[Cntmodes.CNT_NEAR.ordinal()]);
            near_mvs[Cntmodes.CNT_NEAR.ordinal()].set(this_mv);
        }
        if (near_mv_ref_cnts[Cntmodes.CNT_NEAREST.ordinal()] >= near_mv_ref_cnts[Cntmodes.CNT_INTRA.ordinal()]) {
            near_mvs[Cntmodes.CNT_INTRA.ordinal()] = near_mvs[Cntmodes.CNT_NEAREST.ordinal()];
        }
        best_mv.set(near_mvs[0]);
        nearest.set(near_mvs[Cntmodes.CNT_NEAREST.ordinal()]);
        nearby.set(near_mvs[Cntmodes.CNT_NEAR.ordinal()]);
    }

    public static void vp8_clamp_mv(MV m, short mb_to_left_edge, short mb_to_right_edge, short mb_to_top_edge, short mb_to_bottom_edge) {
        m.col = m.col < mb_to_left_edge ? mb_to_left_edge : m.col;
        m.col = m.col > mb_to_right_edge ? mb_to_right_edge : m.col;
        m.row = m.row < mb_to_top_edge ? mb_to_top_edge : m.row;
        m.row = m.row > mb_to_bottom_edge ? mb_to_bottom_edge : m.row;
    }

    static void vp8_clamp_mv2(MV m, MacroblockD xd) {
        if (m.col < xd.mb_to_left_edge - 128) {
            m.col = (short)(xd.mb_to_left_edge - 128);
        } else if (m.col > xd.mb_to_right_edge + 128) {
            m.col = (short)(xd.mb_to_right_edge + 128);
        }
        if (m.row < xd.mb_to_top_edge - 128) {
            m.row = (short)(xd.mb_to_top_edge - 128);
        } else if (m.row > xd.mb_to_bottom_edge + 128) {
            m.row = (short)(xd.mb_to_bottom_edge + 128);
        }
    }

    static short[] vp8_mv_ref_probs(short[] p, int[] near_mv_ref_ct) {
        p[0] = ModeContexts.vp8_mode_contexts[near_mv_ref_ct[0]][0];
        p[1] = ModeContexts.vp8_mode_contexts[near_mv_ref_ct[1]][1];
        p[2] = ModeContexts.vp8_mode_contexts[near_mv_ref_ct[2]][2];
        p[3] = ModeContexts.vp8_mode_contexts[near_mv_ref_ct[3]][3];
        return p;
    }

    static MV left_block_mv(FullAccessGenArrPointer<ModeInfo> mic, int b) {
        ModeInfo mi = mic.get();
        if ((b & 3) == 0) {
            mi = mic.getRel(-1);
            if (mi.mbmi.mode != MBPredictionMode.SPLITMV) {
                return mi.mbmi.mv.copy();
            }
            b += 4;
        }
        return mi.bmi[b - 1].mv.copy();
    }

    static MV above_block_mv(FullAccessGenArrPointer<ModeInfo> mic, int b, int mi_stride) {
        ModeInfo mi = mic.get();
        if (b >> 2 == 0) {
            mi = mic.getRel(-mi_stride);
            if (mi.mbmi.mode != MBPredictionMode.SPLITMV) {
                return mi.mbmi.mv.copy();
            }
            b += 16;
        }
        return mi.bmi[b - 4].mv.copy();
    }

    static BPredictionMode above_block_mode(FullAccessGenArrPointer<ModeInfo> mic, int b, int mi_stride) {
        if (b >> 2 == 0) {
            ModeInfo mi = mic.getRel(-mi_stride);
            switch (mi.mbmi.mode) {
                case B_PRED: {
                    return mi.bmi[b + 12].as_mode();
                }
                case DC_PRED: {
                    return BPredictionMode.B_DC_PRED;
                }
                case V_PRED: {
                    return BPredictionMode.B_VE_PRED;
                }
                case H_PRED: {
                    return BPredictionMode.B_HE_PRED;
                }
                case TM_PRED: {
                    return BPredictionMode.B_TM_PRED;
                }
            }
            return BPredictionMode.B_DC_PRED;
        }
        return mic.get().bmi[b - 4].as_mode();
    }

    static BPredictionMode left_block_mode(FullAccessGenArrPointer<ModeInfo> mic, int b) {
        if ((b & 3) == 0) {
            ModeInfo mi = mic.getRel(-1);
            switch (mi.mbmi.mode) {
                case B_PRED: {
                    return mi.bmi[b + 3].as_mode();
                }
                case DC_PRED: {
                    return BPredictionMode.B_DC_PRED;
                }
                case V_PRED: {
                    return BPredictionMode.B_VE_PRED;
                }
                case H_PRED: {
                    return BPredictionMode.B_HE_PRED;
                }
                case TM_PRED: {
                    return BPredictionMode.B_TM_PRED;
                }
            }
            return BPredictionMode.B_DC_PRED;
        }
        return mic.get().bmi[b - 1].as_mode();
    }

    static void invert_and_clamp_mvs(MV inv, MV src, MacroblockD xd) {
        inv.row = -src.row;
        inv.col = -src.col;
        FindNearMV.vp8_clamp_mv2(inv, xd);
        FindNearMV.vp8_clamp_mv2(src, xd);
    }

    static boolean vp8_find_near_mvs_bias(MacroblockD xd, FullAccessGenArrPointer<ModeInfo> mi, MV[][] mode_mv_sb, MV[] best_mv_sb, int[] cnt, MVReferenceFrame refframe, EnumMap<MVReferenceFrame, Boolean> ref_frame_sign_bias) {
        boolean sign_bias = ref_frame_sign_bias.get((Object)refframe);
        int sbNorm = sign_bias ? 1 : 0;
        int sbNeg = sign_bias ? 0 : 1;
        FindNearMV.vp8_find_near_mvs(xd, mi, mode_mv_sb[sbNorm][MBPredictionMode.NEARESTMV.ordinal()], mode_mv_sb[sbNorm][MBPredictionMode.NEARMV.ordinal()], best_mv_sb[sbNorm], cnt, refframe, ref_frame_sign_bias);
        FindNearMV.invert_and_clamp_mvs(mode_mv_sb[sbNeg][MBPredictionMode.NEARESTMV.ordinal()], mode_mv_sb[sbNorm][MBPredictionMode.NEARESTMV.ordinal()], xd);
        FindNearMV.invert_and_clamp_mvs(mode_mv_sb[sbNeg][MBPredictionMode.NEARMV.ordinal()], mode_mv_sb[sbNorm][MBPredictionMode.NEARMV.ordinal()], xd);
        FindNearMV.invert_and_clamp_mvs(best_mv_sb[sbNeg], best_mv_sb[sbNorm], xd);
        return sign_bias;
    }

    static enum Cntmodes {
        CNT_INTRA,
        CNT_NEAREST,
        CNT_NEAR,
        CNT_SPLITMV;

    }
}

