/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.CommonUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Token;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class TreeCoder {
    static void vp8_tree_probs_from_distribution(int n, Token[] tok, ReadOnlyIntArrPointer tree, short[] probs, int[][] branch_ct, int[] num_events, int Pfactor, boolean Round) {
        int tree_len = n - 1;
        int t = 0;
        TreeCoder.branch_counts(n, tok, tree, branch_ct, num_events);
        do {
            int[] c;
            int tot;
            if ((tot = (c = branch_ct[t])[0] + c[1]) != 0) {
                short p = (short)(((long)c[0] * (long)Pfactor + (long)(Round ? tot >> 1 : 0)) / (long)tot);
                probs[t] = CommonUtils.clamp(p, (short)1, (short)255);
                continue;
            }
            probs[t] = 128;
        } while (++t < tree_len);
    }

    static void branch_counts(int n, Token[] tok, ReadOnlyIntArrPointer tree, int[][] branch_ct, int[] num_events) {
        int tree_len = n - 1;
        int t = 0;
        assert (tree_len != 0);
        do {
            branch_ct[t][1] = 0;
            branch_ct[t][0] = 0;
        } while (++t < tree_len);
        t = 0;
        do {
            int b;
            int L = tok[t].len;
            int enc = tok[t].value;
            int ct = num_events[t];
            int i = 0;
            do {
                b = enc >> --L & 1;
                int j = i >> 1;
                assert (j < tree_len && 0 <= L);
                int[] nArray = branch_ct[j];
                int n2 = b;
                nArray[n2] = nArray[n2] + ct;
            } while ((i = (int)tree.getRel(i + b)) > 0);
            assert (L == 0);
        } while (++t < n);
    }
}

