/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceFNs;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceResults;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.PositionableIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class Variance {
    public static final VarianceFNs.VF vpx_variance16x16 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 16);
        }
    };
    public static final VarianceFNs.VF vpx_variance16x8 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 8);
        }
    };
    public static final VarianceFNs.VF vpx_variance8x16 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 8, 16);
        }
    };
    public static final VarianceFNs.VF vpx_variance8x8 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 8, 8);
        }
    };
    public static final VarianceFNs.VF vpx_variance4x4 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 4, 4);
        }
    };
    public static final VarianceFNs.VF vpx_mse16x16 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 16, skipVar);
        }
    };
    public static final VarianceFNs.VF vpx_mse16x8 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 16, 8, skipVar);
        }
    };
    public static final VarianceFNs.VF vpx_mse8x16 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 8, 16, skipVar);
        }
    };
    public static final VarianceFNs.VF vpx_mse8x8 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 8, 8, skipVar);
        }
    };
    public static final VarianceFNs.VF vpx_mse4x4 = new VarianceFNs.VF(){

        @Override
        public void call(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults sse) {
            Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 4, 4, skipVar);
        }
    };
    private static final VarCalc calcVar = new VarCalc(){

        @Override
        public void call(VarianceResults ret, int w, int h, long sum) {
            ret.variance = (long)ret.sse - sum * sum / (long)(w * h);
        }
    };
    private static final VarCalc skipVar = new VarCalc(){

        @Override
        public void call(VarianceResults ret, int w, int h, long sum) {
            ret.variance = Long.MAX_VALUE;
        }
    };

    static int vpx_get_mb_ss(ReadOnlyIntArrPointer src_ptr) {
        int sum = 0;
        for (int i = 0; i < 256; ++i) {
            short t = src_ptr.getRel(i);
            sum += t * t;
        }
        return sum;
    }

    static int vpx_get4x4sse_cs(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride) {
        VarianceResults sse = new VarianceResults();
        Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, sse, 4, 4, skipVar);
        return sse.sse;
    }

    static void variance(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults ret, int w, int h) {
        Variance.variance(src_ptr, src_stride, ref_ptr, ref_stride, ret, w, h, calcVar);
    }

    private static void variance(PositionableIntArrPointer src_ptr, int src_stride, PositionableIntArrPointer ref_ptr, int ref_stride, VarianceResults ret, int w, int h, VarCalc varcalc) {
        long sum = 0L;
        ret.sse = 0;
        for (int i = 0; i < h; ++i) {
            int baseSrc = i * src_stride;
            int baseRef = i * ref_stride;
            for (int j = 0; j < w; ++j) {
                int diff = src_ptr.getRel(baseSrc + j) - ref_ptr.getRel(baseRef + j);
                sum += (long)diff;
                ret.sse += diff * diff;
            }
        }
        varcalc.call(ret, w, h, sum);
    }

    static interface VarCalc {
        public void call(VarianceResults var1, int var2, int var3, long var4);
    }
}

