/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.VP8Exception;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecEncCfg;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecPkt;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecPriv;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Config;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ExtraCFG;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.PostprocCfg;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.AlgoFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameTypeFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.PacketKind;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.RationalLarge;

public class CodecAlgPRiv {
    public CodecPriv base = new CodecPriv();
    public CodecEncCfg cfg;
    ExtraCFG vp8_cfg;
    public RationalLarge timestamp_ratio;
    public int pts_offset;
    public boolean pts_offset_initialized;
    public Config oxcf;
    public Compressor cpi;
    public FullAccessIntArrPointer cx_data;
    public EnumSet<FrameTypeFlags> next_frame_flag = EnumSet.noneOf(FrameTypeFlags.class);
    PostprocCfg preview_ppcfg;
    public List<CodecPkt> pkt_list = new ArrayList<CodecPkt>();
    public int fixed_kf_cntr;
    public EnumSet<AlgoFlags> control_frame_flags = EnumSet.noneOf(AlgoFlags.class);

    public CodecAlgPRiv(CodecEncCfg cfg, ExtraCFG vp8cfg) {
        this.cfg = cfg;
        this.vp8_cfg = vp8cfg;
        this.vp8_cfg.setPkt_list(this.pkt_list);
        this.cx_data = new FullAccessIntArrPointer(Math.max(32768, cfg.getG_w() * cfg.getG_h() * 3 / 2 * 2));
        this.pts_offset_initialized = false;
        this.timestamp_ratio = RationalLarge.reduceLong(cfg.getG_timebase().getNum() * 10000000, cfg.getG_timebase().getDen());
        this.oxcf = new Config(cfg, this.vp8_cfg);
        this.cpi = new Compressor(this.oxcf);
        this.base.priv = this;
    }

    static CodecPkt vpx_codec_pkt_list_get(List<CodecPkt> list, Iterator<CodecPkt>[] iter) {
        CodecPkt pkt = null;
        if (iter[0] == null) {
            iter[0] = list.iterator();
        }
        if (iter[0].hasNext()) {
            pkt = iter[0].next();
        }
        return pkt;
    }

    public static CodecPkt vpx_codec_get_cx_data(CodecPriv ctx, Iterator<CodecPkt>[] iter) {
        CodecPkt pkt = null;
        if (ctx != null) {
            if (iter == null) {
                VP8Exception.ERROR(null);
            } else {
                pkt = CodecAlgPRiv.vpx_codec_pkt_list_get(ctx.priv.pkt_list, iter);
            }
        }
        if (pkt != null && pkt.kind == PacketKind.FRAME_PKT) {
            CodecPkt.FramePacket pktReal = (CodecPkt.FramePacket)pkt.packet;
            if (ctx.enc.cx_data_dst_buf != null) {
                FullAccessIntArrPointer dst_buf = ctx.enc.cx_data_dst_buf.shallowCopy();
                if (!pktReal.buf.equals(dst_buf) && pktReal.sz + ctx.enc.cx_data_pad_before + ctx.enc.cx_data_pad_after <= ctx.enc.cx_data_dst_buf.size()) {
                    CodecPkt modified_pkt = ctx.enc.cx_data_pkt;
                    dst_buf.memcopyin(ctx.enc.cx_data_pad_before, ((CodecPkt.FramePacket)modified_pkt.packet).buf, 0, ((CodecPkt.FramePacket)modified_pkt.packet).buf.size());
                    modified_pkt = pkt;
                    ((CodecPkt.FramePacket)modified_pkt.packet).buf = dst_buf;
                    pkt = modified_pkt;
                }
                if (dst_buf == pktReal.buf) {
                    ctx.enc.cx_data_dst_buf = dst_buf.shallowCopyWithPosInc(pktReal.buf.size());
                }
            }
        }
        return pkt;
    }
}

