/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.VP8Exception;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;

public class CodecEncCfg {
    public static final int VPX_MAX_LAYERS = 12;
    public static final int VPX_TS_MAX_PERIODICITY = 16;
    public static final int VPX_TS_MAX_LAYERS = 5;
    public static final int VPX_SS_MAX_LAYERS = 5;
    private int g_usage = 0;
    private int g_profile = 0;
    private int g_w;
    private int g_h;
    private vpx_bit_depth g_bit_depth = vpx_bit_depth.VPX_BITS_8;
    private int g_input_bit_depth = 8;
    private Rational g_timebase = Rational.R(1, 25);
    private boolean g_error_resilient = false;
    private int g_lag_in_frames = 0;
    private int rc_dropframe_thresh = 0;
    private boolean rc_resize_allowed = false;
    private int rc_scaled_width = 1;
    private int rc_scaled_height = 1;
    private int rc_resize_up_thresh = 60;
    private int rc_resize_down_thresh = 30;
    private vpx_rc_mode rc_end_usage = vpx_rc_mode.VPX_VBR;
    private int rc_target_bitrate = 256;
    private short rc_min_quantizer = (short)4;
    private short rc_max_quantizer = (short)63;
    private int rc_undershoot_pct = 100;
    private int rc_overshoot_pct = 100;
    private int rc_buf_sz = 6000;
    private int rc_buf_initial_sz = 4000;
    private int rc_buf_optimal_sz = 5000;
    private vpx_kf_mode kf_mode = vpx_kf_mode.VPX_KF_AUTO;
    private int kf_min_dist = 0;
    private int kf_max_dist = 128;
    private int ss_number_layer = 1;
    private int[] ss_enable_auto_alt_ref = new int[]{0};
    private int[] ss_target_bitrate = new int[]{0};
    private int ts_number_layers = 1;
    private int[] ts_target_bitrate = new int[]{0};
    private int[] ts_rate_decimator = new int[]{0};
    private int ts_periodicity = 0;
    private int[] ts_layer_id = new int[]{0};
    private int[] layer_target_bitrate = new int[]{0};
    private int temporal_layering_mode = 0;
    private boolean use_vizier_rc_params = false;
    private Rational active_wq_factor = Rational.ONE;
    private Rational err_per_mb_factor = Rational.ONE;
    private Rational sr_default_decay_limit = Rational.ONE;
    private Rational sr_diff_factor = Rational.ONE;
    private Rational kf_err_per_mb_factor = Rational.ONE;
    private Rational kf_frame_min_boost_factor = Rational.ONE;
    private Rational kf_frame_max_boost_first_factor = Rational.ONE;
    private Rational kf_frame_max_boost_subs_factor = Rational.ONE;
    private Rational kf_max_total_boost_factor = Rational.ONE;
    private Rational gf_max_total_boost_factor = Rational.ONE;
    private Rational gf_frame_max_boost_factor = Rational.ONE;
    private Rational zm_factor = Rational.ONE;
    private Rational rd_mult_inter_qp_fac = Rational.ONE;
    private Rational rd_mult_arf_qp_fac = Rational.ONE;
    private Rational rd_mult_key_qp_fac = Rational.ONE;
    public static final int VPX_SS_DEFAULT_LAYERS = 1;

    static void rangeCheck(int v, int min, int max) {
        if (v < min || v > max) {
            VP8Exception.ERROR(Thread.currentThread().getStackTrace()[1].getMethodName() + " is out of range");
        }
    }

    public int getG_usage() {
        return this.g_usage;
    }

    public void setG_usage(int g_usage) {
        this.g_usage = g_usage;
    }

    public int getG_profile() {
        return this.g_profile;
    }

    public void setG_profile(int g_profile) {
        CodecEncCfg.rangeCheck(g_profile, 0, 3);
        this.g_profile = g_profile;
    }

    public int getG_w() {
        return this.g_w;
    }

    public void setG_w(int g_w) {
        CodecEncCfg.rangeCheck(g_w, 1, 16383);
        this.g_w = g_w;
    }

    public int getG_h() {
        return this.g_h;
    }

    public void setG_h(int g_h) {
        CodecEncCfg.rangeCheck(g_h, 1, 16383);
        this.g_h = g_h;
    }

    public vpx_bit_depth getG_bit_depth() {
        return this.g_bit_depth;
    }

    public void setG_bit_depth(vpx_bit_depth g_bit_depth) {
        this.g_bit_depth = g_bit_depth;
    }

    public int getG_input_bit_depth() {
        return this.g_input_bit_depth;
    }

    public void setG_input_bit_depth(int g_input_bit_depth) {
        this.g_input_bit_depth = g_input_bit_depth;
    }

    public Rational getG_timebase() {
        return this.g_timebase;
    }

    public void setG_timebase(Rational g_timebase) {
        CodecEncCfg.rangeCheck(g_timebase.getDen(), 1, 1000000000);
        CodecEncCfg.rangeCheck(g_timebase.getNum(), 1, 1000000000);
        this.g_timebase = g_timebase;
    }

    public boolean isG_error_resilient() {
        return this.g_error_resilient;
    }

    public void setG_error_resilient(boolean g_error_resilient) {
        this.g_error_resilient = g_error_resilient;
    }

    public int getG_lag_in_frames() {
        return this.g_lag_in_frames;
    }

    public void setG_lag_in_frames(int g_lag_in_frames) {
        CodecEncCfg.rangeCheck(g_lag_in_frames, 0, 25);
        this.g_lag_in_frames = g_lag_in_frames;
    }

    public int getRc_dropframe_thresh() {
        return this.rc_dropframe_thresh;
    }

    public void setRc_dropframe_thresh(int rc_dropframe_thresh) {
        CodecEncCfg.rangeCheck(rc_dropframe_thresh, 0, 100);
        this.rc_dropframe_thresh = rc_dropframe_thresh;
    }

    public boolean isRc_resize_allowed() {
        return this.rc_resize_allowed;
    }

    public void setRc_resize_allowed(boolean rc_resize_allowed) {
        this.rc_resize_allowed = rc_resize_allowed;
    }

    public int getRc_scaled_width() {
        return this.rc_scaled_width;
    }

    public void setRc_scaled_width(int rc_scaled_width) {
        this.rc_scaled_width = rc_scaled_width;
    }

    public int getRc_scaled_height() {
        return this.rc_scaled_height;
    }

    public void setRc_scaled_height(int rc_scaled_height) {
        this.rc_scaled_height = rc_scaled_height;
    }

    public int getRc_resize_up_thresh() {
        return this.rc_resize_up_thresh;
    }

    public void setRc_resize_up_thresh(int rc_resize_up_thresh) {
        CodecEncCfg.rangeCheck(rc_resize_up_thresh, 0, 100);
        this.rc_resize_up_thresh = rc_resize_up_thresh;
    }

    public int getRc_resize_down_thresh() {
        return this.rc_resize_down_thresh;
    }

    public void setRc_resize_down_thresh(int rc_resize_down_thresh) {
        CodecEncCfg.rangeCheck(rc_resize_down_thresh, 0, 100);
        this.rc_resize_down_thresh = rc_resize_down_thresh;
    }

    public vpx_rc_mode getRc_end_usage() {
        return this.rc_end_usage;
    }

    public void setRc_end_usage(vpx_rc_mode rc_end_usage) {
        this.rc_end_usage = rc_end_usage;
    }

    public int getRc_target_bitrate() {
        return this.rc_target_bitrate;
    }

    public void setRc_target_bitrate(int rc_target_bitrate) {
        this.rc_target_bitrate = rc_target_bitrate;
    }

    public short getRc_min_quantizer() {
        return this.rc_min_quantizer;
    }

    public void setRc_min_quantizer(short rc_min_quantizer) {
        CodecEncCfg.rangeCheck(rc_min_quantizer, 0, this.rc_max_quantizer);
        this.rc_min_quantizer = rc_min_quantizer;
    }

    public short getRc_max_quantizer() {
        return this.rc_max_quantizer;
    }

    public void setRc_max_quantizer(short rc_max_quantizer) {
        CodecEncCfg.rangeCheck(rc_max_quantizer, 0, 63);
        this.rc_max_quantizer = rc_max_quantizer;
    }

    public int getRc_undershoot_pct() {
        return this.rc_undershoot_pct;
    }

    public void setRc_undershoot_pct(int rc_undershoot_pct) {
        CodecEncCfg.rangeCheck(rc_undershoot_pct, 0, 100);
        this.rc_undershoot_pct = rc_undershoot_pct;
    }

    public int getRc_overshoot_pct() {
        return this.rc_overshoot_pct;
    }

    public void setRc_overshoot_pct(int rc_overshoot_pct) {
        CodecEncCfg.rangeCheck(this.rc_undershoot_pct, 0, 100);
        this.rc_overshoot_pct = rc_overshoot_pct;
    }

    public int getRc_buf_sz() {
        return this.rc_buf_sz;
    }

    public void setRc_buf_sz(int rc_buf_sz) {
        this.rc_buf_sz = rc_buf_sz;
    }

    public int getRc_buf_initial_sz() {
        return this.rc_buf_initial_sz;
    }

    public void setRc_buf_initial_sz(int rc_buf_initial_sz) {
        this.rc_buf_initial_sz = rc_buf_initial_sz;
    }

    public int getRc_buf_optimal_sz() {
        return this.rc_buf_optimal_sz;
    }

    public void setRc_buf_optimal_sz(int rc_buf_optimal_sz) {
        this.rc_buf_optimal_sz = rc_buf_optimal_sz;
    }

    public vpx_kf_mode getKf_mode() {
        return this.kf_mode;
    }

    public void setKf_mode(vpx_kf_mode kf_mode) {
        this.kf_mode = kf_mode;
        this.setKf_min_dist(this.kf_min_dist);
    }

    public int getKf_min_dist() {
        return this.kf_min_dist;
    }

    public void setKf_min_dist(int kf_min_dist) {
        if (this.kf_mode == vpx_kf_mode.VPX_KF_AUTO && kf_min_dist != 0 && kf_min_dist != this.kf_max_dist) {
            VP8Exception.ERROR("kf_min_dist not supported in auto mode, use 0 or kf_max_dist instead.");
        }
        this.kf_min_dist = kf_min_dist;
    }

    public int getKf_max_dist() {
        return this.kf_max_dist;
    }

    public void setKf_max_dist(int kf_max_dist) {
        this.kf_max_dist = kf_max_dist;
        this.setKf_min_dist(this.kf_min_dist);
    }

    public int getSs_number_layer() {
        return this.ss_number_layer;
    }

    public void setSs_number_layer(int ss_number_layer) {
        this.ss_number_layer = ss_number_layer;
    }

    public int[] getSs_enable_auto_alt_ref() {
        return this.ss_enable_auto_alt_ref;
    }

    public void setSs_enable_auto_alt_ref(int[] ss_enable_auto_alt_ref) {
        this.ss_enable_auto_alt_ref = ss_enable_auto_alt_ref;
    }

    public int[] getSs_target_bitrate() {
        return this.ss_target_bitrate;
    }

    public void setSs_target_bitrate(int[] ss_target_bitrate) {
        this.ss_target_bitrate = ss_target_bitrate;
    }

    public int getTs_number_layers() {
        return this.ts_number_layers;
    }

    public void setTs_number_layers(int ts_number_layers) {
        CodecEncCfg.rangeCheck(ts_number_layers, 1, 5);
        this.ts_number_layers = ts_number_layers;
        this.setTs_periodicity(this.ts_periodicity);
        this.setTs_rate_decimator(this.ts_rate_decimator);
        this.setTs_target_bitrate(this.ts_target_bitrate);
        this.setTs_layer_id(this.ts_layer_id);
    }

    public int[] getTs_target_bitrate() {
        return this.ts_target_bitrate;
    }

    public void setTs_target_bitrate(int[] ts_target_bitrate) {
        for (int i = 1; i < this.ts_number_layers; ++i) {
            if (ts_target_bitrate[i] > ts_target_bitrate[i - 1] || this.rc_target_bitrate <= 0) continue;
            VP8Exception.ERROR("ts_target_bitrate entries are not strictly increasing");
        }
        this.ts_target_bitrate = ts_target_bitrate;
    }

    public int[] getTs_rate_decimator() {
        return this.ts_rate_decimator;
    }

    public void setTs_rate_decimator(int[] ts_rate_decimator) {
        CodecEncCfg.rangeCheck(ts_rate_decimator[this.ts_number_layers - 1], 1, 1);
        for (int i = this.ts_number_layers - 2; i > 0; --i) {
            if (ts_rate_decimator[i - 1] == 2 * ts_rate_decimator[i]) continue;
            VP8Exception.ERROR("ts_rate_decimator factors are not powers of 2");
        }
        this.ts_rate_decimator = ts_rate_decimator;
    }

    public int getTs_periodicity() {
        return this.ts_periodicity;
    }

    public void setTs_periodicity(int ts_periodicity) {
        if (this.ts_number_layers > 1) {
            CodecEncCfg.rangeCheck(ts_periodicity, 0, 16);
        }
        this.ts_periodicity = ts_periodicity;
    }

    public int[] getTs_layer_id() {
        return this.ts_layer_id;
    }

    public void setTs_layer_id(int[] ts_layer_id) {
        CodecEncCfg.rangeCheck(ts_layer_id[0], 0, this.ts_number_layers - 1);
        this.ts_layer_id = ts_layer_id;
    }

    public int[] getLayer_target_bitrate() {
        return this.layer_target_bitrate;
    }

    public void setLayer_target_bitrate(int[] layer_target_bitrate) {
        this.layer_target_bitrate = layer_target_bitrate;
    }

    public int getTemporal_layering_mode() {
        return this.temporal_layering_mode;
    }

    public void setTemporal_layering_mode(int temporal_layering_mode) {
        this.temporal_layering_mode = temporal_layering_mode;
    }

    public boolean isUse_vizier_rc_params() {
        return this.use_vizier_rc_params;
    }

    public void setUse_vizier_rc_params(boolean use_vizier_rc_params) {
        this.use_vizier_rc_params = use_vizier_rc_params;
    }

    public Rational getActive_wq_factor() {
        return this.active_wq_factor;
    }

    public void setActive_wq_factor(Rational active_wq_factor) {
        CodecEncCfg.rangeCheck(active_wq_factor.getDen(), 1, 1000);
        this.active_wq_factor = active_wq_factor;
    }

    public Rational getErr_per_mb_factor() {
        return this.err_per_mb_factor;
    }

    public void setErr_per_mb_factor(Rational err_per_mb_factor) {
        CodecEncCfg.rangeCheck(err_per_mb_factor.getDen(), 1, 1000);
        this.err_per_mb_factor = err_per_mb_factor;
    }

    public Rational getSr_default_decay_limit() {
        return this.sr_default_decay_limit;
    }

    public void setSr_default_decay_limit(Rational sr_default_decay_limit) {
        CodecEncCfg.rangeCheck(sr_default_decay_limit.getDen(), 1, 1000);
        this.sr_default_decay_limit = sr_default_decay_limit;
    }

    public Rational getSr_diff_factor() {
        return this.sr_diff_factor;
    }

    public void setSr_diff_factor(Rational sr_diff_factor) {
        CodecEncCfg.rangeCheck(sr_diff_factor.getDen(), 1, 1000);
        this.sr_diff_factor = sr_diff_factor;
    }

    public Rational getKf_err_per_mb_factor() {
        return this.kf_err_per_mb_factor;
    }

    public void setKf_err_per_mb_factor(Rational kf_err_per_mb_factor) {
        CodecEncCfg.rangeCheck(kf_err_per_mb_factor.getDen(), 1, 1000);
        this.kf_err_per_mb_factor = kf_err_per_mb_factor;
    }

    public Rational getKf_frame_min_boost_factor() {
        return this.kf_frame_min_boost_factor;
    }

    public void setKf_frame_min_boost_factor(Rational kf_frame_min_boost_factor) {
        CodecEncCfg.rangeCheck(kf_frame_min_boost_factor.getDen(), 1, 1000);
        this.kf_frame_min_boost_factor = kf_frame_min_boost_factor;
    }

    public Rational getKf_frame_max_boost_first_factor() {
        return this.kf_frame_max_boost_first_factor;
    }

    public void setKf_frame_max_boost_first_factor(Rational kf_frame_max_boost_first_factor) {
        CodecEncCfg.rangeCheck(kf_frame_max_boost_first_factor.getDen(), 1, 1000);
        this.kf_frame_max_boost_first_factor = kf_frame_max_boost_first_factor;
    }

    public Rational getKf_frame_max_boost_subs_factor() {
        return this.kf_frame_max_boost_subs_factor;
    }

    public void setKf_frame_max_boost_subs_factor(Rational kf_frame_max_boost_subs_factor) {
        CodecEncCfg.rangeCheck(kf_frame_max_boost_subs_factor.getDen(), 1, 1000);
        this.kf_frame_max_boost_subs_factor = kf_frame_max_boost_subs_factor;
    }

    public Rational getKf_max_total_boost_factor() {
        return this.kf_max_total_boost_factor;
    }

    public void setKf_max_total_boost_factor(Rational kf_max_total_boost_factor) {
        CodecEncCfg.rangeCheck(kf_max_total_boost_factor.getDen(), 1, 1000);
        this.kf_max_total_boost_factor = kf_max_total_boost_factor;
    }

    public Rational getGf_max_total_boost_factor() {
        return this.gf_max_total_boost_factor;
    }

    public void setGf_max_total_boost_factor(Rational gf_max_total_boost_factor) {
        CodecEncCfg.rangeCheck(gf_max_total_boost_factor.getDen(), 1, 1000);
        this.gf_max_total_boost_factor = gf_max_total_boost_factor;
    }

    public Rational getGf_frame_max_boost_factor() {
        return this.gf_frame_max_boost_factor;
    }

    public void setGf_frame_max_boost_factor(Rational gf_frame_max_boost_factor) {
        CodecEncCfg.rangeCheck(gf_frame_max_boost_factor.getDen(), 1, 1000);
        this.gf_frame_max_boost_factor = gf_frame_max_boost_factor;
    }

    public Rational getZm_factor() {
        return this.zm_factor;
    }

    public void setZm_factor(Rational zm_factor) {
        CodecEncCfg.rangeCheck(zm_factor.getDen(), 1, 1000);
        this.zm_factor = zm_factor;
    }

    public Rational getRd_mult_inter_qp_fac() {
        return this.rd_mult_inter_qp_fac;
    }

    public void setRd_mult_inter_qp_fac(Rational rd_mult_inter_qp_fac) {
        CodecEncCfg.rangeCheck(rd_mult_inter_qp_fac.getDen(), 1, 1000);
        this.rd_mult_inter_qp_fac = rd_mult_inter_qp_fac;
    }

    public Rational getRd_mult_arf_qp_fac() {
        return this.rd_mult_arf_qp_fac;
    }

    public void setRd_mult_arf_qp_fac(Rational rd_mult_arf_qp_fac) {
        CodecEncCfg.rangeCheck(rd_mult_arf_qp_fac.getDen(), 1, 1000);
        this.rd_mult_arf_qp_fac = rd_mult_arf_qp_fac;
    }

    public Rational getRd_mult_key_qp_fac() {
        return this.rd_mult_key_qp_fac;
    }

    public void setRd_mult_key_qp_fac(Rational rd_mult_key_qp_fac) {
        CodecEncCfg.rangeCheck(rd_mult_key_qp_fac.getDen(), 1, 1000);
        this.rd_mult_key_qp_fac = rd_mult_key_qp_fac;
    }

    public static enum vpx_kf_mode {
        VPX_KF_DISABLED,
        VPX_KF_AUTO;

    }

    public static enum vpx_rc_mode {
        VPX_VBR,
        VPX_CBR,
        VPX_CQ,
        VPX_Q;

    }

    public static enum vpx_bit_depth {
        VPX_BITS_8(8),
        VPX_BITS_10(10),
        VPX_BITS_12(12);

        final int bits;

        private vpx_bit_depth(int bitcount) {
            this.bits = bitcount;
        }
    }
}

