/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.EnumMap;
import java.util.EnumSet;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyContextPlanes;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.FrameContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.LoopFilterInfoN;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.PostprocState;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameTypeFlags;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.LoopFilterType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.Scaling;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenPartition;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;

public class CommonData {
    public static final int MAXQ = 127;
    public static final int QINDEX_RANGE = 128;
    public static final int NUM_YV12_BUFFERS = 4;
    public EnumMap<Quant, FullAccessIntArrPointer[]> dequant = new EnumMap(Quant.class);
    public int Width;
    public int Height;
    public Scaling horiz_scale = Scaling.NORMAL;
    public Scaling vert_scale = Scaling.NORMAL;
    public YV12buffer frame_to_show;
    public YV12buffer[] yv12_fb = new YV12buffer[4];
    int[] fb_idx_ref_cnt = new int[4];
    public EnumMap<MVReferenceFrame, Integer> frameIdxs = new EnumMap(MVReferenceFrame.class);
    public int new_fb_idx;
    YV12buffer temp_scale_frame;
    YV12buffer post_proc_buffer;
    YV12buffer post_proc_buffer_int;
    int post_proc_buffer_int_used;
    int[] pp_limits_buffer;
    public FrameType last_frame_type;
    public FrameType frame_type;
    public boolean show_frame;
    public EnumSet<FrameTypeFlags> frame_flags;
    public int MBs;
    public int mb_rows;
    public int mb_cols;
    public int mode_info_stride;
    public boolean mb_no_coeff_skip = true;
    public boolean no_lpf = false;
    public boolean use_bilinear_mc_filter = false;
    public boolean full_pixel = false;
    public short base_qindex;
    public EnumMap<Quant, EnumMap<Comp, Short>> delta_q = new EnumMap(Quant.class);
    public FullAccessGenArrPointer<ModeInfo> mip;
    public FullAccessGenArrPointer<ModeInfo> mi;
    ModeInfo show_frame_mi;
    public LoopFilterType filter_type;
    public LoopFilterInfoN lf_info;
    public short filter_level;
    public int last_sharpness_level;
    public int sharpness_level;
    public boolean refresh_last_frame = true;
    public boolean refresh_golden_frame = false;
    public boolean refresh_alt_ref_frame;
    public int copy_buffer_to_gf = 0;
    public int copy_buffer_to_arf = 0;
    public boolean refresh_entropy_probs = true;
    public EnumMap<MVReferenceFrame, Boolean> ref_frame_sign_bias = new EnumMap(MVReferenceFrame.class);
    public FullAccessGenArrPointer<EntropyContextPlanes> above_context;
    public EntropyContextPlanes left_context = new EntropyContextPlanes();
    public FrameContext lfc;
    public FrameContext fc = new FrameContext();
    public int current_video_frame;
    private byte version;
    public TokenPartition multi_token_partition;
    PostprocState postproc_state;
    int cpu_caps = 0;

    public CommonData() {
        this.filter_type = LoopFilterType.NORMAL;
        this.multi_token_partition = TokenPartition.ONE_PARTITION;
        this.lf_info = new LoopFilterInfoN(this);
        for (MVReferenceFrame rf : MVReferenceFrame.validFrames) {
            this.ref_frame_sign_bias.put(rf, false);
            this.frameIdxs.put(rf, 0);
        }
        for (Quant q : Quant.values()) {
            FullAccessIntArrPointer[] temp = new FullAccessIntArrPointer[128];
            for (int i = 0; i < temp.length; ++i) {
                temp[i] = new FullAccessIntArrPointer(2);
            }
            this.dequant.put(q, temp);
            EnumMap<Comp, Short> tempMap = new EnumMap<Comp, Short>(Comp.class);
            for (Comp c : Comp.values()) {
                tempMap.put(c, (short)0);
            }
            this.delta_q.put(q, tempMap);
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public void setVersion(byte version) {
        this.version = version;
        this.vp8_setup_version();
    }

    void vp8_setup_version() {
        switch (this.version) {
            case 0: {
                this.no_lpf = false;
                this.filter_type = LoopFilterType.NORMAL;
                this.use_bilinear_mc_filter = false;
                this.full_pixel = false;
                break;
            }
            case 1: {
                this.no_lpf = false;
                this.filter_type = LoopFilterType.SIMPLE;
                this.use_bilinear_mc_filter = true;
                this.full_pixel = false;
                break;
            }
            case 2: {
                this.no_lpf = true;
                this.filter_type = LoopFilterType.NORMAL;
                this.use_bilinear_mc_filter = true;
                this.full_pixel = false;
                break;
            }
            case 3: {
                this.no_lpf = true;
                this.filter_type = LoopFilterType.SIMPLE;
                this.use_bilinear_mc_filter = true;
                this.full_pixel = true;
                break;
            }
            default: {
                this.no_lpf = false;
                this.filter_type = LoopFilterType.NORMAL;
                this.use_bilinear_mc_filter = false;
                this.full_pixel = false;
            }
        }
    }

    public void vp8_alloc_frame_buffers(int width, int height) {
        int i;
        this.vp8_de_alloc_frame_buffers();
        if ((width & 0xF) != 0) {
            width += 16 - (width & 0xF);
        }
        if ((height & 0xF) != 0) {
            height += 16 - (height & 0xF);
        }
        for (i = 0; i < 4; ++i) {
            this.fb_idx_ref_cnt[i] = 0;
            this.yv12_fb[i] = new YV12buffer(width, height);
            this.yv12_fb[i].flags = EnumSet.noneOf(MVReferenceFrame.class);
        }
        this.new_fb_idx = 0;
        this.frameIdxs.clear();
        this.frameIdxs.put(MVReferenceFrame.LAST_FRAME, 1);
        this.frameIdxs.put(MVReferenceFrame.GOLDEN_FRAME, 2);
        this.frameIdxs.put(MVReferenceFrame.ALTREF_FRAME, 3);
        this.fb_idx_ref_cnt[0] = 1;
        this.fb_idx_ref_cnt[1] = 1;
        this.fb_idx_ref_cnt[2] = 1;
        this.fb_idx_ref_cnt[3] = 1;
        this.temp_scale_frame = new YV12buffer(width, 16);
        this.mb_rows = height >> 4;
        this.mb_cols = width >> 4;
        this.MBs = this.mb_rows * this.mb_cols;
        this.mode_info_stride = this.mb_cols + 1;
        this.mip = new FullAccessGenArrPointer((this.mb_cols + 1) * (this.mb_rows + 1));
        for (i = 0; i < this.mip.size(); ++i) {
            this.mip.setRel(i, new ModeInfo());
        }
        this.mi = this.mip.shallowCopyWithPosInc(this.mode_info_stride + 1);
        this.above_context = new FullAccessGenArrPointer(this.mb_cols);
        for (i = 0; i < this.mb_cols; ++i) {
            this.above_context.setRel(i, new EntropyContextPlanes());
        }
    }

    public void vp8_de_alloc_frame_buffers() {
        this.temp_scale_frame = null;
        this.above_context = null;
        this.mip = null;
    }

    public static enum Comp {
        DC(0),
        AC(1);

        public final int baseIndex;

        private Comp(int base) {
            this.baseIndex = base;
        }
    }

    public static enum Quant {
        Y1,
        Y2,
        UV;

    }
}

