/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.BitStream;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.BoolEncoder;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.MComp;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.OnyxIf;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.Quantize;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Block;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodecPkt;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CodingContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CommonData;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Config;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.DefaultVarianceFNs;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.FrameContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.LayerContext;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Lookahead;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.LookaheadEntry;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.MV;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Macroblock;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.QuantDetails;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.RDCosts;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ReferenceCounts;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.SpeedFeatures;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.TokenExtra;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.TokenList;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarWithNum;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceFNs;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.VarianceResults;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.BlockEnum;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.CompressMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.EndUsage;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBLvlFeatures;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.Scaling;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.TokenPartition;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.ReadOnlyIntArrPointer;

public class Compressor {
    public static final int MAX_PARTITIONS = 9;
    public EnumMap<CommonData.Quant, QuantDetails> q = new EnumMap(CommonData.Quant.class);
    public Macroblock mb;
    public CommonData common = new CommonData();
    public BoolEncoder[] bc = new BoolEncoder[9];
    public Config oxcf;
    public Lookahead lookahead;
    public LookaheadEntry sourceLAE;
    public LookaheadEntry alt_ref_source;
    LookaheadEntry last_source;
    public YV12buffer sourceYV12;
    public YV12buffer un_scaled_source;
    public YV12buffer scaled_source;
    YV12buffer last_frame_unscaled_source;
    public int frames_till_alt_ref_frame;
    public boolean source_alt_ref_pending;
    public boolean source_alt_ref_active;
    public boolean is_src_frame_alt_ref;
    public boolean gold_is_last;
    public boolean alt_is_last;
    public boolean gold_is_alt;
    public YV12buffer pick_lf_lvl_frame;
    public FullAccessGenArrPointer<TokenExtra> tok;
    public int tok_count;
    public int frames_since_key;
    public int key_frame_frequency;
    public boolean this_key_frame_forced;
    int next_key_frame_forced;
    public int ambient_err;
    public int[] mode_check_freq = new int[20];
    public int[] rd_baseline_thresh = new int[20];
    public int RDMULT;
    public int RDDIV;
    public CodingContext coding_context = new CodingContext();
    public long last_prediction_error;
    public long last_intra_error;
    public int this_frame_target;
    public int projected_frame_size;
    public short[] last_q = new short[2];
    public double rate_correction_factor;
    public double key_frame_rate_correction_factor;
    public double gf_rate_correction_factor;
    public int frames_since_golden;
    public int frames_till_gf_update_due;
    public int current_gf_interval;
    public int gf_overspend_bits;
    public int non_gf_bitrate_adjustment;
    public int kf_overspend_bits;
    public int kf_bitrate_adjustment;
    public int max_gf_interval;
    public int baseline_gf_interval;
    public int active_arnr_frames;
    public long key_frame_count;
    public int[] prior_key_frame_distance = new int[5];
    public int per_frame_bandwidth;
    public int av_per_frame_bandwidth;
    public int min_frame_bandwidth;
    public int inter_frame_target;
    public double output_framerate;
    public long last_time_stamp_seen;
    public long last_end_time_stamp_seen;
    public long first_time_stamp_ever;
    public short ni_av_qi;
    public int ni_tot_qi;
    public int ni_frames;
    public short avg_frame_qindex;
    public long total_byte_count;
    public boolean buffered_mode;
    public double framerate;
    public double ref_framerate;
    public long buffer_level;
    public long bits_off_target;
    public int rolling_target_bits;
    public int rolling_actual_bits;
    public int long_rolling_target_bits;
    public int long_rolling_actual_bits;
    public long total_actual_bits;
    int total_target_vs_actual;
    public short worst_quality;
    public short active_worst_quality;
    public short best_quality;
    public short active_best_quality;
    public short cq_target_quality;
    public boolean drop_frames_allowed;
    public boolean drop_frame;
    public short[][][][] frame_coef_probs = new short[4][8][3][11];
    short[][][][] update_probs = new short[4][8][3][11];
    public int[][][][][] frame_branch_ct = new int[4][8][3][11][2];
    int gfu_boost;
    public int kf_boost;
    public int last_boost;
    public int target_bandwidth;
    public List<CodecPkt> output_pkt_list;
    public int decimation_factor;
    public int decimation_count;
    public int avg_encode_time;
    public int avg_pick_mode_time;
    public int Speed;
    public int compressor_speed;
    public boolean auto_gold;
    public boolean auto_adjust_gold_quantizer;
    public boolean auto_worst_q;
    int cpu_used;
    public int prob_intra_coded;
    public int prob_last_coded;
    public int prob_gf_coded;
    public int prob_skip_false;
    public int[] last_skip_false_probs = new int[3];
    public int[] last_skip_probs_q = new int[3];
    public EnumMap<MVReferenceFrame, Integer> recent_ref_frame_usage = new EnumMap(MVReferenceFrame.class);
    public int this_frame_percent_intra;
    public int last_frame_percent_intra;
    public EnumSet<MVReferenceFrame> ref_frame_flags;
    public SpeedFeatures sf = new SpeedFeatures();
    public int zeromv_count;
    public int lf_zeromv_pct;
    public boolean[] skin_map;
    public int[] segmentation_map;
    public short[][] segment_feature_data = new short[MBLvlFeatures.featureCount][4];
    public int[] segment_encode_breakout = new int[4];
    public FullAccessIntArrPointer active_map;
    public boolean active_map_enabled;
    public boolean cyclic_refresh_mode_enabled;
    public int cyclic_refresh_mode_max_mbs_perframe;
    public int cyclic_refresh_mode_index;
    public int cyclic_refresh_q;
    public byte[] cyclic_refresh_map;
    public int[] consec_zero_last;
    public int[] consec_zero_last_mvbias;
    public int temporal_pattern_counter;
    public int temporal_layer_id;
    int mse_source_denoised;
    public int force_maxqp;
    public int frames_since_last_drop_overshoot;
    public int last_pred_err_mb;
    public boolean gf_update_onepass_cbr;
    public int gf_interval_onepass_cbr;
    public boolean gf_noboost_onepass_cbr;
    public TokenList[] tplist;
    public int[] partition_sz = new int[9];
    int[] partition_d = new int[9];
    int[] partition_d_end = new int[9];
    public FractionalMVStepIF find_fractional_mv_step;
    public FullSearchIF full_search_sad;
    public RefiningSearchIF refining_search_sad;
    public DiamondSearchIF diamond_search_sad;
    public EnumMap<BlockEnum, VarianceFNs> fn_ptr = new EnumMap(BlockEnum.class);
    public long time_receive_data;
    public long time_compress_data;
    public long time_pick_lpf;
    public long time_encode_mb_row;
    public int[] base_skip_false_prob;
    public FrameContext lfc_n;
    public FrameContext lfc_a;
    public FrameContext lfc_g;
    public YV12buffer alt_ref_buffer;
    public YV12buffer[] frames = new YV12buffer[25];
    public int[] fixed_divide = new int[512];
    public boolean b_calculate_psnr;
    public int activity_avg;
    public FullAccessIntArrPointer mb_activity_map;
    public FullAccessIntArrPointer gf_active_flags;
    public int gf_active_count;
    public boolean output_partition;
    public MV[] lfmv;
    public boolean[] lf_ref_frame_sign_bias;
    public MVReferenceFrame[] lf_ref_frame;
    public boolean force_next_frame_intra;
    public boolean droppable;
    int initial_width;
    int initial_height;
    public int current_layer;
    public LayerContext[] layer_context = new LayerContext[5];
    long[] frames_in_layer = new long[5];
    long[] bytes_in_layer = new long[5];
    double[] sum_psnr = new double[5];
    double[] sum_psnr_p = new double[5];
    double[] total_error2 = new double[5];
    double[] total_error2_p = new double[5];
    double[] sum_ssim = new double[5];
    double[] sum_weights = new double[5];
    double[] total_ssimg_y_in_layer = new double[5];
    double[] total_ssimg_u_in_layer = new double[5];
    double[] total_ssimg_v_in_layer = new double[5];
    double[] total_ssimg_all_in_layer = new double[5];
    public EnumMap<MVReferenceFrame, Integer> current_ref_frames = new EnumMap(MVReferenceFrame.class);
    public MVReferenceFrame closest_reference_frame;
    public RDCosts rd_costs = new RDCosts();
    boolean use_roi_static_threshold;
    public boolean ext_refresh_frame_flags_pending;
    public boolean repeatFrameDetected = false;
    public DefaultVarianceFNs varFns = new DefaultVarianceFNs();

    Compressor(Config oxcfNew) {
        for (CommonData.Quant quant : CommonData.Quant.values()) {
            this.q.put(quant, new QuantDetails());
        }
        this.framerate = oxcfNew.timebase.num > 0 ? oxcfNew.timebase.flip().toDouble() : 30.0;
        if (this.framerate > 180.0) {
            this.framerate = 30.0;
        }
        this.vp8_change_config(oxcfNew);
        this.auto_gold = true;
        this.auto_adjust_gold_quantizer = true;
        this.ref_framerate = this.framerate;
        this.ref_frame_flags = EnumSet.copyOf(MVReferenceFrame.interFrames);
        this.active_worst_quality = this.oxcf.worst_allowed_q;
        this.active_best_quality = this.oxcf.best_allowed_q;
        this.avg_frame_qindex = this.oxcf.worst_allowed_q;
        this.buffer_level = this.oxcf.starting_buffer_level;
        this.bits_off_target = this.oxcf.starting_buffer_level;
        this.rolling_target_bits = this.av_per_frame_bandwidth;
        this.rolling_actual_bits = this.av_per_frame_bandwidth;
        this.long_rolling_target_bits = this.av_per_frame_bandwidth;
        this.long_rolling_actual_bits = this.av_per_frame_bandwidth;
        this.total_actual_bits = 0L;
        this.total_target_vs_actual = 0;
        if (this.oxcf.number_of_layers > 1) {
            double prev_layer_framerate = 0.0;
            for (int i = 0; i < this.oxcf.number_of_layers; ++i) {
                this.init_temporal_layer_context(i, prev_layer_framerate);
                prev_layer_framerate = this.output_framerate / (double)this.oxcf.rate_decimator[i];
            }
        }
        this.fixed_divide[0] = 0;
        for (int i = 1; i < 512; ++i) {
            this.fixed_divide[i] = 524288 / i;
        }
        this.base_skip_false_prob = Arrays.copyOf(BitStream.vp8cx_base_skip_false_prob, BitStream.vp8cx_base_skip_false_prob.length);
        this.common.current_video_frame = 0;
        this.temporal_pattern_counter = 0;
        this.temporal_layer_id = -1;
        this.kf_overspend_bits = 0;
        this.kf_bitrate_adjustment = 0;
        this.frames_till_gf_update_due = 0;
        this.gf_overspend_bits = 0;
        this.non_gf_bitrate_adjustment = 0;
        this.prob_last_coded = 128;
        this.prob_gf_coded = 128;
        this.prob_intra_coded = 63;
        for (MVReferenceFrame mvrf : MVReferenceFrame.validFrames) {
            this.recent_ref_frame_usage.put(mvrf, 1);
        }
        this.common.ref_frame_sign_bias.put(MVReferenceFrame.ALTREF_FRAME, true);
        this.baseline_gf_interval = 7;
        this.gold_is_last = false;
        this.alt_is_last = false;
        this.gold_is_alt = false;
        this.active_map_enabled = false;
        this.use_roi_static_threshold = false;
        this.mse_source_denoised = 0;
        this.cyclic_refresh_mode_enabled = this.oxcf.error_resilient_mode || this.oxcf.end_usage == EndUsage.STREAM_FROM_SERVER;
        this.cyclic_refresh_mode_max_mbs_perframe = this.common.mb_rows * this.common.mb_cols / 7;
        if (this.oxcf.number_of_layers == 1) {
            this.cyclic_refresh_mode_max_mbs_perframe = this.common.mb_rows * this.common.mb_cols / 20;
        } else if (this.oxcf.number_of_layers == 2) {
            this.cyclic_refresh_mode_max_mbs_perframe = this.common.mb_rows * this.common.mb_cols / 10;
        }
        this.cyclic_refresh_mode_index = 0;
        this.cyclic_refresh_q = 32;
        this.gf_update_onepass_cbr = false;
        this.gf_noboost_onepass_cbr = false;
        if (!this.oxcf.error_resilient_mode && this.oxcf.end_usage == EndUsage.STREAM_FROM_SERVER) {
            this.gf_update_onepass_cbr = true;
            this.gf_noboost_onepass_cbr = true;
            this.gf_interval_onepass_cbr = this.cyclic_refresh_mode_max_mbs_perframe > 0 ? 2 * (this.common.mb_rows * this.common.mb_cols) / this.cyclic_refresh_mode_max_mbs_perframe : 10;
            this.baseline_gf_interval = this.gf_interval_onepass_cbr = Math.min(40, Math.max(6, this.gf_interval_onepass_cbr));
        }
        this.cyclic_refresh_map = (byte[])(this.cyclic_refresh_mode_enabled ? new byte[this.common.mb_rows * this.common.mb_cols] : null);
        this.skin_map = new boolean[this.common.mb_rows * this.common.mb_cols];
        this.consec_zero_last = new int[this.common.mb_rows * this.common.mb_cols];
        this.consec_zero_last_mvbias = new int[this.common.mb_rows * this.common.mb_cols];
        this.activity_avg = 368640;
        this.frames_since_key = 8;
        this.key_frame_frequency = this.oxcf.key_freq;
        this.this_key_frame_forced = false;
        this.next_key_frame_forced = 0;
        this.source_alt_ref_pending = false;
        this.source_alt_ref_active = false;
        this.common.refresh_alt_ref_frame = false;
        this.force_maxqp = 0;
        this.frames_since_last_drop_overshoot = 0;
        this.b_calculate_psnr = false;
        this.first_time_stamp_ever = Integer.MAX_VALUE;
        this.frames_till_gf_update_due = 0;
        this.key_frame_count = 1L;
        this.ni_av_qi = this.oxcf.worst_allowed_q;
        this.ni_tot_qi = 0;
        this.ni_frames = 0;
        this.total_byte_count = 0L;
        this.drop_frame = false;
        this.rate_correction_factor = 1.0;
        this.key_frame_rate_correction_factor = 1.0;
        this.gf_rate_correction_factor = 1.0;
        for (int i = 0; i < this.prior_key_frame_distance.length; ++i) {
            this.prior_key_frame_distance[i] = (int)this.output_framerate;
        }
        this.output_pkt_list = this.oxcf.output_pkt_list;
        if (this.compressor_speed == 2) {
            this.avg_encode_time = 0;
            this.avg_pick_mode_time = 0;
        }
        for (BlockEnum be : BlockEnum.values()) {
            this.fn_ptr.put(be, this.varFns.default_fn_ptr.get((Object)be).copy());
        }
        this.full_search_sad = new FullSearchIF(){

            @Override
            public long call(Macroblock x, Block b, BlockD d, MV ref_mv, int sad_per_bit, int distance, VarianceFNs fn_ptr, ReadOnlyIntArrPointer[] mvcost, MV center_mv) {
                return MComp.vp8_full_search_sad(x, b, d, ref_mv, sad_per_bit, distance, fn_ptr, mvcost, center_mv);
            }
        };
        this.diamond_search_sad = new DiamondSearchIF(){

            @Override
            public void call(Macroblock x, Block b, BlockD d, MV ref_mv, MV best_mv, int search_param, int sad_per_bit, VarWithNum ret, VarianceFNs fn_ptr, ReadOnlyIntArrPointer[] mvcost, MV center_mv) {
                MComp.vp8_diamond_search_sad(x, b, d, ref_mv, best_mv, search_param, sad_per_bit, ret, fn_ptr, mvcost, center_mv);
            }
        };
        this.refining_search_sad = new RefiningSearchIF(){

            @Override
            public long call(Macroblock x, Block b, BlockD d, MV ref_mv, int sad_per_bit, int distance, VarianceFNs fn_ptr, ReadOnlyIntArrPointer[] mvcost, MV center_mv) {
                return MComp.vp8_refining_search_sad(x, b, d, ref_mv, sad_per_bit, distance, fn_ptr, mvcost, center_mv);
            }
        };
        for (int i = 0; i < this.bc.length; ++i) {
            this.bc[i] = new BoolEncoder();
        }
        Quantize.vp8cx_init_quantizer(this);
        this.mb = new Macroblock(this);
        OnyxIf.vp8_set_speed_features(this);
        this.common.setVersion((byte)this.oxcf.Version);
    }

    public void vp8_convert_rfct_to_prob() {
        ReferenceCounts rf = this.mb.sumReferenceCounts();
        EnumMap<MVReferenceFrame, Integer> rfct = this.mb.count_mb_ref_frame_usage;
        this.prob_intra_coded = rf.intra * 255 / rf.total;
        if (this.prob_intra_coded == 0) {
            this.prob_intra_coded = 1;
        }
        int n = this.prob_last_coded = rf.inter != 0 ? rfct.get((Object)MVReferenceFrame.LAST_FRAME) * 255 / rf.inter : 128;
        if (this.prob_last_coded == 0) {
            this.prob_last_coded = 1;
        }
        int n2 = this.prob_gf_coded = rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) + rfct.get((Object)MVReferenceFrame.ALTREF_FRAME) != 0 ? rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) * 255 / (rfct.get((Object)MVReferenceFrame.GOLDEN_FRAME) + rfct.get((Object)MVReferenceFrame.ALTREF_FRAME)) : 128;
        if (this.prob_gf_coded == 0) {
            this.prob_gf_coded = 1;
        }
    }

    public void init_temporal_layer_context(int layer, double prev_layer_framerate) {
        this.layer_context[layer] = new LayerContext(this, this.oxcf, layer, prev_layer_framerate);
    }

    public void vp8_change_config(Config oxcfNew) {
        int raw_target_rate;
        CommonData cm = this.common;
        if (cm.getVersion() != oxcfNew.Version) {
            cm.setVersion((byte)oxcfNew.Version);
        }
        Config tempCfg = this.oxcf == null ? oxcfNew : this.oxcf;
        int last_w = tempCfg.Width;
        int last_h = tempCfg.Height;
        int prev_number_of_layers = tempCfg.number_of_layers;
        this.oxcf = oxcfNew.copy();
        switch (this.oxcf.Mode) {
            case REALTIME: {
                this.compressor_speed = 2;
                break;
            }
            case GOODQUALITY: {
                this.compressor_speed = 1;
                break;
            }
            case BESTQUALITY: {
                this.compressor_speed = 0;
            }
        }
        this.auto_worst_q = true;
        this.oxcf.worst_allowed_q = OnyxIf.q_trans[oxcfNew.worst_allowed_q];
        this.oxcf.best_allowed_q = OnyxIf.q_trans[oxcfNew.best_allowed_q];
        this.oxcf.cq_level = OnyxIf.q_trans[this.oxcf.cq_level];
        if (oxcfNew.fixed_q >= 0) {
            this.oxcf.fixed_q = oxcfNew.worst_allowed_q < 0 ? OnyxIf.q_trans[0] : OnyxIf.q_trans[oxcfNew.worst_allowed_q];
            this.oxcf.alt_q = oxcfNew.alt_q < 0 ? OnyxIf.q_trans[0] : OnyxIf.q_trans[oxcfNew.alt_q];
            this.oxcf.key_q = oxcfNew.key_q < 0 ? OnyxIf.q_trans[0] : OnyxIf.q_trans[oxcfNew.key_q];
            this.oxcf.gold_q = oxcfNew.gold_q < 0 ? OnyxIf.q_trans[0] : OnyxIf.q_trans[oxcfNew.gold_q];
        }
        this.ext_refresh_frame_flags_pending = false;
        int n = this.baseline_gf_interval = this.oxcf.alt_freq != 0 ? this.oxcf.alt_freq : 7;
        if (!this.oxcf.error_resilient_mode && this.oxcf.end_usage == EndUsage.STREAM_FROM_SERVER && this.oxcf.Mode == CompressMode.REALTIME) {
            this.baseline_gf_interval = this.gf_interval_onepass_cbr;
        }
        cm.multi_token_partition = this.oxcf.token_partitions = TokenPartition.EIGHT_PARTITION;
        if (!this.use_roi_static_threshold) {
            for (int i = 0; i < 4; ++i) {
                this.segment_encode_breakout[i] = this.oxcf.encode_breakout;
            }
        }
        if (this.oxcf.fixed_q > 127) {
            this.oxcf.fixed_q = (short)127;
        }
        if (this.oxcf.end_usage == EndUsage.LOCAL_FILE_PLAYBACK) {
            this.oxcf.starting_buffer_level = 60000L;
            this.oxcf.optimal_buffer_level = 60000L;
            this.oxcf.maximum_buffer_size = 240000L;
            this.oxcf.starting_buffer_level_in_ms = 60000L;
            this.oxcf.optimal_buffer_level_in_ms = 60000L;
            this.oxcf.maximum_buffer_size_in_ms = 240000L;
        }
        if (this.oxcf.target_bandwidth > (raw_target_rate = (int)((double)((long)this.oxcf.Width * (long)this.oxcf.Height * 8L * 3L) * this.framerate / 1000.0))) {
            this.oxcf.target_bandwidth = raw_target_rate;
        }
        this.oxcf.target_bandwidth *= 1000;
        this.oxcf.starting_buffer_level = OnyxIf.rescale((int)this.oxcf.starting_buffer_level, this.oxcf.target_bandwidth, 1000);
        this.oxcf.optimal_buffer_level = this.oxcf.optimal_buffer_level == 0L ? (long)(this.oxcf.target_bandwidth / 8) : (long)OnyxIf.rescale((int)this.oxcf.optimal_buffer_level, this.oxcf.target_bandwidth, 1000);
        this.oxcf.maximum_buffer_size = this.oxcf.maximum_buffer_size == 0L ? (long)(this.oxcf.target_bandwidth / 8) : (long)OnyxIf.rescale((int)this.oxcf.maximum_buffer_size, this.oxcf.target_bandwidth, 1000);
        if (this.bits_off_target > this.oxcf.maximum_buffer_size) {
            this.buffer_level = this.bits_off_target = this.oxcf.maximum_buffer_size;
        }
        this.vp8_new_framerate(this.framerate);
        this.worst_quality = this.oxcf.worst_allowed_q;
        this.best_quality = this.oxcf.best_allowed_q;
        if (this.active_worst_quality > this.oxcf.worst_allowed_q) {
            this.active_worst_quality = this.oxcf.worst_allowed_q;
        } else if (this.active_worst_quality < this.oxcf.best_allowed_q) {
            this.active_worst_quality = this.oxcf.best_allowed_q;
        }
        if (this.active_best_quality < this.oxcf.best_allowed_q) {
            this.active_best_quality = this.oxcf.best_allowed_q;
        } else if (this.active_best_quality > this.oxcf.worst_allowed_q) {
            this.active_best_quality = this.oxcf.worst_allowed_q;
        }
        this.buffered_mode = this.oxcf.optimal_buffer_level > 0L;
        this.cq_target_quality = this.oxcf.cq_level;
        this.drop_frames_allowed = this.oxcf.allow_df && this.buffered_mode;
        this.target_bandwidth = this.oxcf.target_bandwidth;
        if (this.oxcf.number_of_layers != prev_number_of_layers) {
            if (this.temporal_layer_id > 0) {
                this.temporal_layer_id = 0;
            }
            this.temporal_pattern_counter = 0;
            OnyxIf.reset_temporal_layer_change(this, oxcfNew, prev_number_of_layers);
        }
        if (this.initial_width == 0) {
            this.initial_width = this.oxcf.Width;
            this.initial_height = this.oxcf.Height;
        }
        cm.Width = this.oxcf.Width;
        cm.Height = this.oxcf.Height;
        assert (cm.Width <= this.initial_width);
        assert (cm.Height <= this.initial_height);
        if (this.oxcf.Sharpness > 7) {
            this.oxcf.Sharpness = 7;
        }
        cm.sharpness_level = this.oxcf.Sharpness;
        if (cm.horiz_scale != Scaling.NORMAL || cm.vert_scale != Scaling.NORMAL) {
            int hr = cm.horiz_scale.hr;
            int hs = cm.horiz_scale.hs;
            int vr = cm.vert_scale.hr;
            int vs = cm.vert_scale.hs;
            cm.Width = (hs - 1 + this.oxcf.Width * hr) / hs;
            cm.Height = (vs - 1 + this.oxcf.Height * vr) / vs;
        }
        if (last_w != this.oxcf.Width || last_h != this.oxcf.Height) {
            this.force_next_frame_intra = true;
        }
        if (cm.yv12_fb[0] == null || (cm.Width + 15 & 0xFFFFFFF0) != cm.yv12_fb[cm.frameIdxs.get((Object)((Object)MVReferenceFrame.LAST_FRAME)).intValue()].y_width || (cm.Height + 15 & 0xFFFFFFF0) != cm.yv12_fb[cm.frameIdxs.get((Object)((Object)MVReferenceFrame.LAST_FRAME)).intValue()].y_height || cm.yv12_fb[cm.frameIdxs.get((Object)((Object)MVReferenceFrame.LAST_FRAME)).intValue()].y_width == 0) {
            OnyxIf.dealloc_raw_frame_buffers(this);
            OnyxIf.alloc_raw_frame_buffers(this);
            OnyxIf.vp8_alloc_compressor_data(this);
        }
        if (this.oxcf.fixed_q >= 0) {
            this.last_q[0] = this.oxcf.fixed_q;
            this.last_q[1] = this.oxcf.fixed_q;
        }
        this.Speed = this.oxcf.getCpu_used();
        if (this.oxcf.lag_in_frames == 0) {
            this.oxcf.allow_lag = 0;
        } else if (this.oxcf.lag_in_frames > 25) {
            this.oxcf.lag_in_frames = 25;
        }
        this.alt_ref_source = null;
        this.is_src_frame_alt_ref = false;
    }

    public void vp8_new_framerate(double framerate) {
        if (framerate < 0.1) {
            framerate = 30.0;
        }
        this.framerate = framerate;
        this.output_framerate = framerate;
        this.av_per_frame_bandwidth = this.per_frame_bandwidth = (int)((double)this.oxcf.target_bandwidth / this.output_framerate);
        this.min_frame_bandwidth = this.av_per_frame_bandwidth / 100;
        this.max_gf_interval = (int)(this.output_framerate / 2.0) + 2;
        if (this.max_gf_interval < 12) {
            this.max_gf_interval = 12;
        }
        if (this.oxcf.play_alternate && this.oxcf.lag_in_frames != 0 && this.max_gf_interval > this.oxcf.lag_in_frames - 1) {
            this.max_gf_interval = this.oxcf.lag_in_frames - 1;
        }
    }

    public static interface DiamondSearchIF {
        public void call(Macroblock var1, Block var2, BlockD var3, MV var4, MV var5, int var6, int var7, VarWithNum var8, VarianceFNs var9, ReadOnlyIntArrPointer[] var10, MV var11);
    }

    public static interface RefiningSearchIF {
        public long call(Macroblock var1, Block var2, BlockD var3, MV var4, int var5, int var6, VarianceFNs var7, ReadOnlyIntArrPointer[] var8, MV var9);
    }

    public static interface FullSearchIF {
        public long call(Macroblock var1, Block var2, BlockD var3, MV var4, int var5, int var6, VarianceFNs var7, ReadOnlyIntArrPointer[] var8, MV var9);
    }

    public static interface FractionalMVStepIF {
        public long call(Macroblock var1, Block var2, BlockD var3, MV var4, MV var5, int var6, VarianceFNs var7, ReadOnlyIntArrPointer[] var8, VarianceResults var9);
    }
}

