/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data;

import java.util.Arrays;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.BlockD;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.CommonData;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.Compressor;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.EntropyContextPlanes;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.ModeInfo;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.data.YV12buffer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.CompressMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.FrameType;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBLvlFeatures;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MBPredictionMode;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.enums.MVReferenceFrame;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessGenArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.pointerhelper.FullAccessIntArrPointer;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.vpx.vp8.subpixfns.SubpixFN;

public class MacroblockD {
    public static final int USHIFT = 256;
    public static final int VSHIFT = 320;
    public static final int Y2SHIFT = 384;
    public FullAccessIntArrPointer predictor = new FullAccessIntArrPointer(384);
    public FullAccessIntArrPointer qcoeff = new FullAccessIntArrPointer(400);
    FullAccessIntArrPointer dqcoeff = new FullAccessIntArrPointer(400);
    public FullAccessIntArrPointer eobs = new FullAccessIntArrPointer(25);
    public FullAccessIntArrPointer dequant_y1 = new FullAccessIntArrPointer(16);
    public FullAccessIntArrPointer dequant_y1_dc = new FullAccessIntArrPointer(16);
    public FullAccessIntArrPointer dequant_y2 = new FullAccessIntArrPointer(16);
    public FullAccessIntArrPointer dequant_uv = new FullAccessIntArrPointer(16);
    public FullAccessGenArrPointer<BlockD> block = new FullAccessGenArrPointer(25);
    public int fullpixel_mask;
    public YV12buffer pre;
    public YV12buffer dst;
    public FullAccessGenArrPointer<ModeInfo> mode_info_context;
    public int mode_info_stride;
    public FrameType frame_type;
    public boolean up_available;
    public boolean left_available;
    int[][] recon_above = new int[3][];
    int[][] recon_left = new int[3][];
    int[] recon_left_stride = new int[2];
    public FullAccessGenArrPointer<EntropyContextPlanes> above_context;
    public EntropyContextPlanes left_context;
    public int segmentation_enabled;
    public boolean update_mb_segmentation_map;
    public boolean update_mb_segmentation_data;
    public boolean mb_segement_abs_delta;
    public int[] mb_segment_tree_probs = new int[3];
    public short[][] segment_feature_data = new short[MBLvlFeatures.featureCount][4];
    public boolean mode_ref_lf_delta_enabled;
    public boolean mode_ref_lf_delta_update;
    public byte[] last_ref_lf_deltas = new byte[4];
    public byte[] ref_lf_deltas = new byte[4];
    public byte[] last_mode_lf_deltas = new byte[4];
    public byte[] mode_lf_deltas = new byte[4];
    public int mb_to_left_edge;
    public int mb_to_right_edge;
    public int mb_to_top_edge;
    public int mb_to_bottom_edge;
    public SubpixFN subpixel_predict;
    public SubpixFN subpixel_predict8x4;
    public SubpixFN subpixel_predict8x8;
    public SubpixFN subpixel_predict16x16;
    int corrupted;
    public FullAccessIntArrPointer y_buf = new FullAccessIntArrPointer(836);

    private FullAccessIntArrPointer getArbitraryFreshPtr(int shift) {
        return this.predictor.shallowCopyWithPosInc(shift);
    }

    public FullAccessIntArrPointer getFreshUPredPtr() {
        return this.getArbitraryFreshPtr(256);
    }

    public FullAccessIntArrPointer getFreshVPredPtr() {
        return this.getArbitraryFreshPtr(320);
    }

    public MacroblockD(Compressor cpi) {
        this.setup_features(cpi);
        this.vp8_setup_block_dptrs();
    }

    private void vp8_setup_block_dptrs() {
        int c;
        int r;
        for (r = 0; r < 4; ++r) {
            for (c = 0; c < 4; ++c) {
                this.block.setRel(r * 4 + c, new BlockD(this.predictor.shallowCopyWithPosInc(r * 4 * 16 + c * 4)));
            }
        }
        for (r = 0; r < 2; ++r) {
            for (c = 0; c < 2; ++c) {
                this.block.setRel(16 + r * 2 + c, new BlockD(this.getFreshUPredPtr().shallowCopyWithPosInc(r * 4 * 8 + c * 4)));
            }
        }
        for (r = 0; r < 2; ++r) {
            for (c = 0; c < 2; ++c) {
                this.block.setRel(20 + r * 2 + c, new BlockD(this.getFreshVPredPtr().shallowCopyWithPosInc(r * 4 * 8 + c * 4)));
            }
        }
        this.block.setRel(24, new BlockD(null));
        for (r = 0; r < 25; ++r) {
            this.block.getRel((int)r).qcoeff = this.qcoeff.shallowCopyWithPosInc(r * 16);
            this.block.getRel((int)r).dqcoeff = this.dqcoeff.shallowCopyWithPosInc(r * 16);
            this.block.getRel((int)r).eob = this.eobs.shallowCopyWithPosInc(r);
        }
    }

    public void setup_features(Compressor cpi) {
        if (this.segmentation_enabled != 0) {
            this.update_mb_segmentation_map = true;
            this.update_mb_segmentation_data = true;
        } else {
            this.update_mb_segmentation_map = false;
            this.update_mb_segmentation_data = false;
        }
        this.mode_ref_lf_delta_enabled = false;
        this.mode_ref_lf_delta_update = false;
        Arrays.fill(this.ref_lf_deltas, (byte)0);
        Arrays.fill(this.mode_lf_deltas, (byte)0);
        Arrays.fill(this.last_ref_lf_deltas, (byte)0);
        Arrays.fill(this.last_mode_lf_deltas, (byte)0);
        this.set_default_lf_deltas(cpi);
    }

    private void set_default_lf_deltas(Compressor cpi) {
        this.mode_ref_lf_delta_enabled = true;
        this.mode_ref_lf_delta_update = true;
        Arrays.fill(this.ref_lf_deltas, (byte)0);
        Arrays.fill(this.mode_lf_deltas, (byte)0);
        this.ref_lf_deltas[MVReferenceFrame.INTRA_FRAME.ordinal()] = 2;
        this.ref_lf_deltas[MVReferenceFrame.LAST_FRAME.ordinal()] = 0;
        this.ref_lf_deltas[MVReferenceFrame.GOLDEN_FRAME.ordinal()] = -2;
        this.ref_lf_deltas[MVReferenceFrame.ALTREF_FRAME.ordinal()] = -2;
        this.mode_lf_deltas[0] = 4;
        this.mode_lf_deltas[1] = cpi.oxcf.Mode == CompressMode.REALTIME ? -12 : -2;
        this.mode_lf_deltas[2] = 2;
        this.mode_lf_deltas[3] = 4;
    }

    public void init_encode_frame_mbd_context(Compressor cpi) {
        CommonData cm = cpi.common;
        this.mode_info_context = cm.mi.shallowCopy();
        this.mode_info_stride = cm.mode_info_stride;
        this.frame_type = cm.frame_type;
        this.pre = cm.yv12_fb[cm.frameIdxs.get((Object)MVReferenceFrame.LAST_FRAME)].shallowCopy();
        this.dst = cm.yv12_fb[cm.new_fb_idx].shallowCopy();
        ModeInfo mi = this.mode_info_context.get();
        mi.mbmi.mode = MBPredictionMode.DC_PRED;
        mi.mbmi.uv_mode = MBPredictionMode.DC_PRED;
        this.left_context = cm.left_context;
        this.fullpixel_mask = -1;
        if (cm.full_pixel) {
            this.fullpixel_mask = -8;
        }
    }

    public boolean hasSecondOrder() {
        return ModeInfo.hasSecondOrder(this.mode_info_context);
    }

    public void vp8_build_block_doffsets() {
        int blockNo;
        for (blockNo = 0; blockNo < 16; ++blockNo) {
            this.block.getRel(blockNo).calcBlockYOffset(blockNo, this.dst.y_stride);
        }
        while (blockNo < 20) {
            this.block.getRel(blockNo).calcBlockUVOffset(blockNo, this.dst.uv_stride);
            this.block.getRel(blockNo + 4).calcBlockUVOffset(blockNo, this.dst.uv_stride);
            ++blockNo;
        }
    }
}

