/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class LongArrayList {
    private static final int DEFAULT_GROW_AMOUNT = 128;
    private long[] storage;
    private int _start;
    private int _size;
    private List<long[]> chunks = new ArrayList<long[]>();
    private int growAmount;

    public static LongArrayList createLongArrayList() {
        return new LongArrayList(128);
    }

    public LongArrayList(int growAmount) {
        this.growAmount = growAmount;
        this.storage = new long[growAmount];
    }

    public long[] toArray() {
        long[] result = new long[this._size + this.chunks.size() * this.growAmount - this._start];
        int off = 0;
        for (int i = 0; i < this.chunks.size(); ++i) {
            long[] chunk = this.chunks.get(i);
            int aoff = i == 0 ? this._start : 0;
            System.arraycopy(chunk, aoff, result, off, this.growAmount - aoff);
            off += this.growAmount;
        }
        int aoff = this.chunks.size() == 0 ? this._start : 0;
        System.arraycopy(this.storage, aoff, result, off, this._size - aoff);
        return result;
    }

    public void add(long val) {
        if (this._size >= this.storage.length) {
            this.chunks.add(this.storage);
            this.storage = new long[this.growAmount];
            this._size = 0;
        }
        this.storage[this._size++] = val;
    }

    public void push(long id) {
        this.add(id);
    }

    public void pop() {
        if (this._size == 0) {
            if (this.chunks.size() == 0) {
                return;
            }
            this.storage = this.chunks.remove(this.chunks.size() - 1);
            this._size = this.growAmount;
        }
        if (this.chunks.size() == 0 && this._size == this._start) {
            return;
        }
        --this._size;
    }

    public void set(int index, long value) {
        int chunk = (index += this._start) / this.growAmount;
        int off = index % this.growAmount;
        if (chunk < this.chunks.size()) {
            this.chunks.get((int)chunk)[off] = value;
        } else {
            this.storage[off] = value;
        }
    }

    public long get(int index) {
        int chunk = (index += this._start) / this.growAmount;
        int off = index % this.growAmount;
        return chunk < this.chunks.size() ? this.chunks.get(chunk)[off] : this.storage[off];
    }

    public long shift() {
        if (this.chunks.size() == 0 && this._start >= this._size) {
            throw new IllegalStateException();
        }
        long ret = this.get(0);
        ++this._start;
        if (this.chunks.size() != 0 && this._start >= this.growAmount) {
            this.chunks.remove(0);
            this._start = 0;
        }
        return ret;
    }

    public void fill(int start, int end, long val) {
        start += this._start;
        end += this._start;
        while (start < end) {
            int toFill;
            int chunk = start / this.growAmount;
            int off = start % this.growAmount;
            if (chunk < this.chunks.size()) {
                toFill = Math.min(end - start, this.growAmount - off);
                Arrays.fill(this.chunks.get(chunk), off, off + toFill, val);
                start += toFill;
                continue;
            }
            if (chunk == this.chunks.size()) {
                toFill = Math.min(end - start, this.growAmount - off);
                Arrays.fill(this.storage, off, off + toFill, val);
                this._size = Math.max(this._size, off + toFill);
                start += toFill;
                if (this._size != this.growAmount) continue;
                this.chunks.add(this.storage);
                this._size = 0;
                this.storage = new long[this.growAmount];
                continue;
            }
            this.chunks.add(this.storage);
            this._size = 0;
            this.storage = new long[this.growAmount];
        }
    }

    public int size() {
        return this.chunks.size() * this.growAmount + this._size - this._start;
    }

    public void addAll(long[] other) {
        int otherOff = 0;
        while (otherOff < other.length) {
            int copyAmount = Math.min(other.length - otherOff, this.growAmount - this._size);
            if (copyAmount < 32) {
                for (int i = 0; i < copyAmount; ++i) {
                    this.storage[this._size++] = other[otherOff++];
                }
            } else {
                System.arraycopy(other, otherOff, this.storage, this._size, copyAmount);
                this._size += copyAmount;
                otherOff += copyAmount;
            }
            if (otherOff >= other.length) continue;
            this.chunks.add(this.storage);
            this.storage = new long[this.growAmount];
            this._size = 0;
        }
    }

    public void clear() {
        this.chunks.clear();
        this._size = 0;
        this._start = 0;
    }

    public boolean contains(long needle) {
        int coff;
        for (int c = 0; c < this.chunks.size(); ++c) {
            int coff2;
            long[] chunk = this.chunks.get(c);
            for (int i = coff2 = c == 0 ? this._start : 0; i < this.growAmount; ++i) {
                if (chunk[i] != needle) continue;
                return true;
            }
        }
        for (int i = coff = this.chunks.size() == 0 ? this._start : 0; i < this._size; ++i) {
            if (this.storage[i] != needle) continue;
            return true;
        }
        return false;
    }
}

