/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.muxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.creeperhost.blockshot.repack.org.jcodec.common.AudioCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.Muxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.MuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.CuesFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.MKVType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.SeekHeadFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlBase;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlBin;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlDate;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlFloat;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlMaster;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlString;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlUint;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.MkvBlock;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.muxer.MKVMuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.util.EbmlUtil;

public class MKVMuxer
implements Muxer {
    private List<MKVMuxerTrack> tracks;
    private MKVMuxerTrack audioTrack;
    private MKVMuxerTrack videoTrack;
    private EbmlMaster mkvInfo;
    private EbmlMaster mkvTracks;
    private EbmlMaster mkvCues;
    private EbmlMaster mkvSeekHead;
    private SeekableByteChannel sink;
    private CuesFactory cf;
    private long afterebmlHeader;
    private long beforeClusters;
    private long beforeCues;
    private long afterSegment;
    private long eof;
    private static Map<Codec, String> codec2mkv = new HashMap<Codec, String>();

    public MKVMuxer(SeekableByteChannel s) {
        this.sink = s;
        this.tracks = new ArrayList<MKVMuxerTrack>();
        try {
            this.defaultEbmlHeader().mux(this.sink);
            this.afterebmlHeader = this.sink.position();
            this.mkvTracks = (EbmlMaster)MKVType.createByType(MKVType.Tracks);
            this.sink.setPosition(this.afterebmlHeader + 12L + 68L + 50L + 106L);
            this.beforeClusters = this.sink.position();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public MKVMuxerTrack createVideoTrack(VideoCodecMeta meta, String codecId) {
        if (this.videoTrack == null) {
            this.cf = new CuesFactory(this.beforeClusters, this.tracks.size() + 1);
            this.videoTrack = new MKVMuxerTrack(this.sink, this.cf);
            this.tracks.add(this.videoTrack);
            this.videoTrack.codecId = codecId;
            this.videoTrack.videoMeta = meta;
            this.videoTrack.trackNo = this.tracks.size();
            this.muxTrack(this.videoTrack);
        }
        return this.videoTrack;
    }

    @Override
    public void finish() throws IOException {
        for (MKVMuxerTrack track : this.tracks) {
            track.finish();
        }
        this.beforeCues = this.sink.position();
        this.mkvCues = (EbmlMaster)MKVType.createByType(MKVType.Cues);
        this.muxCues();
        this.mkvCues.mux(this.sink);
        this.eof = this.sink.position();
        this.sink.setPosition(this.afterebmlHeader);
        ByteBuffer segmentHeader = ByteBuffer.allocate(12);
        segmentHeader.put(MKVType.Segment.id);
        segmentHeader.put(EbmlUtil.ebmlEncodeLen(this.eof - this.afterebmlHeader - 12L, 8));
        segmentHeader.flip();
        this.sink.write(segmentHeader);
        this.afterSegment = this.sink.position();
        this.mkvInfo = this.muxInfo();
        this.mkvSeekHead = this.muxSeekHead();
        this.mkvSeekHead.mux(this.sink);
        this.mkvInfo.mux(this.sink);
        this.mkvTracks.mux(this.sink);
        long endOfHeaders = this.sink.position();
        long needsVoid = this.beforeClusters - endOfHeaders;
        ByteBuffer voidFiller = ByteBuffer.allocate((int)needsVoid);
        voidFiller.put(MKVType.Void.id);
        voidFiller.put(EbmlUtil.ebmlEncodeLen(needsVoid - 1L - 8L, 8));
        voidFiller.flip();
        this.sink.write(voidFiller);
    }

    private EbmlMaster defaultEbmlHeader() {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.EBML);
        MKVMuxer.createLong(master, MKVType.EBMLVersion, 1L);
        MKVMuxer.createLong(master, MKVType.EBMLReadVersion, 1L);
        MKVMuxer.createLong(master, MKVType.EBMLMaxIDLength, 4L);
        MKVMuxer.createLong(master, MKVType.EBMLMaxSizeLength, 8L);
        MKVMuxer.createString(master, MKVType.DocType, "webm");
        MKVMuxer.createLong(master, MKVType.DocTypeVersion, 2L);
        MKVMuxer.createLong(master, MKVType.DocTypeReadVersion, 2L);
        return master;
    }

    private EbmlMaster muxInfo() {
        EbmlMaster master = (EbmlMaster)MKVType.createByType(MKVType.Info);
        Rational fr = this.tracks.get(0).getFrameRate();
        MKVMuxer.createLong(master, MKVType.TimecodeScale, (long)(fr.toDouble() * 1.0E9));
        MKVMuxer.createString(master, MKVType.WritingApp, "JCodec");
        MKVMuxer.createString(master, MKVType.MuxingApp, "JCodec");
        List<MKVMuxerTrack> tracks2 = this.tracks;
        long max = 0L;
        for (MKVMuxerTrack track : tracks2) {
            MkvBlock lastBlock = track.lastFrame;
            if (lastBlock.absoluteTimecode <= max) continue;
            max = lastBlock.absoluteTimecode;
        }
        MKVMuxer.createDouble(master, MKVType.Duration, (double)(max + 1L) * 1.0);
        MKVMuxer.createDate(master, MKVType.DateUTC, new Date());
        return master;
    }

    private void muxTrack(MKVMuxerTrack track) {
        try {
            track.trackStart = this.sink.position();
            EbmlMaster trackEntryElem = (EbmlMaster)MKVType.createByType(MKVType.TrackEntry);
            MKVMuxer.createLong(trackEntryElem, MKVType.TrackNumber, track.trackNo);
            MKVMuxer.createLong(trackEntryElem, MKVType.TrackUID, track.trackNo);
            if (MKVMuxerTrack.MKVMuxerTrackType.VIDEO.equals((Object)track.type)) {
                MKVMuxer.createLong(trackEntryElem, MKVType.TrackType, 1L);
                MKVMuxer.createString(trackEntryElem, MKVType.Name, "Track " + track.trackNo + " Video");
                MKVMuxer.createString(trackEntryElem, MKVType.CodecID, track.codecId);
                EbmlMaster trackVideoElem = (EbmlMaster)MKVType.createByType(MKVType.Video);
                MKVMuxer.createLong(trackVideoElem, MKVType.PixelWidth, track.videoMeta.getSize().getWidth());
                MKVMuxer.createLong(trackVideoElem, MKVType.PixelHeight, track.videoMeta.getSize().getHeight());
                trackEntryElem.add(trackVideoElem);
            } else {
                MKVMuxer.createLong(trackEntryElem, MKVType.TrackType, 2L);
                MKVMuxer.createString(trackEntryElem, MKVType.Name, "Track " + track.trackNo + " Audio");
                MKVMuxer.createString(trackEntryElem, MKVType.CodecID, track.codecId);
            }
            this.mkvTracks.add(trackEntryElem);
        }
        catch (IOException ioex) {
            throw new RuntimeException(ioex);
        }
    }

    private void muxCues() {
        EbmlMaster indexedCues = this.cf.createCues();
        for (EbmlBase aCuePoint : indexedCues.children) {
            this.mkvCues.add(aCuePoint);
        }
    }

    private EbmlMaster muxSeekHead() {
        SeekHeadFactory shi = new SeekHeadFactory(this.beforeCues - this.afterSegment);
        shi.add(this.mkvInfo);
        shi.add(this.mkvTracks);
        shi.add(this.mkvCues);
        return shi.indexSeekHead();
    }

    public static void createLong(EbmlMaster parent, MKVType type, long value) {
        EbmlUint se = (EbmlUint)MKVType.createByType(type);
        se.setUint(value);
        parent.add(se);
    }

    public static void createString(EbmlMaster parent, MKVType type, String value) {
        EbmlString se = (EbmlString)MKVType.createByType(type);
        se.setString(value);
        parent.add(se);
    }

    public static void createDate(EbmlMaster parent, MKVType type, Date value) {
        EbmlDate se = (EbmlDate)MKVType.createByType(type);
        se.setDate(value);
        parent.add(se);
    }

    public static void createBuffer(EbmlMaster parent, MKVType type, ByteBuffer value) {
        EbmlBin se = (EbmlBin)MKVType.createByType(type);
        se.setBuf(value);
        parent.add(se);
    }

    public static void createDouble(EbmlMaster parent, MKVType type, double value) {
        try {
            EbmlFloat se = (EbmlFloat)MKVType.createByType(type);
            se.setDouble(value);
            parent.add(se);
        }
        catch (ClassCastException cce) {
            throw new RuntimeException("Element of type " + type + " can't be cast to EbmlFloat", cce);
        }
    }

    @Override
    public MuxerTrack addVideoTrack(Codec codec, VideoCodecMeta meta) {
        return this.createVideoTrack(meta, codec2mkv.get(codec));
    }

    @Override
    public MuxerTrack addAudioTrack(Codec codec, AudioCodecMeta meta) {
        this.audioTrack = new MKVMuxerTrack(this.sink, this.cf);
        this.audioTrack.type = MKVMuxerTrack.MKVMuxerTrackType.AUDIO;
        this.tracks.add(this.audioTrack);
        this.audioTrack.codecId = codec2mkv.get(codec);
        this.audioTrack.trackNo = this.tracks.size();
        this.muxTrack(this.audioTrack);
        return this.audioTrack;
    }

    static {
        codec2mkv.put(Codec.H264, "V_MPEG4/ISO/AVC");
        codec2mkv.put(Codec.VP8, "V_VP8");
        codec2mkv.put(Codec.VP9, "V_VP9");
    }
}

