/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.muxer;

import java.io.IOException;
import net.creeperhost.blockshot.repack.org.jcodec.common.MuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.VideoCodecMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Rational;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.CuesFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.MKVType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.EbmlMaster;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.boxes.MkvBlock;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mkv.muxer.MKVMuxer;

public class MKVMuxerTrack
implements MuxerTrack {
    public MKVMuxerTrackType type = MKVMuxerTrackType.VIDEO;
    public VideoCodecMeta videoMeta;
    public String codecId;
    public int trackNo;
    public long trackStart;
    public EbmlMaster firstCluster;
    public MkvBlock lastFrame;
    private int frameDuration;
    private Rational frameRate;
    private MkvBlock clusterHeadFrame;
    private EbmlMaster currentCluster;
    final SeekableByteChannel os;
    final CuesFactory cf;
    static final int DEFAULT_TIMESCALE = 1000000000;
    static final int NANOSECONDS_IN_A_MILISECOND = 1000000;
    static final int MULTIPLIER = 1000;

    public MKVMuxerTrack(SeekableByteChannel os, CuesFactory cf) {
        this.os = os;
        this.cf = cf;
    }

    public int getTimescale() {
        return 1000000;
    }

    public Rational getFrameRate() {
        return this.frameRate;
    }

    @Override
    public void addFrame(Packet outPacket) {
        MkvBlock frame = MkvBlock.anyFrame(this.trackNo, 0, outPacket.getData(), outPacket.isKeyFrame());
        if (this.frameRate == null || (long)this.frameRate.den != outPacket.duration) {
            this.frameRate = new Rational((int)outPacket.duration, outPacket.timescale);
        }
        frame.absoluteTimecode = outPacket.getPts();
        this.lastFrame = frame;
        if (outPacket.isKeyFrame()) {
            this.muxCurrentCluster();
            this.currentCluster = this.singleBlockedCluster(frame);
            if (this.firstCluster == null) {
                this.firstCluster = this.currentCluster;
            }
        } else {
            if (this.currentCluster == null) {
                throw new RuntimeException("The first frame must be a keyframe in an MKV file");
            }
            frame.timecode = (int)(frame.absoluteTimecode - this.clusterHeadFrame.absoluteTimecode);
            this.currentCluster.add(frame);
        }
    }

    public long getTrackNo() {
        return this.trackNo;
    }

    private void muxCurrentCluster() {
        if (this.currentCluster != null) {
            try {
                this.currentCluster.mux(this.os);
                this.cf.add(CuesFactory.CuePointMock.make(this.currentCluster));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void finish() {
        this.muxCurrentCluster();
    }

    private EbmlMaster singleBlockedCluster(MkvBlock aBlock) {
        EbmlMaster mkvCluster = (EbmlMaster)MKVType.createByType(MKVType.Cluster);
        MKVMuxer.createLong(mkvCluster, MKVType.Timecode, aBlock.absoluteTimecode - (long)aBlock.timecode);
        mkvCluster.add(aBlock);
        this.clusterHeadFrame = aBlock;
        return mkvCluster;
    }

    public static enum MKVMuxerTrackType {
        VIDEO,
        AUDIO;

    }
}

