/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.Callbacks;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.BoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.IBoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class BoxUtil {
    public static Box parseBox(ByteBuffer input, Header childAtom, IBoxFactory factory) {
        Box box = factory.newBox(childAtom);
        if (childAtom.getBodySize() < 0x8000000L) {
            box.parse(input);
            return box;
        }
        return new Box.LeafBox(Header.createHeader("free", 8L));
    }

    public static Box parseChildBox(ByteBuffer input, IBoxFactory factory) {
        ByteBuffer fork = input.duplicate();
        while (input.remaining() >= 4 && fork.getInt() == 0) {
            input.getInt();
        }
        if (input.remaining() < 4) {
            return null;
        }
        Header childAtom = Header.read(input);
        if (childAtom != null && (long)input.remaining() >= childAtom.getBodySize()) {
            return BoxUtil.parseBox(NIOUtils.read(input, (int)childAtom.getBodySize()), childAtom, factory);
        }
        return null;
    }

    public static <T extends Box> T as(Class<T> class1, Box.LeafBox box) {
        try {
            Box res = (Box)Platform.newInstance(class1, new Object[]{box.getHeader()});
            res.parse(box.getData().duplicate());
            return (T)res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean containsBox(NodeBox box, String path) {
        Box b = NodeBox.findFirstPath(box, Box.class, new String[]{path});
        return b != null;
    }

    public static boolean containsBox2(NodeBox box, String path1, String path2) {
        Box b = NodeBox.findFirstPath(box, Box.class, new String[]{path1, path2});
        return b != null;
    }

    public static ByteBuffer writeBox(Box b) {
        int estimateSize = b.estimateSize();
        ByteBuffer buf = ByteBuffer.allocate(estimateSize);
        b.write(buf);
        ((Buffer)buf).flip();
        return buf;
    }

    public static void hideBox(Box box) {
        box.getHeader().setFourcc("free");
    }

    public static boolean revealBox(NodeBox parent, Box.LeafBox box, String newFourcc) {
        if (!"free".equals(box.getFourcc())) {
            return false;
        }
        Box newBox = BoxUtil.parseBox(box.getData(), Header.createHeader(newFourcc, 0L), BoxFactory.getDefault());
        parent.replaceBoxWith(box, newBox);
        return true;
    }

    public static Box.LeafBox searchHiddenBox(NodeBox parent, Callbacks.Callback1Into1<Boolean, Box.LeafBox> evaluator) {
        for (Box box : parent.getBoxes()) {
            if (!"free".equals(box.getHeader().getFourcc()) || !evaluator.call((Box.LeafBox)box).booleanValue()) continue;
            return (Box.LeafBox)box;
        }
        return null;
    }
}

