/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.Chunk;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleSizesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleToChunkBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TimeToSampleBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class ChunkReader {
    private int curChunk;
    private int sampleNo;
    private int s2cIndex;
    private int ttsInd = 0;
    private int ttsSubInd = 0;
    private long chunkTv = 0L;
    private long[] chunkOffsets;
    private SampleToChunkBox.SampleToChunkEntry[] sampleToChunk;
    private SampleSizesBox stsz;
    private TimeToSampleBox.TimeToSampleEntry[] tts;
    private SampleDescriptionBox stsd;
    private final SeekableByteChannel input;
    private final SampleEntry[] entries;

    public ChunkReader(TrakBox trakBox, SeekableByteChannel input) {
        TimeToSampleBox stts = trakBox.getStts();
        this.tts = stts.getEntries();
        ChunkOffsetsBox stco = trakBox.getStco();
        ChunkOffsets64Box co64 = trakBox.getCo64();
        this.stsz = trakBox.getStsz();
        SampleToChunkBox stsc = trakBox.getStsc();
        this.chunkOffsets = stco != null ? stco.getChunkOffsets() : co64.getChunkOffsets();
        this.sampleToChunk = stsc.getSampleToChunk();
        this.stsd = trakBox.getStsd();
        this.entries = trakBox.getSampleEntries();
        this.input = input;
    }

    public boolean hasNext() {
        return this.curChunk < this.chunkOffsets.length;
    }

    public Chunk next() throws IOException {
        if (this.curChunk >= this.chunkOffsets.length) {
            return null;
        }
        if (this.s2cIndex + 1 < this.sampleToChunk.length && (long)(this.curChunk + 1) == this.sampleToChunk[this.s2cIndex + 1].getFirst()) {
            ++this.s2cIndex;
        }
        int sampleCount = this.sampleToChunk[this.s2cIndex].getCount();
        int[] samplesDur = null;
        int sampleDur = -1;
        if (this.ttsSubInd + sampleCount <= this.tts[this.ttsInd].getSampleCount()) {
            sampleDur = this.tts[this.ttsInd].getSampleDuration();
            this.ttsSubInd += sampleCount;
        } else {
            samplesDur = new int[sampleCount];
            for (int i = 0; i < sampleCount; ++i) {
                if (this.ttsSubInd >= this.tts[this.ttsInd].getSampleCount() && this.ttsInd < this.tts.length - 1) {
                    this.ttsSubInd = 0;
                    ++this.ttsInd;
                }
                samplesDur[i] = this.tts[this.ttsInd].getSampleDuration();
                ++this.ttsSubInd;
            }
        }
        int size = -1;
        int[] sizes2 = null;
        if (this.stsz.getDefaultSize() > 0) {
            size = this.stsz.getDefaultSize();
        } else {
            sizes2 = Platform.copyOfRangeI(this.stsz.getSizes(), this.sampleNo, this.sampleNo + sampleCount);
        }
        int eno = this.sampleToChunk[this.s2cIndex].getEntry();
        SampleEntry se = this.entries[eno - 1];
        if (se.getDrefInd() != 1) {
            throw new IOException("Multiple sample entries not supported");
        }
        Chunk chunk = new Chunk(this.chunkOffsets[this.curChunk], this.chunkTv, sampleCount, size, sizes2, sampleDur, samplesDur, eno);
        this.chunkTv += (long)chunk.getDuration();
        this.sampleNo += sampleCount;
        ++this.curChunk;
        if (this.input != null) {
            this.input.setPosition(chunk.getOffset());
            chunk.setData(NIOUtils.fetchFromChannel(this.input, (int)chunk.getSize()));
        }
        return chunk;
    }

    public int size() {
        return this.chunkOffsets.length;
    }

    public List<Chunk> readAll() throws IOException {
        if (this.input != null) {
            throw new IllegalStateException("Reading all chunk data to memory is costy.");
        }
        ArrayList<Chunk> result = new ArrayList<Chunk>();
        Chunk chunk = null;
        while ((chunk = this.next()) != null) {
            result.add(chunk);
        }
        return result;
    }
}

