/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.IntArrayList;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.Chunk;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.AliasBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsets64Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.ChunkOffsetsBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.DataInfoBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.DataRefBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MediaInfoBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleSizesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;

public class ChunkWriter {
    private long[] offsets;
    private SampleEntry[] entries;
    private final SeekableByteChannel input;
    private int curChunk;
    private SeekableByteChannel out;
    byte[] buf = new byte[8092];
    private TrakBox trak;
    private IntArrayList sampleSizes;
    private int sampleSize;
    private int sampleCount;

    public ChunkWriter(TrakBox trak, SeekableByteChannel input, SeekableByteChannel out) {
        this.entries = trak.getSampleEntries();
        ChunkOffsetsBox stco = trak.getStco();
        ChunkOffsets64Box co64 = trak.getCo64();
        int size = stco != null ? stco.getChunkOffsets().length : co64.getChunkOffsets().length;
        this.input = input;
        this.offsets = new long[size];
        this.out = out;
        this.trak = trak;
        this.sampleSizes = IntArrayList.createIntArrayList();
    }

    public void apply() {
        NodeBox stbl = NodeBox.findFirstPath(this.trak, NodeBox.class, Box.path("mdia.minf.stbl"));
        stbl.removeChildren(new String[]{"stco", "co64"});
        stbl.add(ChunkOffsets64Box.createChunkOffsets64Box(this.offsets));
        ChunkWriter.cleanDrefs(this.trak);
        SampleSizesBox stsz = this.sampleCount != 0 ? SampleSizesBox.createSampleSizesBox(this.sampleSize, this.sampleCount) : SampleSizesBox.createSampleSizesBox2(this.sampleSizes.toArray());
        stbl.replaceBox(stsz);
    }

    public static void cleanDrefs(TrakBox trak) {
        DataRefBox dref;
        MediaInfoBox minf = trak.getMdia().getMinf();
        DataInfoBox dinf = trak.getMdia().getMinf().getDinf();
        if (dinf == null) {
            dinf = DataInfoBox.createDataInfoBox();
            minf.add(dinf);
        }
        if ((dref = dinf.getDref()) == null) {
            dref = DataRefBox.createDataRefBox();
            dinf.add(dref);
        }
        dref.getBoxes().clear();
        dref.add(AliasBox.createSelfRef());
        SampleEntry[] sampleEntries = trak.getSampleEntries();
        for (int i = 0; i < sampleEntries.length; ++i) {
            SampleEntry entry = sampleEntries[i];
            entry.setDrefInd((short)1);
        }
    }

    public void write(Chunk chunk) throws IOException {
        SampleEntry se = this.entries[chunk.getEntry() - 1];
        if (se.getDrefInd() != 1) {
            throw new IOException("Multiple sample entries not supported");
        }
        long pos = this.out.position();
        ByteBuffer chunkData = chunk.getData();
        if (chunkData == null) {
            this.input.setPosition(chunk.getOffset());
            chunkData = NIOUtils.fetchFromChannel(this.input, (int)chunk.getSize());
        }
        this.out.write(chunkData);
        this.offsets[this.curChunk++] = pos;
        if (chunk.getSampleSize() == -1) {
            if (this.sampleCount != 0) {
                this.unpackSampleSizes();
            }
            this.sampleSizes.addAll(chunk.getSampleSizes());
        } else if (this.sampleSizes.size() != 0) {
            for (int i = 0; i < chunk.getSampleCount(); ++i) {
                this.sampleSizes.add(chunk.getSampleSize());
            }
        } else {
            if (this.sampleCount == 0) {
                this.sampleSize = chunk.getSampleSize();
            } else if (this.sampleSize != chunk.getSampleSize()) {
                this.unpackSampleSizes();
                for (int i = 0; i < chunk.getSampleCount(); ++i) {
                    this.sampleSizes.add(chunk.getSampleSize());
                }
            }
            this.sampleCount += chunk.getSampleCount();
        }
    }

    private void unpackSampleSizes() {
        this.sampleSizes = new IntArrayList(128);
        this.sampleSizes.fill(0, this.sampleCount, this.sampleSize);
        this.sampleCount = 0;
    }
}

