/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.Preconditions;
import net.creeperhost.blockshot.repack.org.jcodec.common.StringUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.UsedViaReflection;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.IBoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public abstract class Box {
    public Header header;
    public static final int MAX_BOX_SIZE = 0x8000000;

    @UsedViaReflection
    public Box(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public abstract void parse(ByteBuffer var1);

    public void write(ByteBuffer buf) {
        ByteBuffer dup = buf.duplicate();
        NIOUtils.skip(buf, 8);
        this.doWrite(buf);
        this.header.setBodySize(buf.position() - dup.position() - 8);
        Preconditions.checkState(this.header.headerSize() == 8L);
        this.header.write(dup);
    }

    protected abstract void doWrite(ByteBuffer var1);

    public abstract int estimateSize();

    public String getFourcc() {
        return this.header.getFourcc();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.dump(sb);
        return sb.toString();
    }

    protected void dump(StringBuilder sb) {
        sb.append("{\"tag\":\"" + this.header.getFourcc() + "\"}");
    }

    public static Box terminatorAtom() {
        return Box.createLeafBox(new Header(Platform.stringFromBytes(new byte[4])), ByteBuffer.allocate(0));
    }

    public static String[] path(String path) {
        return StringUtils.splitC(path, '.');
    }

    public static LeafBox createLeafBox(Header atom, ByteBuffer data) {
        LeafBox leaf = new LeafBox(atom);
        leaf.data = data;
        return leaf;
    }

    public static Box parseBox(ByteBuffer input, Header childAtom, IBoxFactory factory) {
        Box box = factory.newBox(childAtom);
        if (childAtom.getBodySize() < 0x8000000L) {
            box.parse(input);
            return box;
        }
        return new LeafBox(Header.createHeader("free", 8L));
    }

    public static <T extends Box> T asBox(Class<T> class1, Box box) {
        try {
            Box res = (Box)Platform.newInstance(class1, new Object[]{box.getHeader()});
            ByteBuffer buffer = ByteBuffer.allocate((int)box.getHeader().getBodySize());
            box.doWrite(buffer);
            ((Buffer)buffer).flip();
            res.parse(buffer);
            return (T)res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class LeafBox
    extends Box {
        ByteBuffer data;

        public LeafBox(Header atom) {
            super(atom);
        }

        public LeafBox(Header atom, ByteBuffer data) {
            super(atom);
            this.data = data;
        }

        @Override
        public void parse(ByteBuffer input) {
            this.data = NIOUtils.read(input, (int)this.header.getBodySize());
        }

        public ByteBuffer getData() {
            return this.data.duplicate();
        }

        @Override
        protected void doWrite(ByteBuffer out) {
            NIOUtils.write(out, this.data);
        }

        @Override
        public int estimateSize() {
            return this.data.remaining() + Header.estimateHeaderSize(this.data.remaining());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface AtomField {
        public int idx();
    }
}

