/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MetaDataSampleEntry;

public class TextMetaDataSampleEntry
extends MetaDataSampleEntry {
    private String contentEncoding;
    private String mimeFormat;

    public TextMetaDataSampleEntry(String contentEncoding, String mimeFormat) {
        super(Header.createHeader("mett", 0L));
        this.contentEncoding = contentEncoding;
        this.mimeFormat = mimeFormat;
    }

    public TextMetaDataSampleEntry(Header atom) {
        super(atom);
    }

    @Override
    public void parse(ByteBuffer input) {
        String asString = new String(NIOUtils.toArray(input));
        if (asString.startsWith("application")) {
            this.setDrefInd((short)1);
        } else {
            super.parse(input);
        }
        this.contentEncoding = NIOUtils.readNullTermString(input);
        this.mimeFormat = NIOUtils.readNullTermString(input);
        this.parseExtensions(input);
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        NIOUtils.writeNullTermString(out, this.contentEncoding);
        NIOUtils.writeNullTermString(out, this.mimeFormat);
        this.writeExtensions(out);
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public String getMimeFormat() {
        return this.mimeFormat;
    }
}

