/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.FullBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class URIBox
extends FullBox {
    private String uri;

    public static String fourcc() {
        return "uri ";
    }

    public static URIBox createUriBox(String uri) {
        URIBox uriBox = new URIBox(new Header(URIBox.fourcc()));
        uriBox.uri = uri;
        return uriBox;
    }

    public URIBox(Header atom) {
        super(atom);
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        this.uri = NIOUtils.readNullTermStringCharset(input, "UTF-8");
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        NIOUtils.writeNullTermString(out, this.uri);
    }

    @Override
    public int estimateSize() {
        return 13 + Platform.getBytesForCharset(this.uri, "UTF-8").length;
    }

    public String getUri() {
        return this.uri;
    }
}

