/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.IBoxFactory;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Header;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MetaBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MetaValue;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.UdtaMetaBox;

public class UdtaBox
extends NodeBox {
    private static final String META_GPS = "\u00a9xyz";
    private static final int LOCALE_EN_US = 5575;
    private static Map<String, Integer> knownMetadata = new HashMap<String, Integer>();
    private static final String FOURCC = "udta";

    public static UdtaBox createUdtaBox() {
        return new UdtaBox(Header.createHeader(UdtaBox.fourcc(), 0L));
    }

    @Override
    public void setFactory(final IBoxFactory _factory) {
        this.factory = new IBoxFactory(){

            @Override
            public Box newBox(Header header) {
                if (header.getFourcc().equals(UdtaMetaBox.fourcc())) {
                    UdtaMetaBox box = new UdtaMetaBox(header);
                    box.setFactory(_factory);
                    return box;
                }
                return _factory.newBox(header);
            }
        };
    }

    public UdtaBox(Header atom) {
        super(atom);
    }

    public MetaBox meta() {
        return NodeBox.findFirst(this, MetaBox.class, MetaBox.fourcc());
    }

    public static String fourcc() {
        return FOURCC;
    }

    public List<MetaValue> getUserDataString(String id) {
        Box.LeafBox leafBox = NodeBox.findFirst(this, Box.LeafBox.class, id);
        if (leafBox == null) {
            return null;
        }
        ByteBuffer bb = leafBox.getData();
        return this.parseStringData(bb);
    }

    private List<MetaValue> parseStringData(ByteBuffer bb) {
        ArrayList<MetaValue> result = new ArrayList<MetaValue>();
        while (bb.remaining() >= 4) {
            short lang = 0;
            int sz = NIOUtils.duplicate(bb).getInt();
            if (4 + sz > bb.remaining()) {
                sz = bb.getShort();
                if (2 + sz > bb.remaining()) break;
                lang = bb.getShort();
            }
            if (sz == 0) continue;
            byte[] bytes = new byte[sz];
            bb.get(bytes);
            result.add(MetaValue.createStringWithLocale(new String(bytes), lang));
        }
        return result;
    }

    public ByteBuffer serializeStringData(List<MetaValue> data) {
        int totalLen = 0;
        for (MetaValue mv : data) {
            String string = mv.getString();
            if (string == null) continue;
            totalLen += string.getBytes().length + 4;
        }
        if (totalLen == 0) {
            return null;
        }
        byte[] bytes = new byte[totalLen];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (MetaValue mv : data) {
            String string = mv.getString();
            if (string == null) continue;
            bb.putShort((short)string.length());
            bb.putShort((short)mv.getLocale());
            bb.put(string.getBytes());
        }
        ((Buffer)bb).flip();
        return bb;
    }

    public void setUserDataString(String id, List<MetaValue> data) {
        ByteBuffer bb = this.serializeStringData(data);
        Box.LeafBox box = Box.LeafBox.createLeafBox(Header.createHeader(id, bb.remaining() + 4), bb);
        this.replaceBox(box);
    }

    public String latlng() {
        List<MetaValue> data = this.getUserDataString(META_GPS);
        if (data == null || data.isEmpty()) {
            return null;
        }
        return data.get(0).getString();
    }

    public void setLatlng(String value) {
        ArrayList<MetaValue> list = new ArrayList<MetaValue>();
        list.add(MetaValue.createStringWithLocale(value, 5575));
        this.setUserDataString(META_GPS, list);
    }

    public Map<Integer, MetaValue> getMetadata() {
        HashMap<Integer, MetaValue> result = new HashMap<Integer, MetaValue>();
        List<Box> boxes = this.getBoxes();
        for (Box box : boxes) {
            byte[] bytes;
            if (!knownMetadata.containsKey(box.getFourcc()) || !(box instanceof Box.LeafBox)) continue;
            ByteBuffer data = ((Box.LeafBox)box).getData();
            int type = knownMetadata.get(box.getFourcc());
            if (type != 1) continue;
            List<MetaValue> value = this.parseStringData(data);
            try {
                bytes = box.getFourcc().getBytes("iso8859-1");
            }
            catch (UnsupportedEncodingException e) {
                bytes = null;
            }
            if (bytes == null || value == null || value.isEmpty()) continue;
            result.put(ByteBuffer.wrap(bytes).getInt(), value.get(0));
        }
        return result;
    }

    public void setMetadata(Map<Integer, MetaValue> udata) {
        Set<Map.Entry<Integer, MetaValue>> entrySet = udata.entrySet();
        for (Map.Entry<Integer, MetaValue> entry : entrySet) {
            LinkedList<MetaValue> lst = new LinkedList<MetaValue>();
            lst.add(entry.getValue());
            ByteBuffer bb = this.serializeStringData(lst);
            byte[] bytes = new byte[4];
            ByteBuffer.wrap(bytes).putInt(entry.getKey());
            try {
                Box.LeafBox box = Box.LeafBox.createLeafBox(Header.createHeader(new String(bytes, "iso8859-1"), bb.remaining() + 4), bb);
                this.replaceBox(box);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
    }

    static {
        knownMetadata.put(META_GPS, 1);
    }
}

