/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.aac.AACUtils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.aac.ADTSParser;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.H264Utils;
import net.creeperhost.blockshot.repack.org.jcodec.codecs.h264.mp4.AvcCBox;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.SeekableDemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.model.Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Packet;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.VideoSampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.MP4DemuxerTrackMeta;

public class CodecMP4DemuxerTrack
implements SeekableDemuxerTrack {
    private ByteBuffer codecPrivate;
    private AvcCBox avcC;
    private SeekableDemuxerTrack other;
    private Codec codec;

    public CodecMP4DemuxerTrack(SeekableDemuxerTrack other) {
        this.other = other;
        DemuxerTrackMeta meta = other.getMeta();
        this.codec = meta.getCodec();
        if (this.codec == Codec.H264) {
            this.avcC = H264Utils.parseAVCC((VideoSampleEntry)((MP4DemuxerTrackMeta)meta).getSampleEntries()[0]);
        }
        this.codecPrivate = meta.getCodecPrivate();
    }

    @Override
    public Packet nextFrame() throws IOException {
        Packet nextFrame = this.other.nextFrame();
        if (nextFrame == null) {
            return null;
        }
        ByteBuffer newData = this.convertPacket(nextFrame.getData());
        return MP4Packet.createMP4PacketWithData((MP4Packet)nextFrame, newData);
    }

    public ByteBuffer convertPacket(ByteBuffer data) {
        if (this.codecPrivate != null) {
            if (this.codec == Codec.H264) {
                ByteBuffer annexbCoded = H264Utils.decodeMOVPacket(data, this.avcC);
                if (H264Utils.isByteBufferIDRSlice(annexbCoded)) {
                    ByteBuffer newData = NIOUtils.combineBuffers(Arrays.asList(this.codecPrivate, annexbCoded));
                    return newData;
                }
                return annexbCoded;
            }
            if (this.codec == Codec.AAC) {
                ADTSParser.Header adts = AACUtils.streamInfoToADTS(this.codecPrivate, true, 1, data.remaining());
                ByteBuffer adtsRaw = ByteBuffer.allocate(7);
                ADTSParser.write(adts, adtsRaw);
                ByteBuffer newData = NIOUtils.combineBuffers(Arrays.asList(adtsRaw, data));
                return newData;
            }
        }
        return data;
    }

    @Override
    public DemuxerTrackMeta getMeta() {
        return this.other.getMeta();
    }

    @Override
    public boolean gotoFrame(long frameNo) throws IOException {
        return this.other.gotoFrame(frameNo);
    }

    @Override
    public boolean gotoSyncFrame(long frameNo) throws IOException {
        return this.other.gotoSyncFrame(frameNo);
    }

    @Override
    public long getCurFrame() {
        return this.other.getCurFrame();
    }

    @Override
    public void seek(double second) throws IOException {
        this.other.seek(second);
    }

    public SeekableDemuxerTrack getOther() {
        return this.other;
    }
}

