/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.creeperhost.blockshot.repack.org.jcodec.common.Codec;
import net.creeperhost.blockshot.repack.org.jcodec.common.Demuxer;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.DemuxerTrackMeta;
import net.creeperhost.blockshot.repack.org.jcodec.common.Fourcc;
import net.creeperhost.blockshot.repack.org.jcodec.common.SeekableDemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.common.TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.common.UsedViaReflection;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.NIOUtils;
import net.creeperhost.blockshot.repack.org.jcodec.common.io.SeekableByteChannel;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4TrackType;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.MP4Util;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.Box;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.HandlerBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.MovieBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.NodeBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleEntry;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.SampleSizesBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.boxes.TrakBox;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.CodecMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.MP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.PCMMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.containers.mp4.demuxer.TimecodeMP4DemuxerTrack;
import net.creeperhost.blockshot.repack.org.jcodec.platform.Platform;

public class MP4Demuxer
implements Demuxer {
    private List<SeekableDemuxerTrack> tracks;
    private TimecodeMP4DemuxerTrack timecodeTrack;
    MovieBox movie;
    protected SeekableByteChannel input;

    public static MP4Demuxer createMP4Demuxer(SeekableByteChannel input) throws IOException {
        return new MP4Demuxer(input);
    }

    public static MP4Demuxer createRawMP4Demuxer(SeekableByteChannel input) throws IOException {
        return new MP4Demuxer(input){

            @Override
            protected SeekableDemuxerTrack newTrack(TrakBox trak) {
                return new MP4DemuxerTrack(this.movie, trak, this.input);
            }
        };
    }

    private SeekableDemuxerTrack fromTrakBox(TrakBox trak) {
        boolean isPCM;
        SampleSizesBox stsz = NodeBox.findFirstPath(trak, SampleSizesBox.class, Box.path("mdia.minf.stbl.stsz"));
        if (stsz == null) {
            return null;
        }
        SampleEntry[] sampleEntries = (SampleEntry[])NodeBox.findAllPath((Box)trak, SampleEntry.class, (String[])new String[]{"mdia", "minf", "stbl", "stsd", null});
        boolean bl = sampleEntries.length != 0 ? sampleEntries[0] instanceof AudioSampleEntry && this.isPCMCodec(Codec.codecByFourcc(sampleEntries[0].getFourcc())) : (isPCM = false);
        if (stsz.getDefaultSize() != 0 && isPCM) {
            return new PCMMP4DemuxerTrack(this.movie, trak, this.input);
        }
        return this.newTrack(trak);
    }

    private boolean isPCMCodec(Codec codec) {
        return codec != null && codec.isPcm();
    }

    protected SeekableDemuxerTrack newTrack(TrakBox trak) {
        return new CodecMP4DemuxerTrack(new MP4DemuxerTrack(this.movie, trak, this.input));
    }

    MP4Demuxer(SeekableByteChannel input) throws IOException {
        this.input = input;
        this.tracks = new LinkedList<SeekableDemuxerTrack>();
        this.findMovieBox(input);
    }

    private void findMovieBox(SeekableByteChannel input) throws IOException {
        MP4Util.Movie mv = MP4Util.parseFullMovieChannel(input);
        if (mv == null || mv.getMoov() == null) {
            throw new IOException("Could not find movie meta information box");
        }
        this.movie = mv.getMoov();
        this.processHeader(this.movie);
    }

    private void processHeader(NodeBox moov) throws IOException {
        DemuxerTrack video;
        TrakBox tt = null;
        TrakBox[] trakBoxs = (TrakBox[])NodeBox.findAll((Box)moov, TrakBox.class, (String)"trak");
        for (int i = 0; i < trakBoxs.length; ++i) {
            TrakBox trak = trakBoxs[i];
            SampleEntry se = NodeBox.findFirstPath(trak, SampleEntry.class, new String[]{"mdia", "minf", "stbl", "stsd", null});
            if (se != null && "tmcd".equals(se.getFourcc())) {
                tt = trak;
                continue;
            }
            SeekableDemuxerTrack trakBox = this.fromTrakBox(trak);
            if (trakBox == null) continue;
            this.tracks.add(trakBox);
        }
        if (tt != null && (video = this.getVideoTrack()) != null) {
            this.timecodeTrack = new TimecodeMP4DemuxerTrack(this.movie, tt, this.input);
        }
    }

    public static MP4TrackType getTrackType(TrakBox trak) {
        HandlerBox handler = NodeBox.findFirstPath(trak, HandlerBox.class, Box.path("mdia.hdlr"));
        return MP4TrackType.fromHandler(handler.getComponentSubType());
    }

    public DemuxerTrack getVideoTrack() {
        for (SeekableDemuxerTrack demuxerTrack : this.tracks) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.VIDEO) continue;
            return demuxerTrack;
        }
        return null;
    }

    public MovieBox getMovie() {
        return this.movie;
    }

    public List<SeekableDemuxerTrack> getTracks() {
        return new ArrayList<SeekableDemuxerTrack>(this.tracks);
    }

    public List<DemuxerTrack> getVideoTracks() {
        ArrayList<DemuxerTrack> result = new ArrayList<DemuxerTrack>();
        for (SeekableDemuxerTrack demuxerTrack : this.tracks) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.VIDEO) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    public List<DemuxerTrack> getAudioTracks() {
        ArrayList<DemuxerTrack> result = new ArrayList<DemuxerTrack>();
        for (SeekableDemuxerTrack demuxerTrack : this.tracks) {
            DemuxerTrackMeta meta = demuxerTrack.getMeta();
            if (meta.getType() != TrackType.AUDIO) continue;
            result.add(demuxerTrack);
        }
        return result;
    }

    public TimecodeMP4DemuxerTrack getTimecodeTrack() {
        return this.timecodeTrack;
    }

    @UsedViaReflection
    public static int probe(ByteBuffer b) {
        ByteBuffer fork = b.duplicate();
        int success = 0;
        int total = 0;
        while (fork.remaining() >= 8) {
            long len = Platform.unsignedInt(fork.getInt());
            int fcc = fork.getInt();
            int hdrLen = 8;
            if (len == 1L) {
                len = fork.getLong();
                hdrLen = 16;
            } else if (len < 8L) break;
            if (fcc == Fourcc.ftyp && len < 64L || fcc == Fourcc.moov && len < 0x6400000L || fcc == Fourcc.free || fcc == Fourcc.mdat || fcc == Fourcc.wide) {
                ++success;
            }
            ++total;
            if (len >= Integer.MAX_VALUE) break;
            NIOUtils.skip(fork, (int)(len - (long)hdrLen));
        }
        return total == 0 ? 0 : success * 100 / total;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }
}

